/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.mixin.client.isleofberk.layer;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonRideableUtility;
import com.GACMD.isleofberk.entity.base.render.layer.BaseSaddleAndChestsLayer;
import com.GACMD.isleofberk.entity.base.render.render.BaseRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ResourceUtil;
import nordmods.iobvariantloader.util.ducks.DragonModelCacheHelper;
import nordmods.iobvariantloader.util.model_redirect.ModelRedirectUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

@Mixin(value={BaseSaddleAndChestsLayer.class})
public abstract class SaddleLayerMixin<T extends ADragonBase>
extends GeoLayerRenderer<T> {
    @Shadow
    private BaseRenderer<T> baseRenderer;

    @Shadow
    protected abstract ResourceLocation getSaddleTexture();

    public SaddleLayerMixin(IGeoRenderer<T> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation id;
        ADragonRideableUtility dragonRideableUtility;
        if (!ResourceUtil.isResourceReloadFinished) {
            return;
        }
        if (!(dragon instanceof ADragonRideableUtility) || !(dragonRideableUtility = (ADragonRideableUtility)dragon).m_6254_() && !dragonRideableUtility.hasChest()) {
            return;
        }
        if (((DragonModelCacheHelper)dragon).getSaddleTextureLocationCache() != null) {
            this.renderSaddle(((DragonModelCacheHelper)dragon).getSaddleTextureLocationCache(), matrixStackIn, bufferIn, packedLightIn, dragon, partialTicks);
            return;
        }
        if (!((Boolean)IoBVariantLoader.clientConfig.disableNamedVariants.get()).booleanValue() && ResourceUtil.isValid(id = ModelRedirectUtil.getCustomSaddlePath(dragon, this.baseRenderer.getDragonFolder()))) {
            ((DragonModelCacheHelper)dragon).setSaddleTextureLocationCache(id);
            this.renderSaddle(id, matrixStackIn, bufferIn, packedLightIn, dragon, partialTicks);
            return;
        }
        id = ModelRedirectUtil.getVariantSaddlePath(dragon, this.baseRenderer.getDragonFolder());
        if (ResourceUtil.isValid(id)) {
            ((DragonModelCacheHelper)dragon).setSaddleTextureLocationCache(id);
            this.renderSaddle(id, matrixStackIn, bufferIn, packedLightIn, dragon, partialTicks);
            return;
        }
        ((DragonModelCacheHelper)dragon).setSaddleTextureLocationCache(this.getSaddleTexture());
        this.renderSaddle(this.getSaddleTexture(), matrixStackIn, bufferIn, packedLightIn, dragon, partialTicks);
    }

    private void renderSaddle(ResourceLocation saddle, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T dragon, float partialTicks) {
        RenderType cameo = RenderType.m_110452_((ResourceLocation)saddle);
        GeoModel model = this.getEntityModel().getModel(this.baseRenderer.getGeoModelProvider().getModelLocation(dragon));
        this.getRenderer().render(model, dragon, partialTicks, cameo, matrixStackIn, bufferIn, bufferIn.m_6299_(cameo), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

