/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.mixin.common.dragon;

import com.GACMD.isleofberk.entity.dragons.nightfury.NightFury;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import nordmods.iobvariantloader.mixin.common.dragon.ADragonBaseMixin;
import nordmods.iobvariantloader.util.extras.ExtrasUtil;
import nordmods.iobvariantloader.util.sound_redirect.SoundRedirectUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import software.bernie.geckolib3.core.manager.AnimationData;

@Mixin(value={NightFury.class})
public abstract class NightFuryMixin
extends ADragonBaseMixin {
    protected NightFuryMixin(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public String getFromBaseVariant() {
        return switch (this.getDragonVariant()) {
            case 1 -> "sentinel";
            case 2 -> "karma";
            case 3 -> "arsian";
            case 4 -> "svartr";
            case 5 -> "albino";
            case 101 -> "toothless";
            default -> "night_fury";
        };
    }

    @Override
    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void swapDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "death")) {
            cir.setReturnValue(null);
        }
    }

    @Override
    @Inject(method={"getTameSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapTameSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "tame")) {
            cir.setReturnValue(null);
        }
    }

    @Override
    @Inject(method={"get1stAttackSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapBiteSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "bite")) {
            cir.setReturnValue(null);
        }
    }

    @Override
    @Inject(method={"getProjectileSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapFireSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "fire")) {
            cir.setReturnValue(null);
        }
    }

    @WrapOperation(method={"playerFireProjectile"}, at={@At(value="INVOKE", target="Lcom/GACMD/isleofberk/entity/dragons/nightfury/NightFury;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V")})
    private void swapWeakFireSound(NightFury instance, SoundEvent soundEvent, float a, float b, Operation<Void> original) {
        if (!SoundRedirectUtil.playSound(this, "fire_weak")) {
            original.call(new Object[]{instance, soundEvent, Float.valueOf(a), Float.valueOf(b)});
        }
    }

    @Inject(method={"registerControllers"}, at={@At(value="TAIL")}, remap=false)
    private void registerSoundController(AnimationData data, CallbackInfo ci) {
        try {
            Class<?> clazz = data.getClass();
            String methodName = "getAnimationControllers";
            Method method = clazz.getMethod(methodName, new Class[0]);
            Map result = (Map)method.invoke((Object)data, new Object[0]);
            result.forEach((name, contr) -> contr.registerSoundListener(event -> SoundRedirectUtil.playSound(this, event.sound)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject(method={"isItemStackForTaming"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getTamingItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean isCorrect = ExtrasUtil.isTamingItem(this.getSpecies(false), this.getVariantName(), stack);
        if (isCorrect != null) {
            cir.setReturnValue((Object)isCorrect);
        }
    }

    @Inject(method={"isBreedingFood"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getBreedingItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean isCorrect = ExtrasUtil.isBreedingItem(this.getSpecies(false), this.getVariantName(), stack);
        if (isCorrect != null) {
            cir.setReturnValue((Object)isCorrect);
        }
    }
}

