/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.mixin.common.dragon;

import com.GACMD.isleofberk.entity.dragons.skrill.Skrill;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import nordmods.iobvariantloader.mixin.common.dragon.ADragonBaseMixin;
import nordmods.iobvariantloader.util.extras.ExtrasUtil;
import nordmods.iobvariantloader.util.sound_redirect.SoundRedirectUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import software.bernie.geckolib3.core.manager.AnimationData;

@Mixin(value={Skrill.class})
public abstract class SkrillMixin
extends ADragonBaseMixin {
    protected SkrillMixin(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public String getFromBaseVariant() {
        return switch (this.getDragonVariant()) {
            case 1 -> "stormshadow";
            case 2 -> "icebane";
            case 3 -> "fryrir";
            case 4 -> "crimson";
            case 5 -> "nemesis";
            case 6 -> "tempest";
            case 7 -> "pickle";
            case 8 -> "zen";
            case 9 -> "spark";
            case 10 -> "albino";
            case 11 -> "moonshock";
            case 12 -> "spring_storm";
            default -> "skrill";
        };
    }

    @Override
    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void swapDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "death")) {
            cir.setReturnValue(null);
        }
    }

    @Override
    @Inject(method={"getTameSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapTameSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "tame")) {
            cir.setReturnValue(null);
        }
    }

    @Override
    @Inject(method={"get1stAttackSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapBiteSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "bite")) {
            cir.setReturnValue(null);
        }
    }

    @Override
    @Inject(method={"getProjectileSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapFireSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "fire")) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"registerControllers"}, at={@At(value="TAIL")}, remap=false)
    private void registerSoundController(AnimationData data, CallbackInfo ci) {
        try {
            Class<?> clazz = data.getClass();
            String methodName = "getAnimationControllers";
            Method method = clazz.getMethod(methodName, new Class[0]);
            Map result = (Map)method.invoke((Object)data, new Object[0]);
            result.forEach((name, contr) -> contr.registerSoundListener(event -> SoundRedirectUtil.playSound(this, event.sound)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject(method={"isItemStackForTaming"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getTamingItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean isCorrect = ExtrasUtil.isTamingItem(this.getSpecies(false), this.getVariantName(), stack);
        if (isCorrect != null) {
            cir.setReturnValue((Object)isCorrect);
        }
    }

    @Inject(method={"isBreedingFood"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getBreedingItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean isCorrect = ExtrasUtil.isBreedingItem(this.getSpecies(false), this.getVariantName(), stack);
        if (isCorrect != null) {
            cir.setReturnValue((Object)isCorrect);
        }
    }
}

