/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.mixin.common.egg;

import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.items.DragonEggItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ResourceUtil;
import nordmods.iobvariantloader.util.dragon_variant_spawner.DragonVariantSpawner;
import nordmods.iobvariantloader.util.dragon_variant_spawner.DragonVariantSpawnerUtil;
import nordmods.iobvariantloader.util.ducks.DragonSpeciesHelper;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import nordmods.iobvariantloader.util.model_redirect.ModelRedirectUtil;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DragonEggItem.class})
public abstract class DragonEggItemMixin
extends Item
implements DragonSpeciesHelper {
    @Shadow
    private Supplier<? extends EntityType<? extends LivingEntity>> eggSpecies;

    public DragonEggItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public String getSpecies(boolean isClient) {
        String dragonID;
        ResourceLocation resourcelocation = this.getRegistryName();
        return switch (dragonID = resourcelocation.m_135815_().replace("_egg", "")) {
            default -> dragonID;
            case "monstrous_nightmare" -> {
                if (isClient) {
                    yield "nightmare";
                }
                yield dragonID;
            }
            case "nadder" -> "deadly_nadder";
        };
    }

    @Inject(method={"appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V"}, at={@At(value="TAIL")})
    private void addVariantTooltip(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced, CallbackInfo ci) {
        String variant = pStack.m_41782_() ? pStack.m_41783_().m_128461_("VariantName") : "";
        pTooltipComponents.add((Component)ResourceUtil.getVariantNameTooltip(variant, this));
    }

    public Component m_7626_(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            String variant = itemStack.m_41783_().m_128461_("VariantName");
            if (ModelRedirectUtil.dragonModelRedirects.containsKey(this.getSpecies(true)) && ModelRedirectUtil.dragonModelRedirects.get(this.getSpecies(true)).containsKey(variant) && ModelRedirectUtil.dragonModelRedirects.get(this.getSpecies(true)).get(variant).eggItemName().isPresent()) {
                return new TranslatableComponent(ModelRedirectUtil.dragonModelRedirects.get(this.getSpecies(true)).get(variant).eggItemName().get());
            }
        }
        return super.m_7626_(itemStack);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack playerHeldItem = pContext.m_43722_();
        Level level = pContext.m_43725_();
        ADragonEggBase eggEntity = (ADragonEggBase)this.eggSpecies.get().m_20615_(level);
        if (eggEntity != null) {
            eggEntity.m_20219_(pContext.m_43720_());
            if (!level.m_5776_()) {
                String variant = "";
                if (playerHeldItem.m_41782_()) {
                    variant = playerHeldItem.m_41783_().m_128461_("VariantName");
                }
                if (eggEntity instanceof VariantNameHelper) {
                    VariantNameHelper helper = (VariantNameHelper)eggEntity;
                    if (level instanceof ServerLevelAccessor) {
                        ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
                        if (!variant.isEmpty()) {
                            helper.setVariantName(variant);
                        } else if (((Boolean)IoBVariantLoader.config.assignEggVariantOnPlaced.get()).booleanValue()) {
                            List<DragonVariantSpawner> variants = DragonVariantSpawnerUtil.getVariantsFor(this.getSpecies(false));
                            DragonVariantSpawnerUtil.assignVariantFromList(serverLevelAccessor, (Entity)eggEntity, false, variants);
                        }
                    }
                }
                if (playerHeldItem.m_41788_()) {
                    eggEntity.m_6593_(playerHeldItem.m_41611_());
                }
                level.m_7967_((Entity)eggEntity);
            }
        }
        playerHeldItem.m_41774_(1);
        return InteractionResult.SUCCESS;
    }
}

