/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import nordmods.iobvariantloader.IoBVariantLoaderClient;
import nordmods.iobvariantloader.network.NetworkUtil;

public record PlayDragonSoundS2CPacket(int dragonId, ResourceLocation id, float volume, float pitch) {
    private static final ResourceLocation ID = new ResourceLocation("iobvariantloader", "play_dragon_sound");
    private static final String VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ID).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();

    public static PlayDragonSoundS2CPacket read(FriendlyByteBuf byteBuf) {
        int dragonID = byteBuf.readInt();
        ResourceLocation id = new ResourceLocation(NetworkUtil.readString((ByteBuf)byteBuf));
        float volume = byteBuf.readFloat();
        float pitch = byteBuf.readFloat();
        return new PlayDragonSoundS2CPacket(dragonID, id, volume, pitch);
    }

    public void write(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.dragonId());
        NetworkUtil.writeString((ByteBuf)byteBuf, this.id().toString());
        byteBuf.writeFloat(this.volume());
        byteBuf.writeFloat(this.pitch());
    }

    public static boolean handleServer(PlayDragonSoundS2CPacket packet, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        return true;
    }

    public static void init() {
        SimpleChannel.MessageBuilder builder = INSTANCE.messageBuilder(PlayDragonSoundS2CPacket.class, 0, NetworkDirection.PLAY_TO_CLIENT).decoder(PlayDragonSoundS2CPacket::read).encoder(PlayDragonSoundS2CPacket::write);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            builder.consumer(IoBVariantLoaderClient::handlePlayDragonSoundPacket);
        } else {
            builder.consumer(PlayDragonSoundS2CPacket::handleServer);
        }
        builder.add();
    }
}

