/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import nordmods.iobvariantloader.network.NetworkUtil;
import nordmods.iobvariantloader.util.sound_redirect.SoundRedirect;
import nordmods.iobvariantloader.util.sound_redirect.SoundRedirectUtil;

public record SyncSoundRedirectsWithClientS2CPacket(Map<String, Map<String, List<SoundRedirect>>> soundRedirectMap) {
    private static final ResourceLocation ID = new ResourceLocation("iobvariantloader", "sync_sound_redirects");
    private static final String VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ID).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();

    public static SyncSoundRedirectsWithClientS2CPacket read(FriendlyByteBuf byteBuf) {
        Map map = byteBuf.m_178368_(NetworkUtil::readString, byteBuf1 -> byteBuf1.m_178368_(NetworkUtil::readString, SyncSoundRedirectsWithClientS2CPacket::readSoundRedirectList));
        return new SyncSoundRedirectsWithClientS2CPacket(map);
    }

    public void write(FriendlyByteBuf byteBuf) {
        byteBuf.m_178355_(SoundRedirectUtil.soundRedirectMap, NetworkUtil::writeString, (byteBuf1, variantSoundRedirects) -> byteBuf1.m_178355_(variantSoundRedirects, NetworkUtil::writeString, SyncSoundRedirectsWithClientS2CPacket::writeSoundRedirectList));
    }

    public static boolean handle(SyncSoundRedirectsWithClientS2CPacket packet, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        if (context.getDirection().getReceptionSide().isClient()) {
            SoundRedirectUtil.soundRedirectMap.clear();
            SoundRedirectUtil.clearCahce();
            SoundRedirectUtil.soundRedirectMap.putAll(packet.soundRedirectMap);
        }
        return true;
    }

    public static void init() {
        INSTANCE.messageBuilder(SyncSoundRedirectsWithClientS2CPacket.class, 0, NetworkDirection.PLAY_TO_CLIENT).decoder(SyncSoundRedirectsWithClientS2CPacket::read).encoder(SyncSoundRedirectsWithClientS2CPacket::write).consumer(SyncSoundRedirectsWithClientS2CPacket::handle).add();
        MinecraftForge.EVENT_BUS.addListener(SyncSoundRedirectsWithClientS2CPacket::onJoinedEvent);
    }

    private static void onJoinedEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (INSTANCE.isRemotePresent(serverPlayer.f_8906_.m_6198_()) && !serverPlayer.f_8906_.m_6198_().m_129531_()) {
                INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncSoundRedirectsWithClientS2CPacket(SoundRedirectUtil.soundRedirectMap));
            }
        }
    }

    private static void writeSoundRedirectList(ByteBuf buf, List<SoundRedirect> list) {
        buf.writeInt(list.size());
        list.forEach(soundRedirect -> {
            NetworkUtil.writeString(buf, soundRedirect.name());
            NetworkUtil.writeString(buf, soundRedirect.sound());
            buf.writeFloat(soundRedirect.volume());
            buf.writeFloat(soundRedirect.pitch());
        });
    }

    private static List<SoundRedirect> readSoundRedirectList(ByteBuf buf) {
        int size = buf.readInt();
        ArrayList<SoundRedirect> list = new ArrayList<SoundRedirect>(size);
        for (int i = 0; i < size; ++i) {
            String name = NetworkUtil.readString(buf);
            String sound = NetworkUtil.readString(buf);
            float volume = buf.readFloat();
            float pitch = buf.readFloat();
            list.add(new SoundRedirect(name, sound, volume, pitch));
        }
        return list;
    }
}

