/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.dragon_variant_spawner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ServerLevelAccessor;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.dragon_variant_spawner.DragonVariantSpawner;
import nordmods.iobvariantloader.util.ducks.DefaultVariantNameHelper;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import org.jetbrains.annotations.Nullable;

public final class DragonVariantSpawnerUtil {
    public static final Map<String, List<DragonVariantSpawner>> dragonVariants = new HashMap<String, List<DragonVariantSpawner>>();

    public static List<DragonVariantSpawner> getVariantsFor(String name) {
        return dragonVariants.get(name);
    }

    public static synchronized void add(String name, List<DragonVariantSpawner> variants) {
        List<DragonVariantSpawner> content = dragonVariants.get(name);
        if (content != null) {
            ArrayList<DragonVariantSpawner> copy = new ArrayList<DragonVariantSpawner>();
            copy.addAll(variants);
            copy.addAll(content);
            dragonVariants.put(name, copy);
        } else {
            dragonVariants.put(name, variants);
        }
    }

    public static void debugPrint() {
        if (!((Boolean)IoBVariantLoader.config.logDragonVariantSpawns.get()).booleanValue()) {
            return;
        }
        for (Map.Entry<String, List<DragonVariantSpawner>> entry : dragonVariants.entrySet()) {
            for (DragonVariantSpawner variant : entry.getValue()) {
                List<String> biomesByTag;
                List<String> biomesById;
                String variantName = variant.name();
                StringBuilder conditions = new StringBuilder();
                conditions.append("Weight: ").append(variant.weight()).append("\n");
                conditions.append("Breeding Weight: ").append(variant.breedingWeight()).append("\n");
                if (variant.hasAllowedBiomes()) {
                    conditions.append("Allowed Biomes: \n");
                    biomesById = variant.allowedBiomes().biomesById();
                    biomesByTag = variant.allowedBiomes().biomesByTag();
                    if (!biomesById.isEmpty()) {
                        conditions.append("- Biomes by ID: ");
                        biomesById.forEach(id -> conditions.append((String)id).append(" "));
                        conditions.append("\n");
                    }
                    if (!biomesByTag.isEmpty()) {
                        conditions.append("- Biomes by tag: ");
                        biomesByTag.forEach(id -> conditions.append((String)id).append(" "));
                        conditions.append("\n");
                    }
                }
                if (variant.hasBannedBiomes()) {
                    conditions.append("Banned Biomes: \n");
                    biomesById = variant.bannedBiomes().biomesById();
                    biomesByTag = variant.bannedBiomes().biomesByTag();
                    if (!biomesById.isEmpty()) {
                        conditions.append("- Biomes by ID: ");
                        biomesById.forEach(id -> conditions.append((String)id).append(" "));
                        conditions.append("\n");
                    }
                    if (!biomesByTag.isEmpty()) {
                        conditions.append("- Biomes by tag: ");
                        biomesByTag.forEach(id -> conditions.append((String)id).append(" "));
                        conditions.append("\n");
                    }
                }
                conditions.append("Altitude Restriction: \n");
                conditions.append("- Min: ").append(variant.altitudeRestriction().min()).append("\n");
                conditions.append("- Max: ").append(variant.altitudeRestriction().max()).append("\n");
                conditions.append("Surface Restriction: ").append((Object)variant.surfaceRestriction()).append("\n");
                IoBVariantLoader.LOGGER.info("{}: variant {} was loaded with following conditions:\n{}", new Object[]{entry.getKey(), variantName, conditions});
            }
        }
    }

    public static boolean isVariantIn(DragonVariantSpawner.BiomeRestrictions restrictions, ServerLevelAccessor world, BlockPos blockPos) {
        ResourceLocation name;
        Holder biome = world.m_204166_(blockPos);
        List<Object> id = restrictions.hasBiomesByIdList() ? restrictions.biomesById() : List.of();
        List<Object> tags = restrictions.hasBiomesByTagList() ? restrictions.biomesByTag() : List.of();
        boolean isIn = false;
        for (String string : id) {
            name = new ResourceLocation(string);
            if (!biome.m_203373_(name)) continue;
            isIn = true;
            break;
        }
        if (!isIn) {
            for (String string : tags) {
                name = new ResourceLocation(string);
                if (!biome.m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)name))) continue;
                isIn = true;
                break;
            }
        }
        return isIn;
    }

    public static void assignVariant(ServerLevelAccessor world, Entity entity, boolean naturalSpawn) {
        DragonVariantSpawnerUtil.assignVariant(world, entity, naturalSpawn, null);
    }

    public static void assignVariant(ServerLevelAccessor world, Entity entity, boolean naturalSpawn, @Nullable VariantNameHelper sourceEntity) {
        List<DragonVariantSpawner> variants = sourceEntity != null ? DragonVariantSpawnerUtil.getVariantsFor(sourceEntity) : DragonVariantSpawnerUtil.getVariantsFor((VariantNameHelper)entity);
        DragonVariantSpawnerUtil.assignVariantFromList(world, entity, naturalSpawn, variants);
    }

    public static void assignVariantFromList(ServerLevelAccessor world, Entity entity, boolean naturalSpawn, List<DragonVariantSpawner> variants) {
        if (!(entity instanceof VariantNameHelper)) {
            return;
        }
        VariantNameHelper helper = (VariantNameHelper)entity;
        if (variants != null) {
            BlockPos pos = entity.m_142538_();
            long totalWeight = 0L;
            for (DragonVariantSpawner variant : variants) {
                if (!variant.surfaceRestriction().canSpawn(pos, world) || variant.hasBannedBiomes() && DragonVariantSpawnerUtil.isVariantIn(variant.bannedBiomes(), world, pos) || variant.altitudeRestriction().min() > pos.m_123342_() || pos.m_123342_() > variant.altitudeRestriction().max()) continue;
                if (variant.hasAllowedBiomes()) {
                    if (!DragonVariantSpawnerUtil.isVariantIn(variant.allowedBiomes(), world, pos)) continue;
                    if (naturalSpawn) {
                        totalWeight += (long)variant.weight();
                        continue;
                    }
                    totalWeight += (long)variant.breedingWeight();
                    continue;
                }
                if (naturalSpawn) {
                    totalWeight += (long)variant.weight();
                    continue;
                }
                totalWeight += (long)variant.breedingWeight();
            }
            if (totalWeight <= 0L) {
                if (entity instanceof DefaultVariantNameHelper) {
                    DefaultVariantNameHelper defaultVariantNameHelper = (DefaultVariantNameHelper)entity;
                    helper.setVariantName(defaultVariantNameHelper.getFromBaseVariant());
                } else {
                    helper.setVariantName("");
                }
                IoBVariantLoader.LOGGER.warn("Failed to get variant for {} ({}) at {}, setting default", new Object[]{entity.m_7755_().getString(), entity.m_6095_().getRegistryName().m_135815_(), pos.m_123344_()});
                return;
            }
            long roll = ((LivingEntity)entity).m_21187_().nextLong(totalWeight);
            long previousBound = 0L;
            for (DragonVariantSpawner variant : variants) {
                if (!variant.surfaceRestriction().canSpawn(pos, world) || variant.hasBannedBiomes() && DragonVariantSpawnerUtil.isVariantIn(variant.bannedBiomes(), world, pos) || variant.altitudeRestriction().min() > pos.m_123342_() || pos.m_123342_() > variant.altitudeRestriction().max()) continue;
                if (variant.hasAllowedBiomes()) {
                    if (!DragonVariantSpawnerUtil.isVariantIn(variant.allowedBiomes(), world, pos)) continue;
                    if (roll >= previousBound && roll < previousBound + (long)(naturalSpawn ? variant.weight() : variant.breedingWeight())) {
                        helper.setVariantName(variant.name());
                        break;
                    }
                    if (naturalSpawn) {
                        previousBound += (long)variant.weight();
                        continue;
                    }
                    previousBound += (long)variant.breedingWeight();
                    continue;
                }
                if (roll >= previousBound && roll < previousBound + (long)(naturalSpawn ? variant.weight() : variant.breedingWeight())) {
                    helper.setVariantName(variant.name());
                    break;
                }
                if (naturalSpawn) {
                    previousBound += (long)variant.weight();
                    continue;
                }
                previousBound += (long)variant.breedingWeight();
            }
        }
    }

    public static boolean hasNaturalVariantsForSpot(String entity, ServerLevelAccessor world, BlockPos pos) {
        List<DragonVariantSpawner> variants = DragonVariantSpawnerUtil.getVariantsFor(entity);
        for (DragonVariantSpawner variant : variants) {
            if (variant.weight() <= 0 || !variant.surfaceRestriction().canSpawn(pos, world) || variant.hasBannedBiomes() && DragonVariantSpawnerUtil.isVariantIn(variant.bannedBiomes(), world, pos) || variant.altitudeRestriction().min() > pos.m_123342_() || pos.m_123342_() > variant.altitudeRestriction().max() || variant.hasAllowedBiomes() && !DragonVariantSpawnerUtil.isVariantIn(variant.allowedBiomes(), world, pos)) continue;
            return true;
        }
        return false;
    }

    public static List<DragonVariantSpawner> getVariantsFor(VariantNameHelper entity) {
        ResourceLocation resourcelocation = EntityType.m_20613_((EntityType)((Entity)entity).m_6095_());
        return DragonVariantSpawnerUtil.getVariantsFor(resourcelocation.m_135815_());
    }

    @Nullable
    public static DragonVariantSpawner getVariantByName(VariantNameHelper entity, String name) {
        List<DragonVariantSpawner> list = DragonVariantSpawnerUtil.getVariantsFor(entity);
        for (DragonVariantSpawner variant : list) {
            if (!variant.name().equals(name)) continue;
            return variant;
        }
        return null;
    }
}

