/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.extras;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ResourceUtil;
import nordmods.iobvariantloader.util.extras.Extras;
import nordmods.iobvariantloader.util.extras.ExtrasUtil;

public class ExtrasReloadListener
extends SimpleJsonResourceReloadListener {
    public ExtrasReloadListener() {
        super(new GsonBuilder().create(), "extras");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        ExtrasUtil.extrasMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            String dragon;
            ResourceLocation fileID = entry.getKey();
            JsonObject entryObject = entry.getValue().getAsJsonObject();
            String string = dragon = entryObject.has("dragon") ? entryObject.get("dragon").getAsString() : fileID.m_135815_();
            if (!ResourceUtil.AllowedValues.isValid(dragon, false)) {
                IoBVariantLoader.LOGGER.warn("Extras entry {} does not match any dragon id and will be skipped", (Object)fileID);
                continue;
            }
            HashMap<String, Extras> toPut = new HashMap<String, Extras>();
            JsonArray array = entryObject.get("extras").getAsJsonArray();
            for (JsonElement elem : array) {
                String name = elem.getAsJsonObject().get("name").getAsString();
                Extras extras = (Extras)Extras.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)elem).getOrThrow(false, error -> {
                    IoBVariantLoader.LOGGER.error("Failed to parse extras data file {} correctly. Check for syntax errors and try again", (Object)fileID.toString());
                    IoBVariantLoader.LOGGER.error(error);
                });
                toPut.put(name, extras);
            }
            ExtrasUtil.add(dragon, toPut);
        }
        ExtrasUtil.debugPrint();
    }
}

