/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.hitbox_redirect;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.phys.Vec3;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ducks.DragonSpeciesHelper;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import nordmods.iobvariantloader.util.hitbox_redirect.HitboxRedirect;
import org.jetbrains.annotations.Nullable;

public class HitboxRedirectUtil {
    public static final Map<String, Map<String, HitboxRedirect>> dragonHitboxRedirects = new HashMap<String, Map<String, HitboxRedirect>>();

    public static synchronized void add(String dragon, Map<String, HitboxRedirect> overrides) {
        Map<String, HitboxRedirect> content = dragonHitboxRedirects.get(dragon);
        if (content != null) {
            content.putAll(overrides);
            dragonHitboxRedirects.put(dragon, content);
        } else {
            dragonHitboxRedirects.put(dragon, overrides);
        }
    }

    public static void debugPrint() {
        if (!((Boolean)IoBVariantLoader.config.logHitboxRedirects.get()).booleanValue()) {
            return;
        }
        for (Map.Entry<String, Map<String, HitboxRedirect>> entry : dragonHitboxRedirects.entrySet()) {
            for (Map.Entry<String, HitboxRedirect> overrideEntry : entry.getValue().entrySet()) {
                HitboxRedirect hitboxRedirect = overrideEntry.getValue();
                StringBuilder hitboxRedirectInfo = new StringBuilder();
                hitboxRedirect.hitbox().ifPresent(content -> {
                    hitboxRedirectInfo.append("Hitbox: ").append("\n");
                    hitboxRedirectInfo.append("- Width: ").append(content.getFirst()).append("\n");
                    hitboxRedirectInfo.append("- Height: ").append(content.getSecond()).append("\n");
                });
                hitboxRedirect.attackBox().ifPresent(content -> {
                    hitboxRedirectInfo.append("Attack Box: ").append("\n");
                    hitboxRedirectInfo.append("- Width: ").append(content.getFirst()).append("\n");
                    hitboxRedirectInfo.append("- Height: ").append(content.getSecond()).append("\n");
                });
                hitboxRedirect.attackBoxPos().ifPresent(pos -> {
                    hitboxRedirectInfo.append("Attack Box Position: ").append("(x: ").append(pos.m_7096_()).append(", y: ").append(pos.m_7098_()).append(", z: ").append(pos.m_7094_()).append(")");
                    hitboxRedirectInfo.append("\n");
                });
                if (!hitboxRedirect.passengerPositions().isEmpty()) {
                    hitboxRedirectInfo.append("Passenger Positions:");
                    hitboxRedirect.passengerPositions().forEach(pos -> hitboxRedirectInfo.append(" ").append("(x: ").append(pos.m_7096_()).append(", y: ").append(pos.m_7098_()).append(", z: ").append(pos.m_7094_()).append(")"));
                }
                hitboxRedirectInfo.append("\n");
                IoBVariantLoader.LOGGER.info("{}: variant {} got following hitbox redirects:\n{}", new Object[]{entry.getKey(), overrideEntry.getKey(), hitboxRedirectInfo});
            }
        }
    }

    @Nullable
    public static EntityDimensions getHitboxOverride(ADragonBase dragon) {
        Map<String, HitboxRedirect> speciesMap;
        String species = ((DragonSpeciesHelper)dragon).getSpecies(false);
        String variant = ((VariantNameHelper)dragon).getVariantName();
        if (dragonHitboxRedirects.containsKey(species) && (speciesMap = dragonHitboxRedirects.get(species)).containsKey(variant)) {
            Optional<Pair<Float, Float>> pair = speciesMap.get(variant).hitbox();
            return pair.map(floatFloatPair -> EntityDimensions.m_20395_((float)((Float)floatFloatPair.getFirst()).floatValue(), (float)((Float)floatFloatPair.getSecond()).floatValue())).orElse(null);
        }
        return null;
    }

    @Nullable
    public static EntityDimensions getAttackBoxOverride(ADragonBase dragon) {
        Map<String, HitboxRedirect> speciesMap;
        String species = ((DragonSpeciesHelper)dragon).getSpecies(false);
        String variant = ((VariantNameHelper)dragon).getVariantName();
        if (dragonHitboxRedirects.containsKey(species) && (speciesMap = dragonHitboxRedirects.get(species)).containsKey(variant)) {
            Optional<Pair<Float, Float>> pair = speciesMap.get(variant).attackBox();
            return pair.map(floatFloatPair -> EntityDimensions.m_20395_((float)((Float)floatFloatPair.getFirst()).floatValue(), (float)((Float)floatFloatPair.getSecond()).floatValue())).orElse(null);
        }
        return null;
    }

    @Nullable
    public static Vec3 getAttackBoxPos(ADragonBase dragon) {
        Map<String, HitboxRedirect> speciesMap;
        String species = ((DragonSpeciesHelper)dragon).getSpecies(false);
        String variant = ((VariantNameHelper)dragon).getVariantName();
        if (dragonHitboxRedirects.containsKey(species) && (speciesMap = dragonHitboxRedirects.get(species)).containsKey(variant)) {
            return speciesMap.get(variant).attackBoxPos().orElse(null);
        }
        return null;
    }

    public static List<Vec3> getPassengerPositions(ADragonBase dragon) {
        Map<String, HitboxRedirect> speciesMap;
        String species = ((DragonSpeciesHelper)dragon).getSpecies(false);
        String variant = ((VariantNameHelper)dragon).getVariantName();
        if (dragonHitboxRedirects.containsKey(species) && (speciesMap = dragonHitboxRedirects.get(species)).containsKey(variant)) {
            return speciesMap.get(variant).passengerPositions();
        }
        return List.of();
    }
}

