/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ResourceUtil;
import nordmods.iobvariantloader.util.ducks.ModelCacheHelper;
import nordmods.iobvariantloader.util.ducks.VLGlowLayerHelper;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class VLGlowLayer<T extends AgeableMob>
extends GeoLayerRenderer<T> {
    public VLGlowLayer(IGeoRenderer<T> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((Boolean)IoBVariantLoader.clientConfig.disableGlowing.get()).booleanValue()) {
            return;
        }
        if (!ResourceUtil.isResourceReloadFinished) {
            return;
        }
        if (this.shouldRender(dragon)) {
            return;
        }
        ResourceLocation id = this.getGlowLayerLocation(dragon);
        if (!ResourceUtil.isValid(id)) {
            this.disableRender(dragon);
            return;
        }
        RenderType cameo = RenderType.m_110488_((ResourceLocation)id);
        ((VLGlowLayerHelper)this.getRenderer()).reRender(this.getModel(dragon), dragon, partialTicks, cameo, matrixStackIn, bufferIn, bufferIn.m_6299_(cameo), 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected ResourceLocation getGlowLayerLocation(T dragon) {
        if (((ModelCacheHelper)dragon).getGlowLayerLocationCache() != null) {
            return ((ModelCacheHelper)dragon).getGlowLayerLocationCache();
        }
        EntityRenderer baseRenderer = (EntityRenderer)this.getRenderer();
        String namespace = baseRenderer.m_5478_(dragon).m_135827_();
        String path = baseRenderer.m_5478_(dragon).m_135815_().replace(".png", "_glowing.png");
        ResourceLocation id = new ResourceLocation(namespace, path);
        ((ModelCacheHelper)dragon).setGlowLayerLocationCache(id);
        return id;
    }

    private GeoModel getModel(T dragon) {
        return this.getEntityModel().getModel(this.getEntityModel().getModelLocation(dragon));
    }

    protected boolean shouldRender(T dragon) {
        return ((ModelCacheHelper)dragon).shouldPreventGlowLayerRenderer();
    }

    protected void disableRender(T dragon) {
        ((ModelCacheHelper)dragon).setPreventGlowLayer(true);
    }
}

