/*
 * Decompiled with CFR 0.152.
 */
package com.iobaddons.iobaddons;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.dragons.skrill.Skrill;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModMobEffects;
import com.iobaddons.iobaddons.IoBAConfig;
import com.iobaddons.iobaddons.IoBARegistry;
import com.iobaddons.iobaddons.IoBASpawning;
import com.iobaddons.iobaddons.item.DragonWhistleItem;
import com.iobaddons.iobaddons.item.capability.DragonWhistleCapability;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="iobaddons")
public class IoBAddons {
    public static final String MODID = "iobaddons";
    private static final Path configPath = FMLPaths.GAMEDIR.get().resolve("config").toAbsolutePath();
    private static final Logger LOGGER = LogManager.getLogger();

    public IoBAddons() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IoBARegistry.ITEMS.register(eventBus);
        eventBus.addListener(IoBARegistry::registerCapabilities);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)IoBAConfig.COMMON_CONFIG);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, IoBARegistry::attachItemCapabilities);
    }

    public static Path getConfigPath() {
        return configPath;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void logAdvancedDebug(String debugOut) {
        if (((Boolean)IoBAConfig.ADVANCED_DEBUG.get()).booleanValue()) {
            IoBAddons.getLogger().debug(debugOut);
        }
    }

    public static String getDragonTypeTranslation(ADragonBase dragonIn) {
        if (dragonIn.m_6095_() == ModEntities.GRONCKLE.get()) {
            return "gronckle";
        }
        if (dragonIn.m_6095_() == ModEntities.LIGHT_FURY.get()) {
            return "light_fury";
        }
        if (dragonIn.m_6095_() == ModEntities.DEADLY_NADDER.get()) {
            return "nadder";
        }
        if (dragonIn.m_6095_() == ModEntities.NIGHT_FURY.get()) {
            return "night_fury";
        }
        if (dragonIn.m_6095_() == ModEntities.NIGHT_LIGHT.get()) {
            return "night_light";
        }
        if (dragonIn.m_6095_() == ModEntities.MONSTROUS_NIGHTMARE.get()) {
            return "nightmare";
        }
        if (dragonIn.m_6095_() == ModEntities.SKRILL.get()) {
            return "skrill";
        }
        if (dragonIn.m_6095_() == ModEntities.SPEED_STINGER.get()) {
            return "speed_stinger";
        }
        if (dragonIn.m_6095_() == ModEntities.SPEED_STINGER_LEADER.get()) {
            return "lead_speed_stinger";
        }
        if (dragonIn.m_6095_() == ModEntities.STINGER.get()) {
            return "stinger";
        }
        if (dragonIn.m_6095_() == ModEntities.TERRIBLE_TERROR.get()) {
            return "terror";
        }
        if (dragonIn.m_6095_() == ModEntities.TRIPLE_STRYKE.get()) {
            return "triple_stryke";
        }
        if (dragonIn.m_6095_() == ModEntities.ZIPPLEBACK.get()) {
            return "zippleback";
        }
        return "";
    }

    @Nullable
    public static <T> T getCapability(ItemStack stackIn, Capability<T> capability) {
        if (stackIn == null) {
            return null;
        }
        return (T)(stackIn.getCapability(capability).isPresent() ? stackIn.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }

    @Mod.EventBusSubscriber(modid="iobaddons", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public class IoBAForgeEvents {
        @SubscribeEvent
        public static void playerLeftClickEvent(PlayerInteractEvent.LeftClickBlock eventIn) {
            if (eventIn.getHand() == InteractionHand.MAIN_HAND && eventIn.getItemStack().m_41720_() instanceof DragonWhistleItem) {
                if (!eventIn.getPlayer().f_19853_.f_46443_) {
                    DragonWhistleItem whistleItem = (DragonWhistleItem)eventIn.getItemStack().m_41720_();
                    DragonWhistleCapability.IDragonWhistle whistle = IoBAddons.getCapability(eventIn.getItemStack(), IoBARegistry.DRAGON_WHISTLE_CAPABILITY);
                    if (!whistleItem.getWhistleCooldown(eventIn.getPlayer())) {
                        if (eventIn.getPlayer().m_6144_()) {
                            ADragonBase nearestDragon = (ADragonBase)eventIn.getPlayer().m_183503_().m_45963_(ADragonBase.class, TargetingConditions.m_148353_(), (LivingEntity)eventIn.getPlayer(), (double)eventIn.getPos().m_123341_(), (double)eventIn.getPos().m_123342_(), (double)eventIn.getPos().m_123343_(), eventIn.getPlayer().m_142469_().m_82377_(6.0, 6.0, 6.0));
                            boolean cycled = whistle.cycleWhistleSelector(nearestDragon);
                            if (cycled) {
                                if (whistle.getWhistleSelector() <= 2 && whistle.getWhistleSelector() <= 2) {
                                    eventIn.getPlayer().m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_whistle.type_set." + whistle.getWhistleSelectorName()), true);
                                } else if (whistle.getWhistleSelector() == 3) {
                                    eventIn.getPlayer().m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_whistle.type_set.one").m_7220_((Component)new TextComponent(whistle.getWhistleSelectorName()).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.BOLD)), true);
                                }
                            }
                        } else {
                            DragonWhistleItem.cycleWhistleCommand(eventIn.getItemStack(), eventIn.getPlayer());
                        }
                        whistleItem.setWhistleCooldown(eventIn.getPlayer());
                    }
                }
                eventIn.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="iobaddons")
    public class IoBAModEvents {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void addSpawn(BiomeLoadingEvent eventIn) {
            if (((Boolean)IoBAConfig.USE_IOBA_SPAWNS.get()).booleanValue()) {
                List base = eventIn.getSpawns().getSpawner(MobCategory.CREATURE);
                if (IoBASpawning.BIOME_SPAWN_SETS.isEmpty()) {
                    IoBASpawning.setupSpawnSettings();
                }
                if (IoBASpawning.BIOME_SPAWN_SETS.containsKey(eventIn.getName()) && IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName()).length > 0) {
                    IoBAddons.logAdvancedDebug("Found spawn entries for biome " + eventIn.getName() + "...");
                    for (int i = 0; i < IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName()).length; ++i) {
                        if (!IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName())[i].isValidSpawnPackage()) continue;
                        base.add(new MobSpawnSettings.SpawnerData(IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName())[i].getDragonType(), IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName())[i].getWeight(), IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName())[i].getSpawnMin(), IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName())[i].getSpawnMax()));
                        IoBAddons.logAdvancedDebug("Added spawns for " + IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName())[i].getDragonType().getRegistryName().toString() + " with weight of " + IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName())[i].getWeight() + ", and pack size of " + IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName())[i].getSpawnMin() + "-" + IoBASpawning.BIOME_SPAWN_SETS.get(eventIn.getName())[i].getSpawnMax() + ".");
                    }
                }
            }
        }

        @SubscribeEvent
        public static void livingHurtEvent(LivingHurtEvent eventIn) {
            ADragonBase dragonSource;
            if (eventIn.getSource().m_7640_() instanceof ADragonBase && ((Boolean)IoBAConfig.PREVENT_DRAGON_FRIENDLY_FIRE.get()).booleanValue() && (dragonSource = (ADragonBase)eventIn.getSource().m_7640_()).m_21824_() && dragonSource.m_142480_() != null) {
                TamableAnimal tamableTarget;
                LivingEntity dragonOwner = dragonSource.m_142480_();
                if (eventIn.getEntity().equals((Object)dragonOwner)) {
                    eventIn.setCanceled(true);
                    IoBAddons.logAdvancedDebug("Prevented friendly fire damage to owner " + dragonOwner);
                } else if (eventIn.getEntity() instanceof TamableAnimal && (tamableTarget = (TamableAnimal)eventIn.getEntity()).m_21824_() && tamableTarget.m_142480_() != null && tamableTarget.m_142480_().equals((Object)dragonOwner)) {
                    eventIn.setCanceled(true);
                    IoBAddons.logAdvancedDebug("Prevented friendly fire damage to tame " + tamableTarget);
                }
            }
            if (eventIn.getEntityLiving() instanceof Skrill && ((Boolean)IoBAConfig.SKRILL_LIGHTNING_IMMUNE.get()).booleanValue() && (eventIn.getSource() == DamageSource.f_19306_ || eventIn.getSource().m_7640_() instanceof Skrill)) {
                IoBAddons.logAdvancedDebug("Prevented Skrill " + eventIn.getEntityLiving() + " from taking lightning damage from " + eventIn.getSource());
                eventIn.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void potionApplicableEvent(PotionEvent.PotionApplicableEvent eventIn) {
            if (eventIn.getPotionEffect().m_19544_() == ModMobEffects.SHOCK.get()) {
                if (((Boolean)IoBAConfig.PREVENT_SHOCK_EFFECT.get()).booleanValue()) {
                    eventIn.setResult(Event.Result.DENY);
                }
                if (eventIn.getEntity() instanceof Skrill && ((Boolean)IoBAConfig.SKRILL_LIGHTNING_IMMUNE.get()).booleanValue()) {
                    IoBAddons.logAdvancedDebug("Prevented Skrill " + eventIn.getEntity() + " from receiving the shock effect");
                    eventIn.setResult(Event.Result.DENY);
                }
            }
        }
    }
}

