/*
 * Decompiled with CFR 0.152.
 */
package com.iobaddons.iobaddons.item;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.iobaddons.iobaddons.IoBAConfig;
import com.iobaddons.iobaddons.IoBARegistry;
import com.iobaddons.iobaddons.IoBAddons;
import com.iobaddons.iobaddons.item.capability.DragonCageCapability;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class DragonCageItem
extends Item {
    public DragonCageItem(Item.Properties itemPropertiesIn) {
        super(itemPropertiesIn);
    }

    public boolean m_5812_(ItemStack stackIn) {
        return DragonCageItem.cageHasDragon(IoBAddons.getCapability(stackIn, IoBARegistry.DRAGON_CAGE_CAPABILITY));
    }

    public void m_7373_(ItemStack stackIn, @Nullable Level levelIn, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_cage.tooltip.main").m_130940_(ChatFormatting.ITALIC));
        DragonCageCapability.IDragonCage cageCapability = IoBAddons.getCapability(stackIn, IoBARegistry.DRAGON_CAGE_CAPABILITY);
        if (DragonCageItem.cageHasDragon(cageCapability)) {
            if (cageCapability.getDragonName().equals("")) {
                tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_cage.tooltip.carrying").m_7220_((Component)new TranslatableComponent("species.iobaddons." + cageCapability.getDragonType())));
            } else {
                tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_cage.tooltip.carrying").m_7220_((Component)new TextComponent(cageCapability.getDragonName() + " (")).m_7220_((Component)new TranslatableComponent("species.iobaddons." + cageCapability.getDragonType())).m_7220_((Component)new TextComponent("\u00a7r)")));
            }
            if (cageCapability.getOwnerID() != null && !cageCapability.getOwnerName().equals("")) {
                tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_cage.tooltip.owner").m_7220_((Component)new TextComponent(cageCapability.getOwnerName())));
            } else {
                tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_cage.tooltip.untamed").m_130940_(ChatFormatting.ITALIC));
            }
            tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_cage.tooltip.health").m_7220_((Component)new TextComponent((int)cageCapability.getHealth() + "/" + (int)cageCapability.getMaxHealth())).m_130940_(DragonCageItem.getHPColor(cageCapability.getHealth(), cageCapability.getMaxHealth())));
        } else {
            tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_cage.tooltip.empty").m_130940_(ChatFormatting.ITALIC));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (context.m_43724_() == InteractionHand.MAIN_HAND) {
            if (!(level instanceof ServerLevel)) {
                return InteractionResult.SUCCESS;
            }
            DragonCageCapability.IDragonCage cageCapability = IoBAddons.getCapability(context.m_43722_(), IoBARegistry.DRAGON_CAGE_CAPABILITY);
            if (cageCapability != null) {
                if (cageCapability.hasDragon()) {
                    BlockPos blockPos = context.m_8083_();
                    BlockPos blockPos1 = level.m_8055_(blockPos).m_60812_((BlockGetter)level, blockPos).m_83281_() ? blockPos : blockPos.m_142300_(context.m_43719_());
                    cageCapability.releaseDragon(context.m_43723_(), blockPos1);
                } else {
                    ADragonBase nearestDragon = (ADragonBase)context.m_43725_().m_45963_(ADragonBase.class, TargetingConditions.m_148353_(), (LivingEntity)context.m_43723_(), (double)context.m_8083_().m_123341_(), (double)context.m_8083_().m_123342_(), (double)context.m_8083_().m_123343_(), context.m_43723_().m_142469_().m_82377_(6.0, 6.0, 6.0));
                    if (nearestDragon != null) {
                        cageCapability.captureDragon(context.m_43723_(), nearestDragon);
                    }
                }
                this.setCageCooldown(context.m_43723_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stackIn, Level levelIn, Entity inventoryIn, int p_40723_, boolean p_40724_) {
        DragonCageCapability.IDragonCage cageCapability;
        if (!levelIn.f_46443_ && (cageCapability = IoBAddons.getCapability(stackIn, IoBARegistry.DRAGON_CAGE_CAPABILITY)) != null) {
            cageCapability.tick();
        }
    }

    public void setCageCooldown(Player playerIn) {
        if (this.shouldApplyCageCooldown()) {
            playerIn.m_36335_().m_41524_((Item)this, ((Integer)IoBAConfig.CAGE_COOLDOWN.get()).intValue());
        }
    }

    public boolean getCageCooldown(Player playerIn) {
        return playerIn.m_36335_().m_41519_((Item)this);
    }

    public boolean shouldApplyCageCooldown() {
        return (Integer)IoBAConfig.CAGE_COOLDOWN.get() > 0;
    }

    public static boolean cageHasDragon(DragonCageCapability.IDragonCage cageCapabilityIn) {
        if (cageCapabilityIn != null) {
            return cageCapabilityIn.hasDragon();
        }
        return false;
    }

    public CompoundTag getShareTag(ItemStack stackIn) {
        CompoundTag nbt = stackIn.m_41784_();
        DragonCageCapability.IDragonCage cageCapability = IoBAddons.getCapability(stackIn, IoBARegistry.DRAGON_CAGE_CAPABILITY);
        if (cageCapability != null) {
            nbt.m_128365_("CageData", (Tag)cageCapability.getCageData());
        }
        return nbt;
    }

    public void readShareTag(ItemStack stackIn, @Nullable CompoundTag nbtIn) {
        DragonCageCapability.IDragonCage cageCapability;
        super.readShareTag(stackIn, nbtIn);
        if (nbtIn != null && (cageCapability = IoBAddons.getCapability(stackIn, IoBARegistry.DRAGON_CAGE_CAPABILITY)) != null && nbtIn.m_128425_("CageData", 10)) {
            cageCapability.setCageData(nbtIn.m_128469_("CageData"));
        }
    }

    public static void cageFailDisallowPassengers(Player playerIn, ADragonBase dragonIn) {
        if (playerIn != null) {
            playerIn.m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_cage.cage.failure.passengers"), true);
            IoBAddons.getLogger().info("Player " + playerIn.m_6302_() + " (" + playerIn.m_142081_().toString() + ") tried to cage the dragon " + dragonIn.m_142081_() + " but failed-- this dragon is currently carrying passengers!");
        }
    }

    public static void cageFailDisallowType(Player playerIn, ADragonBase dragonIn) {
        if (playerIn != null) {
            playerIn.m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_cage.cage.failure.forbidden_type"), true);
            IoBAddons.getLogger().info("Player " + playerIn.m_6302_() + " (" + playerIn.m_142081_().toString() + ") tried to cage the dragon " + dragonIn.m_142081_() + " but failed-- this dragon type has been blacklisted from caging!");
        }
    }

    public static void cageFailDisallowUntamed(Player playerIn, ADragonBase dragonIn) {
        if (playerIn != null) {
            playerIn.m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_cage.cage.failure.untamed"), true);
            IoBAddons.getLogger().info("Player " + playerIn.m_6302_() + " (" + playerIn.m_142081_().toString() + ") tried to cage the dragon " + dragonIn.m_142081_() + " but failed-- this dragon is not tamed and untamed capture is disallowed!");
        }
    }

    public static void cageFailInventory(Player playerIn, ADragonBase dragonIn) {
        if (playerIn != null) {
            playerIn.m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_cage.cage.failure.has_inventory"), true);
            IoBAddons.getLogger().info("Player " + playerIn.m_6302_() + " (" + playerIn.m_142081_().toString() + ") tried to cage the dragon " + dragonIn.m_142081_() + " but failed-- this dragon has an inventory and inventory capture is disallowed!");
        }
    }

    public static void cageFailNotYourDragon(Player playerIn, ADragonBase dragonIn) {
        if (playerIn != null) {
            playerIn.m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_cage.cage.failure.not_your_dragon"), true);
            IoBAddons.getLogger().info("Player " + playerIn.m_6302_() + " (" + playerIn.m_142081_().toString() + ") tried to cage the dragon " + dragonIn.m_142081_() + " but failed-- this dragon does not belong to them!");
        }
    }

    public static void releaseFailNotYourDragon(Player playerIn) {
        if (playerIn != null) {
            playerIn.m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_cage.release.failure.not_your_dragon"), true);
            IoBAddons.getLogger().info("Player " + playerIn.m_6302_() + " (" + playerIn.m_142081_().toString() + ") tried to release a dragon from a cage but failed-- this dragon does not belong to them!");
        }
    }

    private static ChatFormatting getHPColor(float hpValueIn, float hpMaxIn) {
        float hpPercent = hpValueIn / hpMaxIn;
        if (hpPercent > 0.7f) {
            return ChatFormatting.GREEN;
        }
        if (hpPercent > 0.3f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }
}

