/*
 * Decompiled with CFR 0.152.
 */
package com.iobaddons.iobaddons.item.capability;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonRideableUtility;
import com.GACMD.isleofberk.registery.ModEntities;
import com.iobaddons.iobaddons.IoBAConfig;
import com.iobaddons.iobaddons.IoBARegistry;
import com.iobaddons.iobaddons.IoBAddons;
import com.iobaddons.iobaddons.item.DragonCageItem;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class DragonCageCapability {

    public static class DragonCageCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<IDragonCage> dragonCage = LazyOptional.of(DragonCageHandler::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return IoBARegistry.DRAGON_CAGE_CAPABILITY.orEmpty(cap, this.dragonCage.cast());
        }

        public CompoundTag serializeNBT() {
            return ((IDragonCage)this.dragonCage.orElseThrow(NullPointerException::new)).getCageData();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((IDragonCage)this.dragonCage.orElseThrow(NullPointerException::new)).setCageData(nbt);
        }
    }

    public static class DragonCageHandler
    implements IDragonCage {
        private CompoundTag dragonData = new CompoundTag();
        private String dragonType = "";
        private String dragonName = "";
        private UUID ownerID = null;
        private String ownerName = "";
        private float hpValue = 0.0f;
        private float hpMax = 0.0f;
        private int hpTick = -1;

        @Override
        public CompoundTag getDragonData() {
            if (this.dragonData == null) {
                this.dragonData = new CompoundTag();
            }
            return this.dragonData;
        }

        @Override
        public void setDragonData(CompoundTag dragonDataIn) {
            this.dragonData = dragonDataIn;
        }

        @Override
        public String getDragonType() {
            return this.dragonType;
        }

        @Override
        public String getDragonName() {
            return this.dragonName;
        }

        @Override
        public UUID getOwnerID() {
            return this.ownerID;
        }

        @Override
        public String getOwnerName() {
            return this.ownerName;
        }

        @Override
        public float getHealth() {
            return this.hpValue;
        }

        @Override
        public float getMaxHealth() {
            return this.hpMax;
        }

        @Override
        public void captureDragon(Player player, ADragonBase dragon) {
            if (!player.f_19853_.f_46443_) {
                if (!this.dragonData.m_128441_("id")) {
                    if (DragonCageHandler.isTameStatusCaptureAllowed(player, dragon)) {
                        if (DragonCageHandler.isTypeCaptureAllowedOrCreative(player, dragon)) {
                            if (dragon.m_20197_().isEmpty()) {
                                if (DragonCageHandler.isInventoryCaptureAllowedOrCreative(player, dragon)) {
                                    if (this.dragonData == null) {
                                        this.dragonData = new CompoundTag();
                                    }
                                    if (dragon instanceof ADragonRideableUtility) {
                                        ADragonRideableUtility rideableDragon = (ADragonRideableUtility)dragon;
                                        if (rideableDragon.dragonContainer != null && !rideableDragon.dragonContainer.m_7983_()) {
                                            for (int i = 2; i < rideableDragon.dragonContainer.m_6643_(); ++i) {
                                                Containers.m_18992_((Level)player.f_19853_, (double)dragon.m_20185_(), (double)dragon.m_20186_(), (double)dragon.m_20189_(), (ItemStack)rideableDragon.dragonContainer.m_8020_(i));
                                            }
                                        }
                                    }
                                    this.dragonData.m_128359_("id", dragon.m_20078_());
                                    dragon.m_20240_(this.dragonData);
                                    this.dragonType = IoBAddons.getDragonTypeTranslation(dragon);
                                    String string = this.dragonName = dragon.m_8077_() ? dragon.m_5446_().getString().toString() : "";
                                    if (dragon.m_21824_()) {
                                        this.ownerID = player.m_142081_();
                                        this.ownerName = player.m_6302_();
                                    } else {
                                        this.ownerID = null;
                                        this.ownerName = "";
                                    }
                                    this.hpMax = dragon.m_21233_();
                                    this.hpValue = dragon.m_21223_();
                                    player.f_19853_.m_6263_(null, dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_(), SoundEvents.f_11745_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                    dragon.m_146870_();
                                } else {
                                    DragonCageItem.cageFailInventory(player, dragon);
                                }
                            } else {
                                DragonCageItem.cageFailDisallowPassengers(player, dragon);
                            }
                        } else {
                            DragonCageItem.cageFailDisallowType(player, dragon);
                        }
                    }
                } else {
                    IoBAddons.logAdvancedDebug("Player " + player.m_6302_() + " tried to use a dragon cage on dragon " + dragon + ", but this cage is already full!");
                }
            } else {
                IoBAddons.logAdvancedDebug("Player " + player.m_6302_() + " tried to use a dragon cage on dragon " + dragon + ", but this is a client world!");
            }
        }

        @Override
        public boolean releaseDragon(Player playerIn, BlockPos posIn) {
            if (!playerIn.f_19853_.f_46443_ && this.dragonData.m_128441_("id")) {
                if (this.ownerID != null && !playerIn.m_142081_().equals(this.ownerID)) {
                    if (!((Boolean)IoBAConfig.ALLOW_RELEASE_NOT_YOURS.get()).booleanValue()) {
                        DragonCageItem.releaseFailNotYourDragon(playerIn);
                        return false;
                    }
                    IoBAddons.logAdvancedDebug("Player " + playerIn.m_6302_() + " (" + playerIn.m_142081_().toString() + ") is releasing a dragon that belongs to " + this.ownerName + " (" + this.ownerID.toString() + ") from its cage.");
                }
                EntityType.m_20642_((CompoundTag)this.dragonData, (Level)playerIn.f_19853_).ifPresent(entity -> {
                    entity.m_6034_((double)posIn.m_123341_(), (double)posIn.m_123342_() + 0.7, (double)posIn.m_123343_());
                    ((ServerLevel)playerIn.f_19853_).m_8847_(entity);
                });
                this.resetCageData();
                playerIn.f_19853_.m_6263_(null, (double)posIn.m_123341_(), (double)posIn.m_123342_(), (double)posIn.m_123343_(), SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
            return false;
        }

        private static boolean doesPlayerHaveCaptureOverride(Player player) {
            if (player.m_7500_() && ((Boolean)IoBAConfig.CREATIVE_CAGE_OVERRIDE.get()).booleanValue()) {
                IoBAddons.getLogger().info("CAPTURE PERMISSIONS OVERRIDE: Player " + player.m_6302_() + " (" + player.m_142081_().toString() + ") is using creative permissions to bypass a disallowed capture.");
                return true;
            }
            return false;
        }

        private static boolean isTypeCaptureAllowed(ADragonBase dragonIn) {
            if (dragonIn.m_6095_() == ModEntities.GRONCKLE.get() && ((Boolean)IoBAConfig.ALLOW_GRONCKLE_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.LIGHT_FURY.get() && ((Boolean)IoBAConfig.ALLOW_LIGHT_FURY_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.DEADLY_NADDER.get() && ((Boolean)IoBAConfig.ALLOW_NADDER_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.NIGHT_FURY.get() && ((Boolean)IoBAConfig.ALLOW_NIGHT_FURY_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.NIGHT_LIGHT.get() && ((Boolean)IoBAConfig.ALLOW_NIGHT_LIGHT_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.MONSTROUS_NIGHTMARE.get() && ((Boolean)IoBAConfig.ALLOW_NIGHTMARE_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.SKRILL.get() && ((Boolean)IoBAConfig.ALLOW_SKRILL_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.SPEED_STINGER.get() && ((Boolean)IoBAConfig.ALLOW_SPEED_STINGER_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.STINGER.get() && ((Boolean)IoBAConfig.ALLOW_STINGER_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.TERRIBLE_TERROR.get() && ((Boolean)IoBAConfig.ALLOW_TERROR_CAPTURE.get()).booleanValue()) {
                return true;
            }
            if (dragonIn.m_6095_() == ModEntities.TRIPLE_STRYKE.get() && ((Boolean)IoBAConfig.ALLOW_TRIPLE_STRYKE_CAPTURE.get()).booleanValue()) {
                return true;
            }
            return dragonIn.m_6095_() == ModEntities.ZIPPLEBACK.get() && (Boolean)IoBAConfig.ALLOW_ZIPPLEBACK_CAPTURE.get() != false;
        }

        private static boolean isTypeCaptureAllowedOrCreative(Player playerIn, ADragonBase dragonIn) {
            if (DragonCageHandler.isTypeCaptureAllowed(dragonIn)) {
                return true;
            }
            return DragonCageHandler.doesPlayerHaveCaptureOverride(playerIn);
        }

        private static boolean isTameStatusCaptureAllowed(Player player, ADragonBase dragon) {
            if (dragon.m_21824_()) {
                if (dragon.m_142480_().equals((Object)player)) {
                    return true;
                }
                DragonCageItem.cageFailNotYourDragon(player, dragon);
            } else {
                if (((Boolean)IoBAConfig.ALLOW_CAGE_UNTAMED.get()).booleanValue()) {
                    return true;
                }
                DragonCageItem.cageFailDisallowUntamed(player, dragon);
            }
            return DragonCageHandler.doesPlayerHaveCaptureOverride(player);
        }

        private static boolean isInventoryCaptureAllowed(ADragonBase dragon) {
            if (dragon instanceof ADragonRideableUtility) {
                ADragonRideableUtility rideableDragon = (ADragonRideableUtility)dragon;
                if (rideableDragon.dragonContainer != null) {
                    boolean inventoryHasItems = false;
                    for (int i = 2; !inventoryHasItems && i < rideableDragon.dragonContainer.m_6643_(); ++i) {
                        if (rideableDragon.dragonContainer.m_8020_(i).m_41619_()) continue;
                        inventoryHasItems = true;
                    }
                    if (inventoryHasItems) {
                        return (Boolean)IoBAConfig.ALLOW_CAGE_INVENTORY.get();
                    }
                }
            }
            return true;
        }

        private static boolean isInventoryCaptureAllowedOrCreative(Player playerIn, ADragonBase dragonIn) {
            if (DragonCageHandler.isInventoryCaptureAllowed(dragonIn)) {
                return true;
            }
            return DragonCageHandler.doesPlayerHaveCaptureOverride(playerIn);
        }

        @Override
        public void tick() {
            if (this.hasDragon() && (Integer)IoBAConfig.CAGE_HEAL_TICK.get() > 0) {
                ++this.hpTick;
                if (this.hpTick > (Integer)IoBAConfig.CAGE_HEAL_TICK.get() * 20) {
                    this.hpValue = Math.min(this.hpValue + 1.0f, this.hpMax);
                    this.dragonData.m_128350_("Health", Math.max(0.0f, this.hpValue));
                    this.hpTick = 0;
                }
            }
        }

        @Override
        public CompoundTag getCageData() {
            CompoundTag cageData = new CompoundTag();
            cageData.m_128365_("dragonData", (Tag)this.dragonData);
            cageData.m_128359_("dragonType", this.dragonType);
            cageData.m_128359_("dragonName", this.dragonName);
            if (this.ownerID != null) {
                cageData.m_128362_("ownerID", this.ownerID);
            }
            cageData.m_128359_("ownerName", this.ownerName);
            cageData.m_128350_("hpValue", this.hpValue);
            cageData.m_128350_("hpMax", this.hpMax);
            return cageData;
        }

        @Override
        public void setCageData(CompoundTag nbtIn) {
            if (nbtIn.m_128441_("dragonData")) {
                this.dragonData = nbtIn.m_128469_("dragonData");
            }
            if (nbtIn.m_128441_("dragonType")) {
                this.dragonType = nbtIn.m_128461_("dragonType");
            }
            if (nbtIn.m_128441_("dragonName")) {
                this.dragonName = nbtIn.m_128461_("dragonName");
            }
            if (nbtIn.m_128441_("ownerID")) {
                this.ownerID = nbtIn.m_128342_("ownerID");
            }
            if (nbtIn.m_128441_("ownerName")) {
                this.ownerName = nbtIn.m_128461_("ownerName");
            }
            if (nbtIn.m_128441_("hpValue")) {
                this.hpValue = nbtIn.m_128457_("hpValue");
            }
            if (nbtIn.m_128441_("hpMax")) {
                this.hpMax = nbtIn.m_128457_("hpMax");
            }
        }

        private void resetCageData() {
            this.dragonData = new CompoundTag();
            this.dragonType = "";
            this.dragonName = "";
            this.ownerID = null;
            this.ownerName = "";
            this.hpValue = 0.0f;
            this.hpMax = 0.0f;
            this.hpTick = 0;
        }
    }

    public static interface IDragonCage {
        public CompoundTag getDragonData();

        public void setDragonData(CompoundTag var1);

        default public boolean hasDragon() {
            return this.getDragonData().m_128441_("id");
        }

        public String getDragonType();

        public String getDragonName();

        public UUID getOwnerID();

        public String getOwnerName();

        public float getHealth();

        public float getMaxHealth();

        public void tick();

        public void captureDragon(Player var1, ADragonBase var2);

        public boolean releaseDragon(Player var1, BlockPos var2);

        public CompoundTag getCageData();

        public void setCageData(CompoundTag var1);
    }
}

