/*
 * Decompiled with CFR 0.152.
 */
package com.iobaddons.iobaddons.item.capability;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.iobaddons.iobaddons.IoBARegistry;
import com.iobaddons.iobaddons.IoBAddons;
import com.iobaddons.iobaddons.item.DragonWhistleItem;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class DragonWhistleCapability {

    public static class DragonWhistleCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<IDragonWhistle> dragonWhistle = LazyOptional.of(DragonWhistleHandler::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return IoBARegistry.DRAGON_WHISTLE_CAPABILITY.orEmpty(cap, this.dragonWhistle.cast());
        }

        public CompoundTag serializeNBT() {
            return ((IDragonWhistle)this.dragonWhistle.orElseThrow(NullPointerException::new)).getWhistleData();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((IDragonWhistle)this.dragonWhistle.orElseThrow(NullPointerException::new)).setWhistleData(nbt);
        }
    }

    public static class DragonWhistleHandler
    implements IDragonWhistle {
        private int command = 0;
        private int selectorType = 0;
        private String selectorIdentifier = "all";
        private String selectorName = "all";
        private UUID individualDragonID = null;

        @Override
        public void cycleWhistleCommand() {
            if (this.command < 2) {
                Math.max(0, this.command++);
            } else {
                this.command = 0;
            }
        }

        @Override
        public int getWhistleCommand() {
            return this.command;
        }

        @Override
        public String getWhistleCommandString() {
            return this.command == 0 ? "sit" : (this.command == 1 ? "follow" : "wander");
        }

        @Override
        public int getWhistleSelector() {
            return this.selectorType;
        }

        @Override
        public String getWhistleSelectorIdentifier() {
            return this.selectorIdentifier;
        }

        @Override
        public String getWhistleSelectorName() {
            return this.selectorName;
        }

        @Override
        public UUID getWhistleSelectorUUID() {
            return this.individualDragonID;
        }

        @Override
        public boolean cycleWhistleSelector(ADragonBase dragonIn) {
            boolean validated = false;
            if (dragonIn != null) {
                while (!validated) {
                    this.selectorType = this.selectorType < 3 ? Math.max(0, this.selectorType + 1) : 0;
                    if (this.selectorType == 0) {
                        validated = true;
                        this.selectorIdentifier = "all";
                        this.selectorName = "all";
                        this.individualDragonID = null;
                        continue;
                    }
                    if (this.selectorType == 1) {
                        validated = true;
                        this.selectorIdentifier = "species";
                        this.selectorName = IoBAddons.getDragonTypeTranslation(dragonIn);
                        this.individualDragonID = null;
                        continue;
                    }
                    if (this.selectorType == 2) {
                        if (!DragonWhistleItem.isFuryFamily(dragonIn)) continue;
                        validated = true;
                        this.selectorIdentifier = "family";
                        this.selectorName = "fury_family";
                        this.individualDragonID = null;
                        continue;
                    }
                    if (this.selectorType != 3 || !dragonIn.m_8077_()) continue;
                    validated = true;
                    this.selectorIdentifier = "one";
                    this.individualDragonID = dragonIn.m_142081_();
                    this.selectorName = dragonIn.m_5446_().getString().toString();
                }
            }
            return validated;
        }

        @Override
        public CompoundTag getWhistleData() {
            CompoundTag whistleData = new CompoundTag();
            whistleData.m_128405_("command", this.command);
            whistleData.m_128405_("selectorType", this.selectorType);
            whistleData.m_128359_("selectorID", this.selectorIdentifier);
            whistleData.m_128359_("selectorName", this.selectorName);
            if (this.individualDragonID != null) {
                whistleData.m_128362_("individualDragonID", this.individualDragonID);
            }
            return whistleData;
        }

        @Override
        public void setWhistleData(CompoundTag nbtIn) {
            if (nbtIn.m_128441_("command")) {
                this.command = nbtIn.m_128451_("command");
            }
            if (nbtIn.m_128441_("selectorType")) {
                this.selectorType = nbtIn.m_128451_("selectorType");
            }
            if (nbtIn.m_128441_("selectorID")) {
                this.selectorIdentifier = nbtIn.m_128461_("selectorID");
            }
            if (nbtIn.m_128441_("selectorName")) {
                this.selectorName = nbtIn.m_128461_("selectorName");
            }
            if (nbtIn.m_128441_("individualDragonID")) {
                this.individualDragonID = nbtIn.m_128342_("individualDragonID");
            }
        }
    }

    public static interface IDragonWhistle {
        public void cycleWhistleCommand();

        public int getWhistleCommand();

        public boolean cycleWhistleSelector(ADragonBase var1);

        public int getWhistleSelector();

        public String getWhistleSelectorIdentifier();

        public String getWhistleSelectorName();

        public UUID getWhistleSelectorUUID();

        public String getWhistleCommandString();

        public CompoundTag getWhistleData();

        public void setWhistleData(CompoundTag var1);
    }
}

