/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.graph.ChunkGraphInfo;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;

public class RenderSection {
    private final SodiumWorldRenderer worldRenderer;
    private final int chunkX;
    private final int chunkY;
    private final int chunkZ;
    private final Map<BlockRenderPass, ChunkGraphicsState> graphicsStates;
    private final RenderRegion region;
    private final ChunkGraphInfo graphInfo;
    private final int chunkId;
    private final float regionOffsetX;
    private final float regionOffsetY;
    private final float regionOffsetZ;
    private final RenderSection[] adjacent = new RenderSection[DirectionUtil.ALL_DIRECTIONS.length];
    private ChunkRenderData data = ChunkRenderData.ABSENT;
    private CompletableFuture<?> rebuildTask = null;
    private ChunkUpdateType pendingUpdate;
    private boolean tickable;
    private boolean disposed;
    private int lastAcceptedBuildTime = -1;

    public RenderSection(SodiumWorldRenderer worldRenderer, int chunkX, int chunkY, int chunkZ, RenderRegion region) {
        this.worldRenderer = worldRenderer;
        this.region = region;
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        this.graphInfo = new ChunkGraphInfo(this);
        this.graphicsStates = new EnumMap<BlockRenderPass, ChunkGraphicsState>(BlockRenderPass.class);
        int rX = this.getChunkX() & 7;
        int rY = this.getChunkY() & 3;
        int rZ = this.getChunkZ() & 7;
        this.regionOffsetX = (float)rX * 16.0f;
        this.regionOffsetY = (float)rY * 16.0f;
        this.regionOffsetZ = (float)rZ * 16.0f;
        this.chunkId = RenderRegion.getChunkIndex(rX, rY, rZ);
    }

    public RenderSection getAdjacent(Direction dir) {
        return this.adjacent[dir.ordinal()];
    }

    public void setAdjacentNode(Direction dir, RenderSection node) {
        this.adjacent[dir.ordinal()] = node;
    }

    public void cancelRebuildTask() {
        if (this.rebuildTask != null) {
            this.rebuildTask.cancel(false);
            this.rebuildTask = null;
        }
    }

    public ChunkRenderData getData() {
        return this.data;
    }

    public void delete() {
        this.cancelRebuildTask();
        this.setData(ChunkRenderData.ABSENT);
        this.deleteGraphicsState();
        this.disposed = true;
    }

    private void deleteGraphicsState() {
        for (ChunkGraphicsState state : this.graphicsStates.values()) {
            state.delete();
        }
        this.graphicsStates.clear();
    }

    public void setData(ChunkRenderData info) {
        if (info == null) {
            throw new NullPointerException("Mesh information must not be null");
        }
        this.worldRenderer.onChunkRenderUpdated(this.chunkX, this.chunkY, this.chunkZ, this.data, info);
        this.data = info;
        this.tickable = !info.getAnimatedSprites().isEmpty();
    }

    public boolean isEmpty() {
        return this.graphicsStates.isEmpty() && this.data.isEmpty();
    }

    public SectionPos getChunkPos() {
        return SectionPos.m_123173_((int)this.chunkX, (int)this.chunkY, (int)this.chunkZ);
    }

    public void tick() {
        for (TextureAtlasSprite sprite : this.data.getAnimatedSprites()) {
            SpriteUtil.markSpriteActive(sprite);
        }
    }

    public int getOriginX() {
        return this.chunkX << 4;
    }

    public int getOriginY() {
        return this.chunkY << 4;
    }

    public int getOriginZ() {
        return this.chunkZ << 4;
    }

    public double getSquaredDistance(BlockPos pos) {
        return this.getSquaredDistance((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public double getSquaredDistance(double x, double y, double z) {
        double xDist = x - this.getCenterX();
        double yDist = y - this.getCenterY();
        double zDist = z - this.getCenterZ();
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    private double getCenterX() {
        return (double)this.getOriginX() + 8.0;
    }

    private double getCenterY() {
        return (double)this.getOriginY() + 8.0;
    }

    private double getCenterZ() {
        return (double)this.getOriginZ() + 8.0;
    }

    public ChunkGraphicsState setGraphicsState(BlockRenderPass pass, ChunkGraphicsState state) {
        if (state == null) {
            return this.graphicsStates.remove((Object)pass);
        }
        return this.graphicsStates.put(pass, state);
    }

    public double getSquaredDistanceXZ(double x, double z) {
        double xDist = x - this.getCenterX();
        double zDist = z - this.getCenterZ();
        return xDist * xDist + zDist * zDist;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public ChunkRenderBounds getBounds() {
        return this.data.getBounds();
    }

    public ChunkGraphicsState getGraphicsState(BlockRenderPass pass) {
        return this.graphicsStates.get((Object)pass);
    }

    public boolean isTickable() {
        return this.tickable;
    }

    public RenderRegion getRegion() {
        return this.region;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public String toString() {
        return String.format("RenderChunk{chunkX=%d, chunkY=%d, chunkZ=%d}", this.chunkX, this.chunkY, this.chunkZ);
    }

    public ChunkGraphInfo getGraphInfo() {
        return this.graphInfo;
    }

    public void setOcclusionData(VisibilitySet occlusionData) {
        this.graphInfo.setOcclusionData(occlusionData);
    }

    public ChunkUpdateType getPendingUpdate() {
        return this.pendingUpdate;
    }

    public void markForUpdate(ChunkUpdateType type) {
        if (this.pendingUpdate == null || type.ordinal() > this.pendingUpdate.ordinal()) {
            this.pendingUpdate = type;
        }
    }

    public void onBuildSubmitted(CompletableFuture<?> task) {
        if (this.rebuildTask != null) {
            this.rebuildTask.cancel(false);
            this.rebuildTask = null;
        }
        this.rebuildTask = task;
        this.pendingUpdate = null;
    }

    public boolean isBuilt() {
        return this.data != ChunkRenderData.ABSENT;
    }

    public boolean canAcceptBuildResults(ChunkBuildResult result) {
        return !this.isDisposed() && result.buildTime > this.lastAcceptedBuildTime;
    }

    public void onBuildFinished(ChunkBuildResult result) {
        this.setData(result.data);
        this.lastAcceptedBuildTime = result.buildTime;
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public float getRegionOffsetX() {
        return this.regionOffsetX;
    }

    public float getRegionOffsetY() {
        return this.regionOffsetY;
    }

    public float getRegionOffsetZ() {
        return this.regionOffsetZ;
    }
}

