/*
 * Decompiled with CFR 0.152.
 */
package com.chiki.dragonfinder.item;

import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemDragonEye
extends Item {
    public ItemDragonEye(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        if (!level.m_5776_() && interactionHand == InteractionHand.MAIN_HAND) {
            ItemStack itemStack = player.m_21120_(interactionHand);
            Entity dragon = this.findNearestDragons(level, player);
            if (dragon == null) {
                player.m_6352_((Component)new TranslatableComponent("item.dragonfinder.dragoneye.nonfound"), player.m_142081_());
                return super.m_7203_(level, player, interactionHand);
            }
            EyeOfEnder finderEntity = new EyeOfEnder(level, player.m_20182_().f_82479_, player.m_20227_(0.5), player.m_20182_().f_82481_);
            finderEntity.m_36972_(itemStack);
            finderEntity.m_36967_(dragon.m_142538_());
            finderEntity.f_36954_ = ThreadLocalRandom.current().nextInt(0, 9) >= 3;
            level.m_7967_((Entity)finderEntity);
            level.m_5594_(null, player.m_142538_(), SoundEvents.f_11898_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
            level.m_5898_(null, 1003, player.m_142538_(), 0);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
        }
        return super.m_7203_(level, player, interactionHand);
    }

    private Entity findNearestDragons(Level level, Player player) {
        double distance;
        double boxSize = 500.0;
        AABB aabb = AABB.m_165882_((Vec3)player.m_20182_(), (double)boxSize, (double)boxSize, (double)boxSize);
        int stageMin = 4;
        List iceDragons = level.m_6443_(EntityIceDragon.class, aabb, dragon -> dragon.getDragonStage() >= stageMin);
        List fireDragons = level.m_6443_(EntityFireDragon.class, aabb, dragon -> dragon.getDragonStage() >= stageMin);
        List lightningDragons = level.m_6443_(EntityLightningDragon.class, aabb, dragon -> dragon.getDragonStage() >= stageMin);
        if (iceDragons.size() == 0 && fireDragons.size() == 0 && lightningDragons.size() == 0) {
            return null;
        }
        double nearestDistance = 2.147483647E9;
        EntityIceDragon nearestEntity = null;
        for (EntityIceDragon entity : iceDragons) {
            distance = entity.m_20270_((Entity)player);
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearestEntity = entity;
        }
        for (EntityIceDragon entity : fireDragons) {
            distance = entity.m_20270_((Entity)player);
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearestEntity = entity;
        }
        for (EntityIceDragon entity : lightningDragons) {
            distance = entity.m_20270_((Entity)player);
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearestEntity = entity;
        }
        return nearestEntity;
    }
}

