/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.impl.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.api.ui.Element;
import mcp.mobius.waila.overlay.DisplayHelper;
import mcp.mobius.waila.overlay.IconUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class ArmorElement
extends Element {
    private final float armor;

    public ArmorElement(float armor) {
        this.armor = armor;
    }

    @Override
    public Vec2 getSize() {
        WailaConfig.ConfigGeneral config = Waila.CONFIG.get().getGeneral();
        if (this.armor > (float)config.getMaxHealthForRender()) {
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            Font font = Minecraft.m_91087_().f_91062_;
            return new Vec2((float)(8 + font.m_92895_(text)), 10.0f);
        }
        int maxHearts = config.getMaxHeartsPerLine();
        int lineCount = (int)Math.ceil(this.armor / (float)maxHearts * 0.5f);
        return new Vec2((float)(8 * maxHearts), (float)(10 * lineCount));
    }

    @Override
    public void render(PoseStack matrixStack, float x, float y, float maxX, float maxY) {
        WailaConfig.ConfigGeneral config = Waila.CONFIG.get().getGeneral();
        if (this.armor > (float)config.getMaxHealthForRender()) {
            DisplayHelper.renderIcon(matrixStack, x, y, 8, 8, IconUI.ARMOR);
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            WailaConfig.ConfigOverlay.ConfigOverlayColor color = Waila.CONFIG.get().getOverlay().getColor();
            DisplayHelper.INSTANCE.drawText(matrixStack, text, x + 8.0f, y, color.getTheme().textColor);
        } else {
            float armor = this.armor * 0.5f;
            int maxHearts = config.getMaxHeartsPerLine();
            int lineCount = (int)Math.ceil(armor / (float)maxHearts);
            int armorCount = lineCount * maxHearts;
            int xOffset = 0;
            for (int i = 1; i <= armorCount; ++i) {
                if (i <= Mth.m_14143_((float)armor)) {
                    DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.ARMOR);
                    xOffset += 8;
                }
                if ((float)i > armor && (float)i < armor + 1.0f) {
                    DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.HALF_ARMOR);
                    xOffset += 8;
                }
                if ((float)i >= armor + 1.0f) {
                    DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.EMPTY_ARMOR);
                    xOffset += 8;
                }
                if (i % maxHearts != 0) continue;
                y += 10.0f;
                xOffset = 0;
            }
        }
    }

    @Override
    @Nullable
    public Component getMessage() {
        return new TranslatableComponent("narration.waila.armor", new Object[]{DisplayHelper.dfCommas.format(this.armor)});
    }
}

