/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Collection;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.VanillaPlugin;

public class PotionEffectsProvider
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    public static final PotionEffectsProvider INSTANCE = new PotionEffectsProvider();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!config.get(VanillaPlugin.EFFECTS) || !accessor.getServerData().m_128441_("Potions")) {
            return;
        }
        IElementHelper helper = tooltip.getElementHelper();
        ITooltip box = helper.tooltip();
        ListTag list = accessor.getServerData().m_128437_("Potions", 10);
        Component[] lines = new Component[list.size()];
        for (int i = 0; i < lines.length; ++i) {
            CompoundTag compound = list.m_128728_(i);
            int duration = compound.m_128451_("Duration");
            TranslatableComponent name = new TranslatableComponent(compound.m_128461_("Name"));
            String amplifierKey = "potion.potency." + compound.m_128451_("Amplifier");
            Object amplifier = I18n.m_118936_((String)amplifierKey) ? new TranslatableComponent(amplifierKey) : new TextComponent(Integer.toString(compound.m_128451_("Amplifier")));
            TranslatableComponent s = new TranslatableComponent("jade.potion", new Object[]{name, amplifier, PotionEffectsProvider.getPotionDurationString(duration)});
            box.add((Component)s.m_130940_(compound.m_128471_("Bad") ? ChatFormatting.RED : ChatFormatting.GREEN));
        }
        tooltip.add(helper.box(box));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getPotionDurationString(int duration) {
        if (duration >= Short.MAX_VALUE) {
            return "**:**";
        }
        int i = Mth.m_14143_((float)duration);
        return PotionEffectsProvider.ticksToElapsedTime(i);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    @Override
    public void appendServerData(CompoundTag tag, ServerPlayer player, Level arg2, Entity entity, boolean showDetails) {
        LivingEntity living = (LivingEntity)entity;
        Collection effects = living.m_21220_();
        if (effects.isEmpty()) {
            return;
        }
        ListTag list = new ListTag();
        for (MobEffectInstance effect : effects) {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("Name", effect.m_19576_());
            compound.m_128405_("Amplifier", effect.m_19564_());
            int duration = Math.min(Short.MAX_VALUE, effect.m_19557_());
            compound.m_128405_("Duration", duration);
            compound.m_128379_("Bad", effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
            list.add((Object)compound);
        }
        tag.m_128365_("Potions", (Tag)list);
    }
}

