/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ArrayLayeredTexture
extends AbstractTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    public final List<String> layeredTextureNames;

    public ArrayLayeredTexture(List<String> textureNames) {
        this.layeredTextureNames = textureNames;
    }

    public void m_6704_(@NotNull ResourceManager manager) {
        Iterator<String> iterator = this.layeredTextureNames.iterator();
        String s = iterator.next();
        try (Resource iresource = manager.m_142591_(new ResourceLocation(s));){
            NativeImage nativeimage = MinecraftForgeClient.getImageLayer((ResourceLocation)new ResourceLocation(s), (ResourceManager)manager);
            while (iterator.hasNext()) {
                String s1 = iterator.next();
                if (s1 == null) continue;
                Resource iresource1 = manager.m_142591_(new ResourceLocation(s1));
                try {
                    NativeImage nativeimage1 = NativeImage.m_85058_((InputStream)iresource1.m_6679_());
                    try {
                        for (int i = 0; i < Math.min(nativeimage1.m_85084_(), nativeimage.m_85084_()); ++i) {
                            for (int j = 0; j < Math.min(nativeimage1.m_84982_(), nativeimage.m_84982_()); ++j) {
                                ArrayLayeredTexture.blendPixel(nativeimage, nativeimage1, j, i, nativeimage1.m_84985_(j, i));
                            }
                        }
                    }
                    finally {
                        if (nativeimage1 == null) continue;
                        nativeimage1.close();
                    }
                }
                finally {
                    if (iresource1 == null) continue;
                    iresource1.close();
                }
            }
            if (!RenderSystem.m_69587_()) {
                RenderSystem.m_69879_(() -> this.loadImage(nativeimage));
            } else {
                this.loadImage(nativeimage);
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't load layered image", (Throwable)ioexception);
        }
    }

    public static void blendPixel(NativeImage nativeimage, NativeImage nativeimage1, int xIn, int yIn, int colIn) {
        int i = nativeimage.m_84985_(xIn, yIn);
        float f = (float)NativeImage.m_84983_((int)colIn) / 255.0f;
        float f1 = (float)NativeImage.m_85119_((int)colIn) / 255.0f;
        float f2 = (float)NativeImage.m_85103_((int)colIn) / 255.0f;
        float f3 = (float)NativeImage.m_85085_((int)colIn) / 255.0f;
        float f4 = (float)NativeImage.m_84983_((int)i) / 255.0f;
        float f5 = (float)NativeImage.m_85119_((int)i) / 255.0f;
        float f6 = (float)NativeImage.m_85103_((int)i) / 255.0f;
        float f7 = (float)NativeImage.m_85085_((int)i) / 255.0f;
        float f8 = 1.0f - f;
        float f9 = f * f + f4 * f8;
        float f10 = f1 * f + f5 * f8;
        float f11 = f2 * f + f6 * f8;
        float f12 = f3 * f + f7 * f8;
        if (f9 > 1.0f) {
            f9 = 1.0f;
        }
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        if (f11 > 1.0f) {
            f11 = 1.0f;
        }
        if (f12 > 1.0f) {
            f12 = 1.0f;
        }
        int j = (int)(f9 * 255.0f);
        int k = (int)(f10 * 255.0f);
        int l = (int)(f11 * 255.0f);
        int i1 = (int)(f12 * 255.0f);
        nativeimage.m_84988_(xIn, yIn, NativeImage.m_84992_((int)j, (int)k, (int)l, (int)i1));
    }

    private void loadImage(NativeImage imageIn) {
        TextureUtil.m_85283_((int)this.m_117963_(), (int)imageIn.m_84982_(), (int)imageIn.m_85084_());
        imageIn.m_85040_(0, 0, 0, true);
    }
}

