/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.config.biome;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.config.biome.SpawnBiomeData;
import com.github.alexthe666.iceandfire.config.biome.BiomeEntryType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class IafSpawnBiomeData
extends SpawnBiomeData {
    private List<List<SpawnBiomeEntry>> biomes = new ArrayList<List<SpawnBiomeEntry>>();
    private static final int CITADEL_FORMAT = 0;
    private static final String CITADEL_FORMAT_STRING = "citadel_format";
    private int citadelFormat = 0;

    public IafSpawnBiomeData() {
    }

    public void setCitadelFormat(int format) {
        this.citadelFormat = format;
    }

    private IafSpawnBiomeData(SpawnBiomeEntry[][] biomesRead) {
        this.biomes = new ArrayList<List<SpawnBiomeEntry>>();
        for (SpawnBiomeEntry[] innerArray : biomesRead) {
            this.biomes.add(Arrays.asList(innerArray));
        }
    }

    public IafSpawnBiomeData addBiomeEntry(BiomeEntryType type, boolean negate, String value, int pool) {
        if (this.biomes.isEmpty() || this.biomes.size() < pool + 1) {
            this.biomes.add(new ArrayList());
        }
        this.biomes.get(pool).add(new SpawnBiomeEntry(type, negate, value));
        return this;
    }

    @Deprecated
    public boolean matches(Biome biomeIn) {
        return this.matches(Biome.BiomeCategory.NONE, biomeIn.getRegistryName());
    }

    public boolean matches(Biome.BiomeCategory category, ResourceLocation registryName) {
        for (List<SpawnBiomeEntry> all : this.biomes) {
            boolean overall = true;
            for (SpawnBiomeEntry cond : all) {
                if (cond.matches(category, registryName)) continue;
                overall = false;
            }
            if (!overall) continue;
            return true;
        }
        return false;
    }

    public boolean matches(@Nullable Holder<Biome> biomeHolder, ResourceLocation registryName) {
        for (List<SpawnBiomeEntry> all : this.biomes) {
            boolean overall = true;
            for (SpawnBiomeEntry cond : all) {
                if (cond.matches(biomeHolder, registryName)) continue;
                overall = false;
            }
            if (!overall) continue;
            return true;
        }
        return false;
    }

    private class SpawnBiomeEntry {
        BiomeEntryType type;
        boolean negate;
        String value;

        public SpawnBiomeEntry(BiomeEntryType type, boolean remove, String value) {
            this.type = type;
            this.negate = remove;
            this.value = value;
        }

        public boolean matches(@Nullable Holder<Biome> biomeHolder, ResourceLocation registryName) {
            if (this.type.isDepreciated()) {
                Citadel.LOGGER.debug("biome config: BIOME_DICT is no longer fully supported in 1.18+. They will only work for structures.");
                return false;
            }
            if (this.type == BiomeEntryType.BIOME_TAG) {
                if (biomeHolder.getTagKeys().anyMatch(biomeTagKey -> biomeTagKey.f_203868_() != null && biomeTagKey.f_203868_().toString().equals(this.value))) {
                    return !this.negate;
                }
                return this.negate;
            }
            if (this.type == BiomeEntryType.BIOME_CATEGORY) {
                if (Biome.m_204183_(biomeHolder).m_47645_().toLowerCase(Locale.ROOT).equals(this.value)) {
                    return !this.negate;
                }
                return this.negate;
            }
            if (registryName.toString().equals(this.value)) {
                return !this.negate;
            }
            return this.negate;
        }

        public boolean matches(Biome.BiomeCategory category, ResourceLocation registryName) {
            if (this.type == BiomeEntryType.BIOME_DICT) {
                ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)registryName);
                List<String> biomeTypes = BiomeDictionary.getTypes((ResourceKey)biomeKey).stream().map(t -> t.toString().toLowerCase(Locale.ROOT)).toList();
                if (biomeTypes.contains(this.value)) {
                    return !this.negate;
                }
                return this.negate;
            }
            if (this.type == BiomeEntryType.BIOME_CATEGORY) {
                if (category.m_47645_().toLowerCase(Locale.ROOT).equals(this.value)) {
                    return !this.negate;
                }
                return this.negate;
            }
            if (registryName.toString().equals(this.value)) {
                return !this.negate;
            }
            return this.negate;
        }
    }

    static class InvalidCitadelFormatException
    extends JsonParseException {
        InvalidCitadelFormatException(String s) {
            super(s);
        }
    }

    public static class Deserializer
    implements JsonDeserializer<IafSpawnBiomeData>,
    JsonSerializer<IafSpawnBiomeData> {
        public IafSpawnBiomeData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = json.getAsJsonObject();
            int citadelFormat = GsonHelper.m_13824_((JsonObject)jsonobject, (String)IafSpawnBiomeData.CITADEL_FORMAT_STRING, (int)-1);
            if (citadelFormat != 0) {
                throw new InvalidCitadelFormatException("The file contained the %s format version, while we expected a %s format version".formatted(citadelFormat, 0));
            }
            SpawnBiomeEntry[][] biomesRead = (SpawnBiomeEntry[][])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"biomes", (Object)new SpawnBiomeEntry[0][0], (JsonDeserializationContext)context, SpawnBiomeEntry[][].class);
            return new IafSpawnBiomeData(biomesRead);
        }

        public JsonElement serialize(IafSpawnBiomeData src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add(IafSpawnBiomeData.CITADEL_FORMAT_STRING, context.serialize((Object)src.citadelFormat));
            jsonobject.add("biomes", context.serialize(src.biomes));
            return jsonobject;
        }
    }
}

