/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.config.biome;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.iceandfire.config.biome.IafSpawnBiomeData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class SpawnBiomeConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(IafSpawnBiomeData.class, (Object)new IafSpawnBiomeData.Deserializer()).create();
    private final ResourceLocation fileName;

    private SpawnBiomeConfig(ResourceLocation fileName) {
        this.fileName = !fileName.m_135827_().endsWith(".json") ? new ResourceLocation(fileName.m_135827_(), fileName.m_135815_() + ".json") : fileName;
    }

    public static IafSpawnBiomeData create(ResourceLocation fileName, IafSpawnBiomeData dataDefault) {
        SpawnBiomeConfig config = new SpawnBiomeConfig(fileName);
        IafSpawnBiomeData data = config.getConfigData(dataDefault);
        return data;
    }

    public static <T> T getOrCreateConfigFile(File configDir, String configName, T defaults, Type type) {
        File configFile = new File(configDir, configName);
        if (!configFile.exists()) {
            try {
                FileUtils.write((File)configFile, (CharSequence)GSON.toJson(defaults));
            }
            catch (IOException e) {
                Citadel.LOGGER.error("Spawn Biome Config: Could not write " + configFile, (Throwable)e);
            }
        }
        try {
            return (T)GSON.fromJson(FileUtils.readFileToString((File)configFile), type);
        }
        catch (IafSpawnBiomeData.InvalidCitadelFormatException ex) {
            Citadel.LOGGER.error("Spawn Biome Config: %s didn't contain the correct citadel_format version, proceeding with defaults".formatted(configFile), (Object)ex.getMessage());
            if (defaults instanceof IafSpawnBiomeData) {
                IafSpawnBiomeData iafSpawnBiomeData = (IafSpawnBiomeData)((Object)defaults);
                iafSpawnBiomeData.setCitadelFormat(-1);
            }
        }
        catch (Exception e) {
            Citadel.LOGGER.error("Spawn Biome Config: Could not load " + configFile, (Throwable)e);
        }
        return defaults;
    }

    private File getConfigDirFile() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path jsonPath = Paths.get(configPath.toAbsolutePath().toString(), this.fileName.m_135827_());
        return jsonPath.toFile();
    }

    private IafSpawnBiomeData getConfigData(IafSpawnBiomeData defaultConfigData) {
        IafSpawnBiomeData configData = SpawnBiomeConfig.getOrCreateConfigFile(this.getConfigDirFile(), this.fileName.m_135815_(), defaultConfigData, new TypeToken<IafSpawnBiomeData>(){}.getType());
        return configData;
    }
}

