/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.datagen;

import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="iceandfire", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    static PackResources resources = new PackResources();

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            DataGenerators.createResources(ForgeRegistries.BIOMES.getKeys().stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getHolder(arg_0)).filter(Optional::isPresent).map(Optional::get));
            event.addRepositorySource((packConsumer, packConstructor) -> {
                Pack pack = Pack.m_10430_((String)"iceandfire:data", (boolean)true, () -> resources, (Pack.PackConstructor)packConstructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_);
                packConsumer.accept(pack);
            });
        }
    }

    @Deprecated(since="1.19.2", forRemoval=true)
    public static void createResources(Stream<Holder<Biome>> biomeStream) {
        HashMap<TagKey<Biome>, Tag.Builder> builders = new HashMap<TagKey<Biome>, Tag.Builder>();
        builders.put(IafWorldRegistry.HAS_MAUSOLEUM, Tag.Builder.m_13304_());
        builders.put(IafWorldRegistry.HAS_GRAVEYARD, Tag.Builder.m_13304_());
        builders.put(IafWorldRegistry.HAS_GORGON_TEMPLE, Tag.Builder.m_13304_());
        biomeStream.forEach(biomeReference -> {
            if (BiomeConfig.test(BiomeConfig.gorgonTempleBiomes, (Biome)biomeReference.m_203334_())) {
                ((Tag.Builder)builders.get(IafWorldRegistry.HAS_GORGON_TEMPLE)).m_13327_(((Biome)biomeReference.m_203334_()).getRegistryName(), "forge");
            }
            if (BiomeConfig.test(BiomeConfig.graveyardBiomes, (Biome)biomeReference.m_203334_())) {
                ((Tag.Builder)builders.get(IafWorldRegistry.HAS_GRAVEYARD)).m_13327_(((Biome)biomeReference.m_203334_()).getRegistryName(), "forge");
            }
            if (BiomeConfig.test(BiomeConfig.mausoleumBiomes, (Biome)biomeReference.m_203334_())) {
                ((Tag.Builder)builders.get(IafWorldRegistry.HAS_MAUSOLEUM)).m_13327_(((Biome)biomeReference.m_203334_()).getRegistryName(), "forge");
            }
        });
        DataGenerators.addBiomeTag("has_structure/mausoleum.json", (Tag.Builder)builders.get(IafWorldRegistry.HAS_MAUSOLEUM));
        DataGenerators.addBiomeTag("has_structure/graveyard.json", (Tag.Builder)builders.get(IafWorldRegistry.HAS_GRAVEYARD));
        DataGenerators.addBiomeTag("has_structure/gorgon_temple.json", (Tag.Builder)builders.get(IafWorldRegistry.HAS_GORGON_TEMPLE));
    }

    public static void createResources(Registry<Biome> biomes) {
        HashMap<TagKey<Biome>, Tag.Builder> builders = new HashMap<TagKey<Biome>, Tag.Builder>();
        builders.put(IafWorldRegistry.HAS_MAUSOLEUM, Tag.Builder.m_13304_());
        builders.put(IafWorldRegistry.HAS_GRAVEYARD, Tag.Builder.m_13304_());
        builders.put(IafWorldRegistry.HAS_GORGON_TEMPLE, Tag.Builder.m_13304_());
        biomes.m_203611_().forEach(biomeReference -> {
            if (BiomeConfig.test(BiomeConfig.gorgonTempleBiomes, (Holder<Biome>)biomeReference)) {
                ((Tag.Builder)builders.get(IafWorldRegistry.HAS_GORGON_TEMPLE)).m_13327_(biomeReference.m_205785_().m_135782_(), "forge");
            }
            if (BiomeConfig.test(BiomeConfig.graveyardBiomes, (Holder<Biome>)biomeReference)) {
                ((Tag.Builder)builders.get(IafWorldRegistry.HAS_GRAVEYARD)).m_13327_(biomeReference.m_205785_().m_135782_(), "forge");
            }
            if (BiomeConfig.test(BiomeConfig.mausoleumBiomes, (Holder<Biome>)biomeReference)) {
                ((Tag.Builder)builders.get(IafWorldRegistry.HAS_MAUSOLEUM)).m_13327_(biomeReference.m_205785_().m_135782_(), "forge");
            }
        });
        DataGenerators.addBiomeTag("has_structure/mausoleum.json", (Tag.Builder)builders.get(IafWorldRegistry.HAS_MAUSOLEUM));
        DataGenerators.addBiomeTag("has_structure/graveyard.json", (Tag.Builder)builders.get(IafWorldRegistry.HAS_GRAVEYARD));
        DataGenerators.addBiomeTag("has_structure/gorgon_temple.json", (Tag.Builder)builders.get(IafWorldRegistry.HAS_GORGON_TEMPLE));
    }

    static void addBiomeTag(String location, Tag.Builder builder) {
        resources.add(new ResourceLocation("iceandfire", "tags/worldgen/biome/" + location), builder.m_13334_());
    }

    public static class PackResources
    implements net.minecraft.server.packs.PackResources {
        public static final int PACK_FORMAT = 9;
        Map<ResourceLocation, JsonObject> DATA = new HashMap<ResourceLocation, JsonObject>();

        public void add(ResourceLocation location, @NotNull JsonObject data) {
            this.DATA.put(location, data);
        }

        @Nullable
        public InputStream m_5542_(String pFileName) throws IOException {
            return null;
        }

        public InputStream m_8031_(PackType pType, ResourceLocation pLocation) throws IOException {
            if (pType == PackType.SERVER_DATA) {
                return new ByteArrayInputStream(this.DATA.get(pLocation).toString().getBytes());
            }
            throw new IOException("Data wasn't found");
        }

        public Collection<ResourceLocation> m_7466_(PackType pType, String pNamespace, String pPath, int pMaxDepth, Predicate<String> pFilter) {
            ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
            if (pType == PackType.SERVER_DATA) {
                this.DATA.forEach((resourceLocation, _jsonObject) -> {
                    if (resourceLocation.m_135827_().equals(pNamespace) && resourceLocation.toString().startsWith(pPath) && pFilter.test(resourceLocation.m_135815_())) {
                        resources.add((ResourceLocation)resourceLocation);
                    }
                });
            }
            return resources;
        }

        public boolean m_7211_(PackType pType, ResourceLocation pLocation) {
            if (pType != PackType.SERVER_DATA) {
                return false;
            }
            return this.DATA.containsKey(pLocation);
        }

        public String m_8017_() {
            return "iceandfire:data";
        }

        public Set<String> m_5698_(PackType pType) {
            HashSet<String> namespaces = new HashSet<String>();
            if (pType != PackType.SERVER_DATA) {
                return namespaces;
            }
            this.DATA.forEach((resourceLocation, jsonObject) -> namespaces.add(resourceLocation.m_135827_()));
            return namespaces;
        }

        public void close() {
        }

        @Nullable
        public <T> T m_5550_(MetadataSectionSerializer<T> pDeserializer) throws IOException {
            if (pDeserializer.m_7991_().equals("pack")) {
                JsonObject object = new JsonObject();
                object.addProperty("pack_format", (Number)9);
                object.addProperty("description", "Dynamically generated tags");
                return (T)pDeserializer.m_6322_(object);
            }
            return (T)pDeserializer.m_6322_(new JsonObject());
        }
    }
}

