/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockEggInIce;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityEggInIce;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;

public class DragonType {
    public static final DragonType FIRE = new DragonType("fire");
    public static final DragonType ICE = new DragonType("ice").setPiscivore();
    public static final DragonType LIGHTNING = new DragonType("lightning");
    private String name;
    private boolean piscivore;

    public DragonType(String name) {
        this.name = name;
    }

    public static String getNameFromInt(int type) {
        if (type == 2) {
            return "lightning";
        }
        if (type == 1) {
            return "ice";
        }
        return "fire";
    }

    public static int getIntFromType(DragonType type) {
        if (type == LIGHTNING) {
            return 2;
        }
        if (type == ICE) {
            return 1;
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPiscivore() {
        return this.piscivore;
    }

    public DragonType setPiscivore() {
        this.piscivore = true;
        return this;
    }

    public void updateEggCondition(EntityDragonEgg egg) {
        BlockPos pos = new BlockPos(egg.m_20182_());
        if (this == FIRE) {
            if (egg.f_19853_.m_8055_(pos).m_60767_() == Material.f_76309_) {
                egg.setDragonAge(egg.getDragonAge() + 1);
            }
            if (egg.getDragonAge() > IafConfig.dragonEggTime) {
                egg.f_19853_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                EntityFireDragon dragon = new EntityFireDragon(egg.f_19853_);
                if (egg.m_8077_()) {
                    dragon.m_6593_(egg.m_7770_());
                }
                dragon.setVariant(egg.getEggType().ordinal());
                dragon.setGender(egg.m_21187_().nextBoolean());
                dragon.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
                dragon.setHunger(50);
                if (!egg.f_19853_.f_46443_) {
                    egg.f_19853_.m_7967_((Entity)dragon);
                }
                if (egg.m_8077_()) {
                    dragon.m_6593_(egg.m_7770_());
                }
                dragon.m_7105_(true);
                dragon.m_21816_(egg.getOwnerId());
                egg.f_19853_.m_7785_(egg.m_20185_(), egg.m_20186_() + (double)egg.m_20192_(), egg.m_20189_(), SoundEvents.f_11937_, egg.m_5720_(), 2.5f, 1.0f, false);
                egg.f_19853_.m_7785_(egg.m_20185_(), egg.m_20186_() + (double)egg.m_20192_(), egg.m_20189_(), IafSoundRegistry.EGG_HATCH, egg.m_5720_(), 2.5f, 1.0f, false);
                egg.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this == ICE && egg.f_19853_.m_8055_(pos).m_60767_() == Material.f_76305_ && egg.m_21187_().nextInt(500) == 0) {
            egg.f_19853_.m_46597_(pos, ((Block)IafBlockRegistry.EGG_IN_ICE.get()).m_49966_());
            egg.f_19853_.m_7785_(egg.m_20185_(), egg.m_20186_() + (double)egg.m_20192_(), egg.m_20189_(), SoundEvents.f_11983_, egg.m_5720_(), 2.5f, 1.0f, false);
            if (egg.f_19853_.m_8055_(pos).m_60734_() instanceof BlockEggInIce) {
                ((TileEntityEggInIce)egg.f_19853_.m_7702_((BlockPos)pos)).f_58855_ = egg.getEggType();
                ((TileEntityEggInIce)egg.f_19853_.m_7702_((BlockPos)pos)).ownerUUID = egg.getOwnerId();
            }
            egg.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this == LIGHTNING) {
            boolean flag;
            BlockPos.MutableBlockPos blockpos$pooledmutable = new BlockPos.MutableBlockPos(egg.m_20185_(), egg.m_20186_(), egg.m_20189_());
            boolean bl = flag = egg.f_19853_.m_46758_((BlockPos)blockpos$pooledmutable) || egg.f_19853_.m_46758_((BlockPos)blockpos$pooledmutable.m_122169_(egg.m_20185_(), egg.m_20186_() + (double)egg.m_20206_(), egg.m_20189_()));
            if (egg.f_19853_.m_45527_(egg.m_142538_().m_7494_()) && flag) {
                egg.setDragonAge(egg.getDragonAge() + 1);
            }
            if (egg.getDragonAge() > IafConfig.dragonEggTime) {
                EntityLightningDragon dragon = new EntityLightningDragon(egg.f_19853_);
                if (egg.m_8077_()) {
                    dragon.m_6593_(egg.m_7770_());
                }
                dragon.setVariant(egg.getEggType().ordinal() - 8);
                dragon.setGender(egg.m_21187_().nextBoolean());
                dragon.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
                dragon.setHunger(50);
                if (!egg.f_19853_.f_46443_) {
                    egg.f_19853_.m_7967_((Entity)dragon);
                }
                if (egg.m_8077_()) {
                    dragon.m_6593_(egg.m_7770_());
                }
                dragon.m_7105_(true);
                dragon.m_21816_(egg.getOwnerId());
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(egg.f_19853_);
                lightningboltentity.m_6034_(egg.m_20185_(), egg.m_20186_(), egg.m_20189_());
                lightningboltentity.m_20874_(true);
                if (!egg.f_19853_.f_46443_) {
                    egg.f_19853_.m_7967_((Entity)lightningboltentity);
                }
                egg.f_19853_.m_7785_(egg.m_20185_(), egg.m_20186_() + (double)egg.m_20192_(), egg.m_20189_(), SoundEvents.f_12090_, egg.m_5720_(), 2.5f, 1.0f, false);
                egg.f_19853_.m_7785_(egg.m_20185_(), egg.m_20186_() + (double)egg.m_20192_(), egg.m_20189_(), IafSoundRegistry.EGG_HATCH, egg.m_5720_(), 2.5f, 1.0f, false);
                egg.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

