/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class EntityDeathWormEgg
extends ThrowableItemProjectile
implements IEntityAdditionalSpawnData {
    private boolean giant;

    public EntityDeathWormEgg(EntityType<? extends ThrowableItemProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityDeathWormEgg(EntityType<? extends ThrowableItemProjectile> type, LivingEntity throwerIn, Level worldIn, boolean giant) {
        super(type, throwerIn, worldIn);
        this.giant = giant;
    }

    public EntityDeathWormEgg(EntityType<? extends ThrowableItemProjectile> type, double x, double y, double z, Level worldIn, boolean giant) {
        super(type, x, y, z, worldIn);
        this.giant = giant;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.giant);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.giant = additionalData.readBoolean();
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.nextFloat() - 0.5) * 0.08, ((double)this.f_19796_.nextFloat() - 0.5) * 0.08, ((double)this.f_19796_.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void m_6532_(HitResult result) {
        Entity thrower = this.m_37282_();
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            ((EntityHitResult)result).m_82443_().m_6469_(DamageSource.m_19361_((Entity)this, (Entity)thrower), 0.0f);
        }
        if (!this.f_19853_.f_46443_) {
            float wormSize = 0.25f + (float)(Math.random() * (double)0.35f);
            EntityDeathWorm deathworm = new EntityDeathWorm((EntityType<EntityDeathWorm>)((EntityType)IafEntityRegistry.DEATH_WORM.get()), this.f_19853_);
            deathworm.setVariant(this.f_19796_.nextInt(3));
            deathworm.m_7105_(true);
            deathworm.setWormHome(this.m_142538_());
            deathworm.setWormAge(1);
            deathworm.setDeathWormScale(this.giant ? wormSize * 4.0f : wormSize);
            deathworm.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            if (thrower instanceof Player) {
                deathworm.m_21816_(thrower.m_142081_());
            }
            this.f_19853_.m_7967_((Entity)deathworm);
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @NotNull
    protected Item m_7881_() {
        return this.giant ? (Item)IafItemRegistry.DEATHWORM_EGG_GIGANTIC.get() : (Item)IafItemRegistry.DEATHWORM_EGG.get();
    }
}

