/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIFindWaterTarget;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIGetInWater;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.HippocampusAIRide;
import com.github.alexthe666.iceandfire.entity.ai.HippocampusAIWander;
import com.github.alexthe666.iceandfire.entity.util.ChainBuffer;
import com.github.alexthe666.iceandfire.entity.util.ICustomMoveController;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.inventory.HippocampusContainerMenu;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateAmphibious;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class EntityHippocampus
extends TamableAnimal
implements ISyncMount,
IAnimatedEntity,
IHasCustomizableAttributes,
ICustomMoveController,
ContainerListener,
Saddleable {
    public static final int INV_SLOT_SADDLE = 0;
    public static final int INV_SLOT_CHEST = 1;
    public static final int INV_SLOT_ARMOR = 2;
    public static final int INV_BASE_COUNT = 3;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SADDLE = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ARMOR = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> CONTROL_STATE = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_SITTING = 1;
    private static final int FLAG_TAME = 4;
    private static final Component CONTAINER_TITLE = new TranslatableComponent("entity.iceandfire.hippocampus");
    public static Animation ANIMATION_SPEAK;
    public float onLandProgress;
    public ChainBuffer tail_buffer;
    public SimpleContainer inventory;
    public float sitProgress;
    public int airBorneCounter;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isLandNavigator;
    private LazyOptional<?> itemHandler = null;

    public EntityHippocampus(EntityType<EntityHippocampus> t, Level worldIn) {
        super(t, worldIn);
        IHasCustomizableAttributes.applyAttributesForEntity(t, this);
        this.f_19793_ = 1.0f;
        ANIMATION_SPEAK = Animation.create((int)15);
        this.switchNavigator(true);
        if (worldIn.f_46443_) {
            this.tail_buffer = new ChainBuffer();
        }
        this.createInventory();
    }

    public static int getIntFromArmor(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() == Items.f_42651_) {
            return 1;
        }
        if (!stack.m_41619_() && stack.m_41720_() == Items.f_42652_) {
            return 2;
        }
        if (!stack.m_41619_() && stack.m_41720_() == Items.f_42653_) {
            return 3;
        }
        return 0;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HippocampusAIRide(this));
        this.f_21345_.m_25352_(0, (Goal)new AquaticAITempt((Mob)this, 1.0, () -> Items.f_41910_, false));
        this.f_21345_.m_25352_(0, (Goal)new AquaticAITempt((Mob)this, 1.0, () -> Items.f_42696_, false));
        this.f_21345_.m_25352_(1, (Goal)new AquaticAIFindWaterTarget((Mob)this, 10, true));
        this.f_21345_.m_25352_(2, (Goal)new AquaticAIGetInWater((Mob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new HippocampusAIWander((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
    }

    protected int m_6552_(@NotNull Player player) {
        return 2;
    }

    public float m_21692_(BlockPos pos) {
        return this.f_19853_.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76305_ ? 10.0f : (float)this.f_19853_.m_46803_(pos) - 0.5f;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6063_() {
        return false;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new PathNavigateAmphibious((PathfinderMob)this, this.f_19853_);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new SwimmingMoveHelper();
            this.f_21344_ = new WaterBoundPathNavigation((Mob)this, this.f_19853_);
            this.isLandNavigator = false;
        }
    }

    public boolean m_7307_(@NotNull Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_142480_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(ARMOR, (Object)0);
        this.f_19804_.m_135372_(SADDLE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CHESTED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CONTROL_STATE, (Object)0);
    }

    @Nullable
    public Entity m_6688_() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player) || this.m_5448_() == passenger) continue;
            Player player = (Player)passenger;
            return player;
        }
        return null;
    }

    public boolean m_21540_(@Nullable ItemStack itemStackIn) {
        EquipmentSlot equipmentSlot = EntityHippocampus.m_147233_((ItemStack)itemStackIn);
        int j = equipmentSlot.m_20749_() - 500 + 2;
        if (j >= 0 && j < this.inventory.m_6643_()) {
            this.inventory.m_6836_(j, itemStackIn);
            return true;
        }
        return false;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null && !this.f_19853_.f_46443_) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
        if (this.isChested()) {
            if (!this.f_19853_.f_46443_) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
            }
            this.setChested(false);
        }
    }

    protected void dropChestItems() {
        for (int i = 3; i < 18; ++i) {
            if (this.inventory.m_8020_(i).m_41619_()) continue;
            if (!this.f_19853_.f_46443_) {
                this.m_5552_(this.inventory.m_8020_(i), 1.0f);
            }
            this.inventory.m_8016_(i);
        }
    }

    private void updateControlState(int i, boolean newState) {
        byte prevState = (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
        if (newState) {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.f_19804_.m_135381_(CONTROL_STATE, (Object)state);
    }

    @Override
    public AttributeSupplier.Builder getConfigurableAttributes() {
        return EntityHippocampus.bakeAttributes();
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public void m_7332_(@NotNull Entity passenger) {
        super.m_7332_(passenger);
        if (this.m_20363_(passenger)) {
            this.f_20883_ = this.m_146908_();
            this.m_5618_(passenger.m_146908_());
        }
        double ymod1 = (double)this.onLandProgress * -0.02;
        passenger.m_6034_(this.m_20185_(), this.m_20186_() + (double)0.6f + ymod1, this.m_20189_());
    }

    public void m_8107_() {
        boolean inWater;
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.f_19796_.nextInt(900) == 0 && this.f_20919_ == 0) {
            this.m_5634_(1.0f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.m_6688_() instanceof LivingEntity && this.f_19797_ % 20 == 0) {
            ((LivingEntity)this.m_6688_()).m_7292_(new MobEffectInstance(MobEffects.f_19608_, 30, 0, true, false));
        }
        this.airBorneCounter = !this.f_19861_ ? ++this.airBorneCounter : 0;
        if (this.f_19853_.f_46443_) {
            this.tail_buffer.calculateChainSwingBuffer(40.0f, 10, 1.0f, (LivingEntity)this);
        }
        if (this.up()) {
            if (!this.m_20069_() && this.airBorneCounter == 0 && this.f_19861_) {
                this.m_6135_();
            } else if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.4, 0.0));
            }
        }
        if (this.down()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.4, 0.0));
        }
        if (this.m_20069_() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.m_20069_() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        boolean bl = inWater = !this.m_20069_();
        if (inWater && this.onLandProgress < 20.0f) {
            this.onLandProgress += 1.0f;
        } else if (!inWater && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        boolean sitting = this.m_21827_();
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
    }

    public boolean up() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) & 1) == 1;
    }

    public boolean down() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean isBlinking() {
        return this.f_19797_ % 50 > 43;
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("Chested", this.isChested());
        compound.m_128379_("Saddled", this.m_6254_());
        compound.m_128405_("Armor", this.getArmor());
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag CompoundNBT = new CompoundTag();
            CompoundNBT.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(CompoundNBT);
            nbttaglist.add((Object)CompoundNBT);
        }
        compound.m_128365_("Items", (Tag)nbttaglist);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setChested(compound.m_128471_("Chested"));
        this.setSaddled(compound.m_128471_("Saddled"));
        this.setArmor(compound.m_128451_("Armor"));
        if (this.inventory != null) {
            ListTag nbttaglist = compound.m_128437_("Items", 10);
            this.createInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag CompoundNBT = nbttaglist.m_128728_(i);
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        }
    }

    protected int getInventorySize() {
        return this.isChested() ? 18 : 3;
    }

    private SlotAccess createEquipmentSlotAccess(final int pSlot, final Predicate<ItemStack> pStackFilter) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return EntityHippocampus.this.inventory.m_8020_(pSlot);
            }

            public boolean m_142104_(ItemStack p_149528_) {
                if (!pStackFilter.test(p_149528_)) {
                    return false;
                }
                EntityHippocampus.this.inventory.m_6836_(pSlot, p_149528_);
                EntityHippocampus.this.updateContainerEquipment();
                return true;
            }
        };
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (!this.f_19853_.f_46443_) {
            this.setSaddled(!this.inventory.m_8020_(0).m_41619_());
            this.setChested(!this.inventory.m_8020_(1).m_41619_());
            this.setArmor(EntityHippocampus.getIntFromArmor(this.inventory.m_8020_(2)));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean hasInventoryChanged(Container pInventory) {
        return this.inventory != pInventory;
    }

    public boolean m_6741_() {
        return false;
    }

    public void m_5853_(@Nullable SoundSource pSource) {
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(SADDLE);
    }

    public void setSaddled(boolean saddle) {
        this.f_19804_.m_135381_(SADDLE, (Object)saddle);
    }

    public boolean isChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setChested(boolean chested) {
        this.f_19804_.m_135381_(CHESTED, (Object)chested);
        if (!chested) {
            this.dropChestItems();
        }
    }

    public int getArmor() {
        return (Integer)this.f_19804_.m_135370_(ARMOR);
    }

    public void setArmor(int armorType) {
        this.f_19804_.m_135381_(ARMOR, (Object)armorType);
        double armorValue = 0.0;
        switch (armorType) {
            case 1: {
                armorValue = 10.0;
                break;
            }
            case 2: {
                armorValue = 20.0;
                break;
            }
            case 3: {
                armorValue = 30.0;
            }
        }
        this.m_21051_(Attributes.f_22284_).m_22100_(armorValue);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.m_21187_().nextInt(6));
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_SPEAK};
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverWorld, @NotNull AgeableMob ageable) {
        if (ageable instanceof EntityHippocampus) {
            EntityHippocampus hippo = new EntityHippocampus((EntityType<EntityHippocampus>)((EntityType)IafEntityRegistry.HIPPOCAMPUS.get()), this.f_19853_);
            hippo.setVariant(this.m_21187_().nextBoolean() ? this.getVariant() : ((EntityHippocampus)ageable).getVariant());
            return hippo;
        }
        return null;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_7023_(@NotNull Vec3 vec) {
        if (this.m_21827_()) {
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        if (this.m_6142_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.1f, vec);
                float f4 = 0.6f;
                float d0 = EnchantmentHelper.m_44922_((LivingEntity)this);
                if (d0 > 3.0f) {
                    d0 = 3.0f;
                }
                if (!this.f_19861_) {
                    d0 *= 0.5f;
                }
                if (d0 > 0.0f) {
                    f4 += (0.54600006f - f4) * d0 / 3.0f;
                }
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82542_((double)f4 * 0.9, (double)f4 * 0.9, (double)f4 * 0.9));
            } else {
                super.m_7023_(vec);
            }
        }
        this.f_20923_ = this.f_20924_;
        double deltaX = this.m_20185_() - this.f_19854_;
        double deltaZ = this.m_20189_() - this.f_19856_;
        double deltaY = this.m_20186_() - this.f_19855_;
        float delta = Mth.m_14116_((float)((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ))) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.f_20924_ += (delta - this.f_20924_) * 0.4f;
        this.f_20925_ += this.f_20924_;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42696_;
    }

    public void m_8032_() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_8032_();
    }

    protected void m_6677_(@NotNull DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_6677_(source);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42696_ && this.m_146764_() == 0 && !this.m_27593_()) {
            this.m_21839_(false);
            this.m_27595_(player);
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == Items.f_41910_) {
            int i;
            if (!this.f_19853_.f_46443_) {
                this.m_5634_(5.0f);
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                for (i = 0; i < 3; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), 0.0, 0.0, 0.0);
                }
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
            }
            if (!this.m_21824_() && this.m_21187_().nextInt(3) == 0) {
                this.m_21828_(player);
                for (i = 0; i < 6; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), 0.0, 0.0, 0.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21830_((LivingEntity)player) && itemstack.m_41720_() == Items.f_42398_) {
            this.m_21839_(!this.m_21827_());
            return InteractionResult.SUCCESS;
        }
        if (this.m_21830_((LivingEntity)player) && itemstack.m_41619_() && player.m_6144_()) {
            this.openInventory(player);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.m_21830_((LivingEntity)player) && this.m_6254_() && !this.m_6162_() && !player.m_20159_()) {
            this.doPlayerRide(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void doPlayerRide(Player pPlayer) {
        this.m_21839_(false);
        if (!this.f_19853_.f_46443_) {
            pPlayer.m_146922_(this.m_146908_());
            pPlayer.m_146926_(this.m_146909_());
            pPlayer.m_20329_((Entity)this);
        }
    }

    public void openInventory(Player player) {
        if (!this.f_19853_.f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getMenuProvider());
        }
        IceAndFire.PROXY.setReferencedMob((Entity)this);
    }

    public MenuProvider getMenuProvider() {
        return new SimpleMenuProvider((containerId, playerInventory, player) -> new HippocampusContainerMenu(containerId, (Container)this.inventory, playerInventory, this), CONTAINER_TITLE);
    }

    @Override
    public void up(boolean up) {
        this.updateControlState(0, up);
    }

    @Override
    public void down(boolean down) {
        this.updateControlState(1, down);
    }

    @Override
    public void attack(boolean attack) {
    }

    @Override
    public void strike(boolean strike) {
    }

    @Override
    public void dismount(boolean dismount) {
        this.updateControlState(2, dismount);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return IafSoundRegistry.HIPPOCAMPUS_IDLE;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return IafSoundRegistry.HIPPOCAMPUS_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return IafSoundRegistry.HIPPOCAMPUS_DIE;
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6109_() {
        return false;
    }

    public boolean m_5807_() {
        return true;
    }

    @Nullable
    public Player getRidingPlayer() {
        if (this.m_6688_() instanceof Player) {
            return (Player)this.m_6688_();
        }
        return null;
    }

    public double getRideSpeedModifier() {
        return this.m_20069_() ? (double)0.7f * IafConfig.hippocampusSwimSpeedMod : (double)0.55f;
    }

    public int getInventoryColumns() {
        return 5;
    }

    public void m_5757_(Container pInvBasic) {
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
        }
    }

    class SwimmingMoveHelper
    extends MoveControl {
        private final EntityHippocampus hippo;

        public SwimmingMoveHelper() {
            super((Mob)EntityHippocampus.this);
            this.hippo = EntityHippocampus.this;
        }

        public void m_8126_() {
            if (this.hippo.m_20160_()) {
                double flySpeed = this.hippo.getRideSpeedModifier() * this.hippo.m_21133_(Attributes.f_22279_);
                Vec3 dragonVec = this.hippo.m_20182_();
                Vec3 moveVec = new Vec3(this.f_24975_, this.f_24976_, this.f_24977_);
                Vec3 normalized = moveVec.m_82546_(dragonVec).m_82541_();
                double dist = dragonVec.m_82554_(moveVec);
                this.hippo.m_20334_(normalized.f_82479_ * flySpeed, normalized.f_82480_ * flySpeed, normalized.f_82481_ * flySpeed);
                if (dist > 2.5E-7) {
                    float yaw = (float)Math.toDegrees(Math.PI * 2 - Math.atan2(normalized.f_82479_, normalized.f_82480_));
                    this.hippo.m_146922_(this.m_24991_(this.hippo.m_146908_(), yaw, 5.0f));
                    this.hippo.m_7910_((float)this.f_24978_);
                }
                this.hippo.m_6478_(MoverType.SELF, this.hippo.m_20184_());
            } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.hippo.m_21573_().m_26571_()) {
                double distanceX = this.f_24975_ - this.hippo.m_20185_();
                double distanceY = this.f_24976_ - this.hippo.m_20186_();
                double distanceZ = this.f_24977_ - this.hippo.m_20189_();
                double distance = Math.abs(distanceX * distanceX + distanceZ * distanceZ);
                double distanceWithY = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                distanceY /= distanceWithY;
                float angle = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.hippo.m_146922_(this.m_24991_(this.hippo.m_146908_(), angle, 30.0f));
                this.hippo.m_7910_(1.0f);
                float f1 = 0.0f;
                float f2 = 0.0f;
                if (distance < (double)Math.max(1.0f, this.hippo.m_20205_())) {
                    float f = this.hippo.m_146908_() * ((float)Math.PI / 180);
                    f1 = (float)((double)f1 - (double)(Mth.m_14031_((float)f) * 0.35f));
                    f2 = (float)((double)f2 + (double)(Mth.m_14089_((float)f) * 0.35f));
                }
                this.hippo.m_20256_(this.hippo.m_20184_().m_82520_((double)f1, (double)this.hippo.m_6113_() * distanceY * 0.1, (double)f2));
            } else if (this.f_24981_ == MoveControl.Operation.JUMPING) {
                this.hippo.m_7910_((float)(this.f_24978_ * this.hippo.m_21051_(Attributes.f_22279_).m_22135_()));
                if (this.hippo.f_19861_) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            } else {
                this.hippo.m_7910_(0.0f);
            }
        }
    }
}

