/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.api.event.DragonFireDamageWorldEvent;
import com.github.alexthe666.iceandfire.block.BlockCharedPath;
import com.github.alexthe666.iceandfire.block.BlockFallingReturningState;
import com.github.alexthe666.iceandfire.block.BlockReturningState;
import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.props.FrozenProperties;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeInput;
import com.github.alexthe666.iceandfire.entity.util.BlockLaunchExplosion;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.misc.IafDamageRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class IafDragonDestructionManager {
    public static void destroyAreaFire(Level world, BlockPos center, EntityDragonBase destroyer) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.m_123341_(), center.m_123342_(), center.m_123343_()))) {
            return;
        }
        IafDamageRegistry.CustomEntityDamageSource source = destroyer.getRidingPlayer() != null ? IafDamageRegistry.causeIndirectDragonFireDamage((Entity)destroyer, (Entity)destroyer.getRidingPlayer()) : IafDamageRegistry.causeDragonFireDamage((Entity)destroyer);
        int stage = destroyer.getDragonStage();
        double damageRadius = 3.5;
        float dmgScale = (float)IafConfig.dragonAttackDamageFire;
        if (stage <= 3) {
            BlockPos.m_121990_((BlockPos)center.m_142082_(-1, -1, -1), (BlockPos)center.m_142082_(1, 1, 1)).forEach(pos -> {
                if (world.m_7702_(pos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.m_7702_(pos)).onHitWithFlame();
                    return;
                }
                if (IafConfig.dragonGriefing != 2 && world.f_46441_.nextBoolean()) {
                    IafDragonDestructionManager.fireAttackBlock(world, pos);
                }
            });
        } else {
            int radius = stage == 4 ? 2 : 3;
            int j = radius + world.f_46441_.nextInt(1);
            int k = radius + world.f_46441_.nextInt(1);
            int l = radius + world.f_46441_.nextInt(1);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            float ff = f * f;
            damageRadius = 2.5f + f * 1.2f;
            BlockPos.m_121990_((BlockPos)center.m_142082_(-j, -k, -l), (BlockPos)center.m_142082_(j, k, l)).forEach(pos -> {
                if (world.m_7702_(pos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.m_7702_(pos)).onHitWithFlame();
                    return;
                }
                if (center.m_123331_((Vec3i)pos) <= (double)ff && IafConfig.dragonGriefing != 2 && world.f_46441_.nextFloat() > (float)center.m_123331_((Vec3i)pos) / ff) {
                    IafDragonDestructionManager.fireAttackBlock(world, pos);
                }
            });
        }
        float stageDmg = (float)stage * dmgScale;
        int statusDuration = 5 + stage * 5;
        world.m_45976_(LivingEntity.class, new AABB((double)center.m_123341_() - damageRadius, (double)center.m_123342_() - damageRadius, (double)center.m_123343_() - damageRadius, (double)center.m_123341_() + damageRadius, (double)center.m_123342_() + damageRadius, (double)center.m_123343_() + damageRadius)).stream().forEach(arg_0 -> IafDragonDestructionManager.lambda$destroyAreaFire$2(destroyer, (DamageSource)source, stageDmg, statusDuration, arg_0));
    }

    public static void destroyAreaIce(Level world, BlockPos center, EntityDragonBase destroyer) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.m_123341_(), center.m_123342_(), center.m_123343_()))) {
            return;
        }
        IafDamageRegistry.CustomEntityDamageSource source = destroyer.getRidingPlayer() != null ? IafDamageRegistry.causeIndirectDragonIceDamage((Entity)destroyer, (Entity)destroyer.getRidingPlayer()) : IafDamageRegistry.causeDragonIceDamage((Entity)destroyer);
        int stage = destroyer.getDragonStage();
        double damageRadius = 3.5;
        float dmgScale = (float)IafConfig.dragonAttackDamageIce;
        if (stage <= 3) {
            BlockPos.m_121990_((BlockPos)center.m_142082_(-1, -1, -1), (BlockPos)center.m_142082_(1, 1, 1)).forEach(pos -> {
                if (world.m_7702_(pos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.m_7702_(pos)).onHitWithFlame();
                    return;
                }
                if (IafConfig.dragonGriefing != 2 && world.f_46441_.nextBoolean()) {
                    IafDragonDestructionManager.iceAttackBlock(world, pos);
                }
            });
        } else {
            int radius = stage == 4 ? 2 : 3;
            int j = radius + world.f_46441_.nextInt(1);
            int k = radius + world.f_46441_.nextInt(1);
            int l = radius + world.f_46441_.nextInt(1);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            float ff = f * f;
            damageRadius = 2.5f + f * 1.2f;
            BlockPos.m_121990_((BlockPos)center.m_142082_(-j, -k, -l), (BlockPos)center.m_142082_(j, k, l)).forEach(pos -> {
                if (world.m_7702_(pos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.m_7702_(pos)).onHitWithFlame();
                    return;
                }
                if (center.m_123331_((Vec3i)pos) <= (double)ff && IafConfig.dragonGriefing != 2 && world.f_46441_.nextFloat() > (float)center.m_123331_((Vec3i)pos) / ff) {
                    IafDragonDestructionManager.iceAttackBlock(world, pos);
                }
            });
        }
        float stageDmg = (float)stage * dmgScale;
        int statusDuration = 50 * stage;
        world.m_45976_(LivingEntity.class, new AABB((double)center.m_123341_() - damageRadius, (double)center.m_123342_() - damageRadius, (double)center.m_123343_() - damageRadius, (double)center.m_123341_() + damageRadius, (double)center.m_123342_() + damageRadius, (double)center.m_123343_() + damageRadius)).stream().forEach(arg_0 -> IafDragonDestructionManager.lambda$destroyAreaIce$5(destroyer, (DamageSource)source, stageDmg, statusDuration, arg_0));
    }

    public static void destroyAreaLightning(Level world, BlockPos center, EntityDragonBase destroyer) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.m_123341_(), center.m_123342_(), center.m_123343_()))) {
            return;
        }
        IafDamageRegistry.CustomEntityDamageSource source = destroyer.getRidingPlayer() != null ? IafDamageRegistry.causeIndirectDragonLightningDamage((Entity)destroyer, (Entity)destroyer.getRidingPlayer()) : IafDamageRegistry.causeDragonLightningDamage((Entity)destroyer);
        int stage = destroyer.getDragonStage();
        double damageRadius = 3.5;
        float dmgScale = (float)IafConfig.dragonAttackDamageLightning;
        if (stage <= 3) {
            BlockPos.m_121990_((BlockPos)center.m_142082_(-1, -1, -1), (BlockPos)center.m_142082_(1, 1, 1)).forEach(pos -> {
                if (world.m_7702_(pos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.m_7702_(pos)).onHitWithFlame();
                    return;
                }
                if (IafConfig.dragonGriefing != 2 && world.f_46441_.nextBoolean()) {
                    IafDragonDestructionManager.lightningAttackBlock(world, pos);
                }
            });
        } else {
            int radius = stage == 4 ? 2 : 3;
            int j = radius + world.f_46441_.nextInt(1);
            int k = radius + world.f_46441_.nextInt(1);
            int l = radius + world.f_46441_.nextInt(1);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            float ff = f * f;
            damageRadius = 2.5f + f * 1.2f;
            BlockPos.m_121990_((BlockPos)center.m_142082_(-j, -k, -l), (BlockPos)center.m_142082_(j, k, l)).forEach(pos -> {
                if (world.m_7702_(pos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.m_7702_(pos)).onHitWithFlame();
                    return;
                }
                if (center.m_123331_((Vec3i)pos) <= (double)ff && IafConfig.dragonGriefing != 2 && world.f_46441_.nextFloat() > (float)center.m_123331_((Vec3i)pos) / ff) {
                    IafDragonDestructionManager.lightningAttackBlock(world, pos);
                }
            });
        }
        float stageDmg = (float)stage * dmgScale;
        world.m_45976_(LivingEntity.class, new AABB((double)center.m_123341_() - damageRadius, (double)center.m_123342_() - damageRadius, (double)center.m_123343_() - damageRadius, (double)center.m_123341_() + damageRadius, (double)center.m_123342_() + damageRadius, (double)center.m_123343_() + damageRadius)).stream().forEach(arg_0 -> IafDragonDestructionManager.lambda$destroyAreaLightning$8(destroyer, (DamageSource)source, stageDmg, arg_0));
    }

    public static void destroyAreaFireCharge(Level world, BlockPos center, EntityDragonBase destroyer) {
        if (destroyer != null) {
            if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.m_123341_(), center.m_123342_(), center.m_123343_()))) {
                return;
            }
            IafDamageRegistry.CustomEntityDamageSource source = destroyer.getRidingPlayer() != null ? IafDamageRegistry.causeIndirectDragonFireDamage((Entity)destroyer, (Entity)destroyer.getRidingPlayer()) : IafDamageRegistry.causeDragonFireDamage((Entity)destroyer);
            int stage = destroyer.getDragonStage();
            int j = 2;
            int k = 2;
            int l = 2;
            if (stage <= 3) {
                BlockPos.m_121990_((BlockPos)center.m_142082_(-j, -k, -l), (BlockPos)center.m_142082_(j, k, l)).forEach(pos -> {
                    if ((double)(world.f_46441_.nextFloat() * 3.0f) > center.m_123331_((Vec3i)pos) && !(world.m_8055_(pos).m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(world.m_8055_(pos).m_60734_())) {
                        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                    if (world.f_46441_.nextBoolean()) {
                        IafDragonDestructionManager.fireAttackBlock(world, pos);
                    }
                });
            } else {
                int radius = stage == 4 ? 2 : 3;
                j = radius + world.f_46441_.nextInt(2);
                k = radius + world.f_46441_.nextInt(2);
                l = radius + world.f_46441_.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                float ff = f * f;
                IafDragonDestructionManager.destroyBlocks(world, center, j, k, l, ff);
                BlockPos.m_121990_((BlockPos)center.m_142082_(-(++j), -(++k), -(++l)), (BlockPos)center.m_142082_(j, k, l)).forEach(pos -> {
                    if (center.m_123331_((Vec3i)pos) <= (double)ff) {
                        IafDragonDestructionManager.fireAttackBlock(world, pos);
                    }
                });
            }
            float stageDmg = (float)Math.max(1, stage - 1) * 2.0f;
            int statusDuration = 15;
            world.m_45976_(LivingEntity.class, new AABB((double)center.m_123341_() - (double)j, (double)center.m_123342_() - (double)k, (double)center.m_123343_() - (double)l, (double)center.m_123341_() + (double)j, (double)center.m_123342_() + (double)k, (double)center.m_123343_() + (double)l)).stream().forEach(arg_0 -> IafDragonDestructionManager.lambda$destroyAreaFireCharge$11(destroyer, (DamageSource)source, stageDmg, arg_0));
            if (IafConfig.explosiveDragonBreath) {
                IafDragonDestructionManager.causeExplosion(world, center, destroyer, (DamageSource)source, stage);
            }
        }
    }

    public static void destroyAreaIceCharge(Level world, BlockPos center, EntityDragonBase destroyer) {
        if (destroyer != null) {
            if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.m_123341_(), center.m_123342_(), center.m_123343_()))) {
                return;
            }
            IafDamageRegistry.CustomEntityDamageSource source = destroyer.getRidingPlayer() != null ? IafDamageRegistry.causeIndirectDragonIceDamage((Entity)destroyer, (Entity)destroyer.getRidingPlayer()) : IafDamageRegistry.causeDragonIceDamage((Entity)destroyer);
            int stage = destroyer.getDragonStage();
            int j = 2;
            int k = 2;
            int l = 2;
            if (stage <= 3) {
                BlockPos.m_121990_((BlockPos)center.m_142082_(-j, -k, -l), (BlockPos)center.m_142082_(j, k, l)).forEach(pos -> {
                    if ((double)(world.f_46441_.nextFloat() * 3.0f) > center.m_123331_((Vec3i)pos) && !(world.m_8055_(pos).m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(world.m_8055_(pos).m_60734_())) {
                        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                    if (world.f_46441_.nextBoolean()) {
                        IafDragonDestructionManager.iceAttackBlock(world, pos);
                    }
                });
            } else {
                int radius = stage == 4 ? 2 : 3;
                j = radius + world.f_46441_.nextInt(2);
                k = radius + world.f_46441_.nextInt(2);
                l = radius + world.f_46441_.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                float ff = f * f;
                IafDragonDestructionManager.destroyBlocks(world, center, j, k, l, ff);
                BlockPos.m_121990_((BlockPos)center.m_142082_(-(++j), -(++k), -(++l)), (BlockPos)center.m_142082_(j, k, l)).forEach(pos -> {
                    if (center.m_123331_((Vec3i)pos) <= (double)ff) {
                        IafDragonDestructionManager.iceAttackBlock(world, pos);
                    }
                });
            }
            float stageDmg = (float)Math.max(1, stage - 1) * 2.0f;
            int statusDuration = 400;
            world.m_45976_(LivingEntity.class, new AABB((double)center.m_123341_() - (double)j, (double)center.m_123342_() - (double)k, (double)center.m_123343_() - (double)l, (double)center.m_123341_() + (double)j, (double)center.m_123342_() + (double)k, (double)center.m_123343_() + (double)l)).stream().forEach(arg_0 -> IafDragonDestructionManager.lambda$destroyAreaIceCharge$14(destroyer, (DamageSource)source, stageDmg, arg_0));
            if (IafConfig.explosiveDragonBreath) {
                IafDragonDestructionManager.causeExplosion(world, center, destroyer, (DamageSource)source, stage);
            }
        }
    }

    public static void destroyAreaLightningCharge(Level world, BlockPos center, EntityDragonBase destroyer) {
        if (destroyer != null) {
            if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.m_123341_(), center.m_123342_(), center.m_123343_()))) {
                return;
            }
            IafDamageRegistry.CustomEntityDamageSource source = destroyer.getRidingPlayer() != null ? IafDamageRegistry.causeIndirectDragonLightningDamage((Entity)destroyer, (Entity)destroyer.getRidingPlayer()) : IafDamageRegistry.causeDragonLightningDamage((Entity)destroyer);
            int stage = destroyer.getDragonStage();
            int j = 2;
            int k = 2;
            int l = 2;
            if (stage <= 3) {
                BlockPos.m_121990_((BlockPos)center.m_142082_(-j, -k, -l), (BlockPos)center.m_142082_(j, k, l)).forEach(pos -> {
                    if (Math.pow(world.f_46441_.nextFloat() * 7.0f, 2.0) > center.m_123331_((Vec3i)pos) && !(world.m_8055_(pos).m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(world.m_8055_(pos).m_60734_())) {
                        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                    if (Math.pow(world.f_46441_.nextFloat() * 7.0f, 2.0) > center.m_123331_((Vec3i)pos) && !(world.m_8055_(pos).m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(world.m_8055_(pos).m_60734_())) {
                        BlockState transformState = IafDragonDestructionManager.transformBlockLightning(world.m_8055_(pos));
                        world.m_46597_(pos, transformState);
                    }
                });
            } else {
                int radius = stage == 4 ? 2 : 3;
                j = radius + world.f_46441_.nextInt(2);
                k = radius + world.f_46441_.nextInt(2);
                l = radius + world.f_46441_.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                float ff = f * f;
                IafDragonDestructionManager.destroyBlocks(world, center, j, k, l, ff);
                BlockPos.m_121990_((BlockPos)center.m_142082_(-(++j), -(++k), -(++l)), (BlockPos)center.m_142082_(j, k, l)).forEach(pos -> {
                    if (center.m_123331_((Vec3i)pos) <= (double)ff && !(world.m_8055_(pos).m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(world.m_8055_(pos).m_60734_())) {
                        BlockState transformState = IafDragonDestructionManager.transformBlockLightning(world.m_8055_(pos));
                        world.m_46597_(pos, transformState);
                    }
                });
            }
            float stageDmg = (float)Math.max(1, stage - 1) * 2.0f;
            world.m_45976_(LivingEntity.class, new AABB((double)center.m_123341_() - (double)j, (double)center.m_123342_() - (double)k, (double)center.m_123343_() - (double)l, (double)center.m_123341_() + (double)j, (double)center.m_123342_() + (double)k, (double)center.m_123343_() + (double)l)).stream().forEach(arg_0 -> IafDragonDestructionManager.lambda$destroyAreaLightningCharge$17(destroyer, (DamageSource)source, stageDmg, arg_0));
            if (IafConfig.explosiveDragonBreath) {
                IafDragonDestructionManager.causeExplosion(world, center, destroyer, (DamageSource)source, stage);
            }
        }
    }

    private static void causeExplosion(Level world, BlockPos center, EntityDragonBase destroyer, DamageSource source, int stage) {
        Explosion.BlockInteraction mode = ForgeEventFactory.getMobGriefingEvent((Level)world, (Entity)destroyer) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
        BlockLaunchExplosion explosion = new BlockLaunchExplosion(world, (Mob)destroyer, source, center.m_123341_(), center.m_123342_(), center.m_123343_(), Math.min(2, stage - 2), mode);
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    private static void fireAttackBlock(Level world, BlockPos pos) {
        if (!(world.m_8055_(pos).m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(world.m_8055_(pos).m_60734_())) {
            BlockState transformState = IafDragonDestructionManager.transformBlockFire(world.m_8055_(pos));
            if (transformState.m_60734_() != world.m_8055_(pos).m_60734_()) {
                world.m_46597_(pos, transformState);
            }
            if (world.f_46441_.nextBoolean() && transformState.m_60767_().m_76333_() && world.m_6425_(pos.m_7494_()).m_76178_() && !world.m_8055_(pos.m_7494_()).m_60815_() && world.m_8055_(pos).m_60815_() && DragonUtils.canDragonBreak(world.m_8055_(pos.m_7494_()).m_60734_())) {
                world.m_46597_(pos.m_7494_(), Blocks.f_50083_.m_49966_());
            }
        }
    }

    private static void iceAttackBlock(Level world, BlockPos pos) {
        if (!(world.m_8055_(pos).m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(world.m_8055_(pos).m_60734_())) {
            BlockState transformState = IafDragonDestructionManager.transformBlockIce(world.m_8055_(pos));
            if (transformState.m_60734_() != world.m_8055_(pos).m_60734_()) {
                world.m_46597_(pos, transformState);
            }
            if (world.f_46441_.nextInt(9) == 0 && transformState.m_60767_().m_76333_() && world.m_6425_(pos.m_7494_()).m_76178_() && !world.m_8055_(pos.m_7494_()).m_60815_() && world.m_8055_(pos).m_60815_() && DragonUtils.canDragonBreak(world.m_8055_(pos.m_7494_()).m_60734_())) {
                world.m_46597_(pos.m_7494_(), ((Block)IafBlockRegistry.DRAGON_ICE_SPIKES.get()).m_49966_());
            }
        }
    }

    private static void lightningAttackBlock(Level world, BlockPos pos) {
        BlockState transformState;
        if (!(world.m_8055_(pos).m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(world.m_8055_(pos).m_60734_()) && (transformState = IafDragonDestructionManager.transformBlockLightning(world.m_8055_(pos))).m_60734_() != world.m_8055_(pos).m_60734_()) {
            world.m_46597_(pos, transformState);
        }
    }

    private static void destroyBlocks(Level world, BlockPos center, int x, int y, int z, double radius2) {
        BlockPos.m_121990_((BlockPos)center.m_142082_(-x, -y, -z), (BlockPos)center.m_142082_(x, y, z)).forEach(pos -> {
            if (center.m_123331_((Vec3i)pos) <= radius2 && (double)(world.f_46441_.nextFloat() * 3.0f) > (double)((float)center.m_123331_((Vec3i)pos)) / radius2 && !(world.m_8055_(pos).m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(world.m_8055_(pos).m_60734_())) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        });
    }

    public static BlockState transformBlockFire(BlockState in) {
        if (in.m_60734_() instanceof SpreadingSnowyDirtBlock) {
            return (BlockState)((Block)IafBlockRegistry.CHARRED_GRASS.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76314_ && in.m_60734_() == Blocks.f_50493_) {
            return (BlockState)((Block)IafBlockRegistry.CHARRED_DIRT.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76317_ && in.m_60734_() == Blocks.f_49994_) {
            return (BlockState)((Block)IafBlockRegistry.CHARRED_GRAVEL.get()).m_49966_().m_61124_((Property)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76278_ && (in.m_60734_() == Blocks.f_50652_ || in.m_60734_().m_7705_().contains("cobblestone"))) {
            return (BlockState)((Block)IafBlockRegistry.CHARRED_COBBLESTONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76278_ && in.m_60734_() != IafBlockRegistry.CHARRED_COBBLESTONE.get()) {
            return (BlockState)((Block)IafBlockRegistry.CHARRED_STONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60734_() == Blocks.f_152481_) {
            return (BlockState)((Block)IafBlockRegistry.CHARRED_DIRT_PATH.get()).m_49966_().m_61124_((Property)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76320_) {
            return ((Block)IafBlockRegistry.ASH.get()).m_49966_();
        }
        if (in.m_60767_() == Material.f_76274_ || in.m_60767_() == Material.f_76300_ || in.m_60734_() == Blocks.f_50125_) {
            return Blocks.f_50016_.m_49966_();
        }
        return in;
    }

    public static BlockState transformBlockIce(BlockState in) {
        if (in.m_60734_() instanceof SpreadingSnowyDirtBlock) {
            return (BlockState)((Block)IafBlockRegistry.FROZEN_GRASS.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76314_ && in.m_60734_() == Blocks.f_50493_ || in.m_60767_() == Material.f_76280_) {
            return (BlockState)((Block)IafBlockRegistry.FROZEN_DIRT.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76317_ && in.m_60734_() == Blocks.f_49994_) {
            return (BlockState)((Block)IafBlockRegistry.FROZEN_GRAVEL.get()).m_49966_().m_61124_((Property)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76317_ && in.m_60734_() != Blocks.f_49994_) {
            return in;
        }
        if (in.m_60767_() == Material.f_76278_ && (in.m_60734_() == Blocks.f_50652_ || in.m_60734_().m_7705_().contains("cobblestone"))) {
            return (BlockState)((Block)IafBlockRegistry.FROZEN_COBBLESTONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76278_ && in.m_60734_() != IafBlockRegistry.FROZEN_COBBLESTONE.get()) {
            return (BlockState)((Block)IafBlockRegistry.FROZEN_STONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60734_() == Blocks.f_152481_) {
            return (BlockState)((Block)IafBlockRegistry.FROZEN_DIRT_PATH.get()).m_49966_().m_61124_((Property)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76320_) {
            return ((Block)IafBlockRegistry.FROZEN_SPLINTERS.get()).m_49966_();
        }
        if (in.m_60767_() == Material.f_76305_) {
            return Blocks.f_50126_.m_49966_();
        }
        if (in.m_60767_() == Material.f_76274_ || in.m_60767_() == Material.f_76300_ || in.m_60734_() == Blocks.f_50125_) {
            return Blocks.f_50016_.m_49966_();
        }
        return in;
    }

    public static BlockState transformBlockLightning(BlockState in) {
        if (in.m_60734_() instanceof SpreadingSnowyDirtBlock) {
            return (BlockState)((Block)IafBlockRegistry.CRACKLED_GRASS.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76314_ && in.m_60734_() == Blocks.f_50493_) {
            return (BlockState)((Block)IafBlockRegistry.CRACKLED_DIRT.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76317_ && in.m_60734_() == Blocks.f_49994_) {
            return (BlockState)((Block)IafBlockRegistry.CRACKLED_GRAVEL.get()).m_49966_().m_61124_((Property)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76278_ && (in.m_60734_() == Blocks.f_50652_ || in.m_60734_().m_7705_().contains("cobblestone"))) {
            return (BlockState)((Block)IafBlockRegistry.CRACKLED_COBBLESTONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76278_ && in.m_60734_() != IafBlockRegistry.CRACKLED_COBBLESTONE.get()) {
            return (BlockState)((Block)IafBlockRegistry.CRACKLED_STONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60734_() == Blocks.f_152481_) {
            return (BlockState)((Block)IafBlockRegistry.CRACKLED_DIRT_PATH.get()).m_49966_().m_61124_((Property)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60767_() == Material.f_76320_) {
            return ((Block)IafBlockRegistry.ASH.get()).m_49966_();
        }
        if (in.m_60767_() == Material.f_76274_ || in.m_60767_() == Material.f_76300_ || in.m_60734_() == Blocks.f_50125_) {
            return Blocks.f_50016_.m_49966_();
        }
        return in;
    }

    private static /* synthetic */ void lambda$destroyAreaLightningCharge$17(EntityDragonBase destroyer, DamageSource source, float stageDmg, LivingEntity livingEntity) {
        if (!destroyer.m_7307_((Entity)livingEntity) && !destroyer.m_7306_((Entity)livingEntity) && destroyer.m_142582_((Entity)livingEntity)) {
            livingEntity.m_6469_(source, stageDmg);
            double d1 = destroyer.m_20185_() - livingEntity.m_20185_();
            double d0 = destroyer.m_20189_() - livingEntity.m_20189_();
            livingEntity.m_147240_((double)0.9f, d1, d0);
        }
    }

    private static /* synthetic */ void lambda$destroyAreaIceCharge$14(EntityDragonBase destroyer, DamageSource source, float stageDmg, LivingEntity livingEntity) {
        if (!destroyer.m_7307_((Entity)livingEntity) && !destroyer.m_7306_((Entity)livingEntity) && destroyer.m_142582_((Entity)livingEntity)) {
            livingEntity.m_6469_(source, stageDmg);
            FrozenProperties.setFrozenFor(livingEntity, 400);
        }
    }

    private static /* synthetic */ void lambda$destroyAreaFireCharge$11(EntityDragonBase destroyer, DamageSource source, float stageDmg, LivingEntity livingEntity) {
        if (!destroyer.m_7307_((Entity)livingEntity) && !destroyer.m_7306_((Entity)livingEntity) && destroyer.m_142582_((Entity)livingEntity)) {
            livingEntity.m_6469_(source, stageDmg);
            livingEntity.m_20254_(15);
        }
    }

    private static /* synthetic */ void lambda$destroyAreaLightning$8(EntityDragonBase destroyer, DamageSource source, float stageDmg, LivingEntity livingEntity) {
        if (!DragonUtils.onSameTeam((Entity)destroyer, (Entity)livingEntity) && !destroyer.m_7306_((Entity)livingEntity) && destroyer.m_142582_((Entity)livingEntity)) {
            livingEntity.m_6469_(source, stageDmg);
            double d1 = destroyer.m_20185_() - livingEntity.m_20185_();
            double d0 = destroyer.m_20189_() - livingEntity.m_20189_();
            livingEntity.m_147240_((double)0.3f, d1, d0);
        }
    }

    private static /* synthetic */ void lambda$destroyAreaIce$5(EntityDragonBase destroyer, DamageSource source, float stageDmg, int statusDuration, LivingEntity livingEntity) {
        if (!DragonUtils.onSameTeam((Entity)destroyer, (Entity)livingEntity) && !destroyer.m_7306_((Entity)livingEntity) && destroyer.m_142582_((Entity)livingEntity)) {
            livingEntity.m_6469_(source, stageDmg);
            FrozenProperties.setFrozenFor(livingEntity, statusDuration);
        }
    }

    private static /* synthetic */ void lambda$destroyAreaFire$2(EntityDragonBase destroyer, DamageSource source, float stageDmg, int statusDuration, LivingEntity livingEntity) {
        if (!DragonUtils.onSameTeam((Entity)destroyer, (Entity)livingEntity) && !destroyer.m_7306_((Entity)livingEntity) && destroyer.m_142582_((Entity)livingEntity)) {
            livingEntity.m_6469_(source, stageDmg);
            livingEntity.m_20254_(statusDuration);
        }
    }
}

