/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.item.ItemHippogryphEgg;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class HippogryphAIMate
extends Goal {
    private final EntityHippogryph hippo;
    Level world;
    int spawnBabyDelay;
    double moveSpeed;
    private EntityHippogryph targetMate;

    public HippogryphAIMate(EntityHippogryph animal, double speedIn) {
        this(animal, speedIn, animal.getClass());
    }

    public HippogryphAIMate(EntityHippogryph hippogryph, double speed, Class<? extends Animal> mate) {
        this.hippo = hippogryph;
        this.world = hippogryph.f_19853_;
        this.moveSpeed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.hippo.m_27593_() || this.hippo.m_21827_()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean m_8045_() {
        return this.targetMate.m_6084_() && this.targetMate.m_27593_() && this.spawnBabyDelay < 60;
    }

    public void m_8041_() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void m_8037_() {
        this.hippo.m_21563_().m_24960_((Entity)this.targetMate, 10.0f, (float)this.hippo.m_8132_());
        this.hippo.m_21573_().m_5624_((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.hippo.m_20280_((Entity)this.targetMate) < 9.0) {
            this.spawnBaby();
        }
    }

    private EntityHippogryph getNearbyMate() {
        List list = this.world.m_45976_(EntityHippogryph.class, this.hippo.m_142469_().m_82400_(8.0));
        double d0 = Double.MAX_VALUE;
        EntityHippogryph entityanimal = null;
        for (EntityHippogryph entityanimal1 : list) {
            if (!this.hippo.m_7848_((Animal)entityanimal1) || !(this.hippo.m_20280_((Entity)entityanimal1) < d0)) continue;
            entityanimal = entityanimal1;
            d0 = this.hippo.m_20280_((Entity)entityanimal1);
        }
        return entityanimal;
    }

    private void spawnBaby() {
        ItemEntity egg = new ItemEntity(this.world, this.hippo.m_20185_(), this.hippo.m_20186_(), this.hippo.m_20189_(), ItemHippogryphEgg.createEggStack(this.hippo.getEnumVariant(), this.targetMate.getEnumVariant()));
        this.hippo.m_146762_(6000);
        this.targetMate.m_146762_(6000);
        this.hippo.m_27594_();
        this.targetMate.m_27594_();
        egg.m_7678_(this.hippo.m_20185_(), this.hippo.m_20186_(), this.hippo.m_20189_(), 0.0f, 0.0f);
        if (!this.world.f_46443_) {
            this.world.m_7967_((Entity)egg);
        }
        Random random = this.hippo.m_21187_();
        for (int i = 0; i < 7; ++i) {
            double d0 = random.nextGaussian() * 0.02;
            double d1 = random.nextGaussian() * 0.02;
            double d2 = random.nextGaussian() * 0.02;
            double d3 = random.nextDouble() * (double)this.hippo.m_20205_() * 2.0 - (double)this.hippo.m_20205_();
            double d4 = 0.5 + random.nextDouble() * (double)this.hippo.m_20206_();
            double d5 = random.nextDouble() * (double)this.hippo.m_20205_() * 2.0 - (double)this.hippo.m_20205_();
            this.world.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.hippo.m_20185_() + d3, this.hippo.m_20186_() + d4, this.hippo.m_20189_() + d5, d0, d1, d2);
        }
        if (this.world.m_46469_().m_46207_(GameRules.f_46135_)) {
            this.world.m_7967_((Entity)new ExperienceOrb(this.world, this.hippo.m_20185_(), this.hippo.m_20186_(), this.hippo.m_20189_(), random.nextInt(7) + 1));
        }
    }
}

