/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PixieAISteal
extends Goal {
    private final EntityPixie temptedEntity;
    private Player temptingPlayer;
    private int delayTemptCounter = 0;
    private boolean isRunning;

    public PixieAISteal(EntityPixie temptedEntityIn, double speedIn) {
        this.temptedEntity = temptedEntityIn;
    }

    public boolean m_8036_() {
        if (!IafConfig.pixiesStealItems || !this.temptedEntity.m_21205_().m_41619_() || this.temptedEntity.stealCooldown > 0) {
            return false;
        }
        if (this.temptedEntity.m_21187_().nextInt(200) == 0) {
            return false;
        }
        if (this.temptedEntity.m_21824_()) {
            return false;
        }
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.f_19853_.m_45930_((Entity)this.temptedEntity, 10.0);
        return this.temptingPlayer != null && this.temptedEntity.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !this.temptingPlayer.m_150109_().m_7983_() && !this.temptingPlayer.m_7500_();
    }

    public boolean m_8045_() {
        return !this.temptedEntity.m_21824_() && this.temptedEntity.m_21205_().m_41619_() && this.delayTemptCounter == 0 && this.temptedEntity.stealCooldown == 0;
    }

    public void m_8056_() {
        this.isRunning = true;
    }

    public void m_8041_() {
        this.temptingPlayer = null;
        if (this.delayTemptCounter < 10) {
            this.delayTemptCounter += 10;
        }
        this.isRunning = false;
    }

    public void m_8037_() {
        this.temptedEntity.m_21563_().m_24960_((Entity)this.temptingPlayer, (float)(this.temptedEntity.m_8085_() + 20), (float)this.temptedEntity.m_8132_());
        ArrayList<Integer> slotlist = new ArrayList<Integer>();
        if (this.temptedEntity.m_20280_((Entity)this.temptingPlayer) < 3.0 && !this.temptingPlayer.m_150109_().m_7983_()) {
            for (int i = 0; i < this.temptingPlayer.m_150109_().m_6643_(); ++i) {
                ItemStack targetStack = this.temptingPlayer.m_150109_().m_8020_(i);
                if (Inventory.m_36045_((int)i) || targetStack.m_41619_() || !targetStack.m_41753_()) continue;
                slotlist.add(i);
            }
            if (!slotlist.isEmpty()) {
                int slot = slotlist.size() == 1 ? ((Integer)slotlist.get(0)).intValue() : ((Integer)slotlist.get(ThreadLocalRandom.current().nextInt(slotlist.size()))).intValue();
                ItemStack randomItem = this.temptingPlayer.m_150109_().m_8020_(slot);
                this.temptedEntity.m_21008_(InteractionHand.MAIN_HAND, randomItem);
                this.temptingPlayer.m_150109_().m_8016_(slot);
                this.temptedEntity.flipAI(true);
                this.temptedEntity.m_5496_(IafSoundRegistry.PIXIE_TAUNT, 1.0f, 1.0f);
                for (EntityPixie pixie : this.temptingPlayer.f_19853_.m_45976_(EntityPixie.class, this.temptedEntity.m_142469_().m_82400_(40.0))) {
                    pixie.stealCooldown = 1000 + pixie.m_21187_().nextInt(3000);
                }
                if (this.temptingPlayer != null) {
                    this.temptingPlayer.m_7292_(new MobEffectInstance(this.temptedEntity.negativePotions[this.temptedEntity.getColor()], 100));
                }
            } else {
                this.temptedEntity.flipAI(true);
                this.delayTemptCounter = 200;
            }
        } else {
            this.temptedEntity.m_21566_().m_6849_(this.temptingPlayer.m_20185_(), this.temptingPlayer.m_20186_() + 1.5, this.temptingPlayer.m_20189_(), 1.0);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

