/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class MiscProperties {
    private static final String MISC_DATA = "MiscDataIaf";
    private static final String DISMOUNTED_DRAGON = "HasDismounted";
    private static final String IN_LOVE_TIME = "TicksInLove";
    private static final String LUNGE_TICKS = "LungeTicks";
    private static final String PREV_LUNGE_TICKS = "PrevLungeTicks";
    private static final String TARGETED_BY_SCEPTER_HOLDERS = "ScepterHolders";
    private static final String TARGETING_ENTITIES_WITH_SCEPTER = "ScepterTargets";
    private static final String SCEPTER_ENTITY_ID = "ScepterEntityId";
    private static final Random rand = new Random();

    private static CompoundTag getOrCreateMiscData(LivingEntity entity) {
        return MiscProperties.getOrCreateMiscData(CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static CompoundTag getOrCreateMiscData(CompoundTag entityData) {
        if (entityData.m_128425_(MISC_DATA, 10)) {
            return (CompoundTag)entityData.m_128423_(MISC_DATA);
        }
        return MiscProperties.createDefaultData();
    }

    private static ListTag getOrCreateScepterTargetedBy(LivingEntity entity) {
        return MiscProperties.getOrCreateScepterTargetedBy(CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static ListTag getOrCreateScepterTargetedBy(CompoundTag entityData) {
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(entityData);
        if (miscData.m_128425_(TARGETED_BY_SCEPTER_HOLDERS, 9)) {
            return miscData.m_128437_(TARGETED_BY_SCEPTER_HOLDERS, 10);
        }
        return new ListTag();
    }

    private static ListTag getOrCreateScepterTargets(CompoundTag entityData) {
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(entityData);
        if (miscData.m_128425_(TARGETING_ENTITIES_WITH_SCEPTER, 9)) {
            return miscData.m_128437_(TARGETING_ENTITIES_WITH_SCEPTER, 10);
        }
        return new ListTag();
    }

    private static CompoundTag createDefaultData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(IN_LOVE_TIME, 0);
        nbt.m_128379_(DISMOUNTED_DRAGON, false);
        ListTag scepterHolders = new ListTag();
        nbt.m_128365_(TARGETED_BY_SCEPTER_HOLDERS, (Tag)scepterHolders);
        ListTag scepterTargets = new ListTag();
        nbt.m_128365_(TARGETING_ENTITIES_WITH_SCEPTER, (Tag)scepterTargets);
        return nbt;
    }

    public static boolean hasDismounted(LivingEntity entity) {
        CompoundTag nbt = MiscProperties.getOrCreateMiscData(entity);
        if (nbt.m_128441_(DISMOUNTED_DRAGON)) {
            return nbt.m_128471_(DISMOUNTED_DRAGON);
        }
        return false;
    }

    public static int getLoveTicks(LivingEntity entity) {
        CompoundTag nbt = MiscProperties.getOrCreateMiscData(entity);
        if (nbt.m_128441_(IN_LOVE_TIME)) {
            return nbt.m_128451_(IN_LOVE_TIME);
        }
        return 0;
    }

    public static int getLungeTicks(LivingEntity entity) {
        CompoundTag nbt = MiscProperties.getOrCreateMiscData(entity);
        if (nbt.m_128441_(LUNGE_TICKS)) {
            return nbt.m_128451_(LUNGE_TICKS);
        }
        return 0;
    }

    public static void setLoveTicks(LivingEntity entity, int duration) {
        CompoundTag entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(entityData);
        miscData.m_128405_(IN_LOVE_TIME, duration);
        entityData.m_128365_(MISC_DATA, (Tag)miscData);
        MiscProperties.updateData(entity, entityData);
    }

    public static void setDismountedDragon(LivingEntity entity, boolean bool) {
        CompoundTag entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(entityData);
        miscData.m_128379_(DISMOUNTED_DRAGON, bool);
        entityData.m_128365_(MISC_DATA, (Tag)miscData);
        MiscProperties.updateData(entity, entityData);
    }

    public static void setLungeTicks(LivingEntity entity, int ticks) {
        CompoundTag entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(entityData);
        miscData.m_128405_(LUNGE_TICKS, ticks);
        entityData.m_128365_(MISC_DATA, (Tag)miscData);
        MiscProperties.updateData(entity, entityData);
    }

    public static void addScepterTargetData(LivingEntity caster, LivingEntity target) {
        if (MiscProperties.isTargetedBy(caster, target) || MiscProperties.isTargeting(caster, target)) {
            return;
        }
        MiscProperties.addTargetedBy(caster, target);
        MiscProperties.addTargeting(caster, target);
    }

    public static void addTargetedBy(LivingEntity caster, LivingEntity target) {
        if (MiscProperties.isTargetedBy(caster, target)) {
            return;
        }
        CompoundTag targetData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)target);
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(targetData);
        ListTag scepterTargetData = MiscProperties.getOrCreateScepterTargetedBy(targetData);
        CompoundTag targetCasterData = new CompoundTag();
        targetCasterData.m_128405_(SCEPTER_ENTITY_ID, caster.m_142049_());
        scepterTargetData.add((Object)targetCasterData);
        miscData.m_128365_(TARGETED_BY_SCEPTER_HOLDERS, (Tag)scepterTargetData);
        targetData.m_128365_(MISC_DATA, (Tag)miscData);
        MiscProperties.updateData(target, targetData);
    }

    public static void addTargeting(LivingEntity caster, LivingEntity target) {
        if (MiscProperties.isTargeting(caster, target)) {
            return;
        }
        CompoundTag casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(casterData);
        ListTag scepterCasterData = MiscProperties.getOrCreateScepterTargets(casterData);
        CompoundTag casterTargetData = new CompoundTag();
        casterTargetData.m_128405_(SCEPTER_ENTITY_ID, target.m_142049_());
        scepterCasterData.add((Object)casterTargetData);
        miscData.m_128365_(TARGETING_ENTITIES_WITH_SCEPTER, (Tag)scepterCasterData);
        casterData.m_128365_(MISC_DATA, (Tag)miscData);
        MiscProperties.updateData(caster, casterData);
    }

    public static boolean isTargetedBy(LivingEntity caster, LivingEntity target) {
        CompoundTag targetData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)target);
        ListTag scepterData = MiscProperties.getOrCreateScepterTargetedBy(targetData);
        int entityId = caster.m_142049_();
        for (Tag scepterDatum : scepterData) {
            int targetedById;
            CompoundTag targetedBy = (CompoundTag)scepterDatum;
            if (!targetedBy.m_128441_(SCEPTER_ENTITY_ID) || entityId != (targetedById = targetedBy.m_128451_(SCEPTER_ENTITY_ID))) continue;
            return true;
        }
        return false;
    }

    public static boolean isTargeting(LivingEntity caster, LivingEntity target) {
        CompoundTag casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        ListTag scepterData = MiscProperties.getOrCreateScepterTargets(casterData);
        int entityId = target.m_142049_();
        for (Tag scepterDatum : scepterData) {
            int targetedById;
            CompoundTag targetedBy = (CompoundTag)scepterDatum;
            if (!targetedBy.m_128441_(SCEPTER_ENTITY_ID) || entityId != (targetedById = targetedBy.m_128451_(SCEPTER_ENTITY_ID))) continue;
            return true;
        }
        return false;
    }

    public static List<LivingEntity> getTargetedBy(LivingEntity target) {
        CompoundTag targetData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)target);
        ListTag scepterData = MiscProperties.getOrCreateScepterTargetedBy(targetData);
        ArrayList<LivingEntity> targetedByEntities = new ArrayList<LivingEntity>();
        for (Tag scepterDatum : scepterData) {
            int targetedById;
            Entity entity;
            CompoundTag targetedBy = (CompoundTag)scepterDatum;
            if (!targetedBy.m_128441_(SCEPTER_ENTITY_ID) || !((entity = target.f_19853_.m_6815_(targetedById = targetedBy.m_128451_(SCEPTER_ENTITY_ID))) instanceof LivingEntity)) continue;
            targetedByEntities.add((LivingEntity)entity);
        }
        return targetedByEntities;
    }

    public static List<LivingEntity> getTargeting(LivingEntity caster) {
        CompoundTag casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        ListTag scepterData = MiscProperties.getOrCreateScepterTargets(casterData);
        ArrayList<LivingEntity> targetingEntities = new ArrayList<LivingEntity>();
        for (Tag scepterDatum : scepterData) {
            int targetedById;
            Entity entity;
            CompoundTag targetedBy = (CompoundTag)scepterDatum;
            if (!targetedBy.m_128441_(SCEPTER_ENTITY_ID) || !((entity = caster.f_19853_.m_6815_(targetedById = targetedBy.m_128451_(SCEPTER_ENTITY_ID))) instanceof LivingEntity)) continue;
            targetingEntities.add((LivingEntity)entity);
        }
        return targetingEntities;
    }

    public static void removeTargetedBy(LivingEntity caster, LivingEntity target) {
        CompoundTag targetData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)target);
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(targetData);
        ListTag scepterData = MiscProperties.getOrCreateScepterTargetedBy(targetData);
        ListTag updatedScepterData = new ListTag();
        int entityId = caster.m_142049_();
        for (Tag scepterDatum : scepterData) {
            int targetedById;
            CompoundTag targetedBy = (CompoundTag)scepterDatum;
            if (!targetedBy.m_128441_(SCEPTER_ENTITY_ID) || entityId == (targetedById = targetedBy.m_128451_(SCEPTER_ENTITY_ID))) continue;
            updatedScepterData.add((Object)targetedBy);
        }
        miscData.m_128365_(TARGETED_BY_SCEPTER_HOLDERS, (Tag)updatedScepterData);
        targetData.m_128365_(MISC_DATA, (Tag)miscData);
        MiscProperties.updateData(target, targetData);
    }

    public static void removeTargets(LivingEntity caster) {
        CompoundTag casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(casterData);
        miscData.m_128365_(TARGETED_BY_SCEPTER_HOLDERS, (Tag)new ListTag());
        casterData.m_128365_(MISC_DATA, (Tag)miscData);
        MiscProperties.updateData(caster, casterData);
    }

    public static void removeTarget(LivingEntity caster, LivingEntity target) {
        CompoundTag casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        CompoundTag miscData = MiscProperties.getOrCreateMiscData(casterData);
        ListTag scepterData = MiscProperties.getOrCreateScepterTargets(casterData);
        ListTag updatedScepterData = new ListTag();
        int entityId = target.m_142049_();
        for (Tag scepterDatum : scepterData) {
            int targetedById;
            CompoundTag targetedBy = (CompoundTag)scepterDatum;
            if (!targetedBy.m_128441_(SCEPTER_ENTITY_ID) || (targetedById = targetedBy.m_128451_(SCEPTER_ENTITY_ID)) == entityId) continue;
            updatedScepterData.add((Object)targetedBy);
        }
        miscData.m_128365_(TARGETING_ENTITIES_WITH_SCEPTER, (Tag)updatedScepterData);
        casterData.m_128365_(MISC_DATA, (Tag)miscData);
        MiscProperties.updateData(caster, casterData);
    }

    public static void updateData(LivingEntity entity) {
        MiscProperties.updateData(entity, CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static void updateData(LivingEntity entity, CompoundTag nbt) {
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundTag)nbt);
        if (!entity.f_19853_.m_5776_()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", nbt, entity.m_142049_()));
        }
    }

    private static void createLoveParticles(LivingEntity entity) {
        if (rand.nextInt(7) == 0) {
            for (int i = 0; i < 5; ++i) {
                entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, entity.m_20185_() + (rand.nextDouble() - 0.5) * 3.0, entity.m_20186_() + (rand.nextDouble() - 0.5) * 3.0, entity.m_20189_() + (rand.nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void tickLove(LivingEntity entity) {
        MiscProperties.setLoveTicks(entity, MiscProperties.getLoveTicks(entity) - 1);
        if (entity instanceof Mob) {
            ((Mob)entity).m_6710_(null);
        }
        MiscProperties.createLoveParticles(entity);
    }
}

