/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class DragonUtils {
    private static final Map<Block, Boolean> BLOCK_CACHE = new HashMap<Block, Boolean>();

    public static BlockPos getBlockInViewEscort(EntityDragonBase dragon) {
        BlockPos escortPos = dragon.getEscortPosition();
        BlockPos ground = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, escortPos);
        int distFromGround = escortPos.m_123342_() - ground.m_123342_();
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = new BlockPos(escortPos.m_123341_() + dragon.m_21187_().nextInt(IafConfig.dragonWanderFromHomeDistance) - IafConfig.dragonWanderFromHomeDistance / 2, distFromGround > 16 ? escortPos.m_123342_() : escortPos.m_123342_() + 8 + dragon.m_21187_().nextInt(16), escortPos.m_123343_() + dragon.m_21187_().nextInt(IafConfig.dragonWanderFromHomeDistance) - IafConfig.dragonWanderFromHomeDistance / 2);
            if (!(dragon.getDistanceSquared(Vec3.m_82512_((Vec3i)pos)) > 6.0f) || dragon.isTargetBlocked(Vec3.m_82512_((Vec3i)pos))) continue;
            return pos;
        }
        return null;
    }

    public static BlockPos getWaterBlockInViewEscort(EntityDragonBase dragon) {
        BlockPos inWaterEscortPos = dragon.getEscortPosition();
        if (Math.abs(dragon.m_20185_() - (double)inWaterEscortPos.m_123341_()) < dragon.m_142469_().m_82362_() && Math.abs(dragon.m_20189_() - (double)inWaterEscortPos.m_123343_()) < dragon.m_142469_().m_82385_()) {
            return dragon.m_142538_();
        }
        if ((double)inWaterEscortPos.m_123342_() - dragon.m_20186_() > (double)(8 + dragon.getYNavSize()) && !dragon.f_19853_.m_6425_(inWaterEscortPos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            dragon.setHovering(true);
        }
        return inWaterEscortPos;
    }

    public static BlockPos getBlockInView(EntityDragonBase dragon) {
        BlockPos pos;
        float radius = 12.0f * (0.7f * dragon.getRenderSize() / 3.0f);
        float neg = dragon.m_21187_().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = dragon.f_20883_;
        if (dragon.hasHomePosition && dragon.homePos != null) {
            BlockPos dragonPos = dragon.m_142538_();
            BlockPos ground = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dragonPos);
            int distFromGround = (int)dragon.m_20186_() - ground.m_123342_();
            for (int i = 0; i < 10; ++i) {
                BlockPos homePos = dragon.homePos.getPosition();
                BlockPos pos2 = new BlockPos(homePos.m_123341_() + dragon.m_21187_().nextInt(IafConfig.dragonWanderFromHomeDistance * 2) - IafConfig.dragonWanderFromHomeDistance, distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, dragon.m_20186_() + (double)dragon.m_21187_().nextInt(16) - 8.0) : (int)dragon.m_20186_() + dragon.m_21187_().nextInt(16) + 1, homePos.m_123343_() + dragon.m_21187_().nextInt(IafConfig.dragonWanderFromHomeDistance * 2) - IafConfig.dragonWanderFromHomeDistance);
                if (!(dragon.getDistanceSquared(Vec3.m_82512_((Vec3i)pos2)) > 6.0f) || dragon.isTargetBlocked(Vec3.m_82512_((Vec3i)pos2))) continue;
                return pos2;
            }
        }
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + dragon.m_21187_().nextFloat() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos(dragon.m_20185_() + extraX, 0.0, dragon.m_20189_() + extraZ);
        BlockPos ground = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)dragon.m_20186_() - ground.m_123342_();
        BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, dragon.m_20186_() + (double)dragon.m_21187_().nextInt(16) - 8.0) : (int)dragon.m_20186_() + dragon.m_21187_().nextInt(16) + 1);
        BlockPos blockPos = pos = dragon.doesWantToLand() ? ground : newPos;
        if (dragon.getDistanceSquared(Vec3.m_82512_((Vec3i)newPos)) > 6.0f && !dragon.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos))) {
            return pos;
        }
        return null;
    }

    public static BlockPos getWaterBlockInView(EntityDragonBase dragon) {
        BlockPos surface;
        float radius = 0.75f * (0.7f * dragon.getRenderSize() / 3.0f) * -7.0f - (float)dragon.m_21187_().nextInt(dragon.getDragonStage() * 6);
        float neg = dragon.m_21187_().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * dragon.f_20883_ + 3.15f + dragon.m_21187_().nextFloat() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos(dragon.m_20185_() + extraX, 0.0, dragon.m_20189_() + extraZ);
        BlockPos ground = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)dragon.m_20186_() - ground.m_123342_();
        BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, dragon.m_20186_() + (double)dragon.m_21187_().nextInt(16) - 8.0) : (int)dragon.m_20186_() + dragon.m_21187_().nextInt(16) + 1);
        BlockPos pos = dragon.doesWantToLand() ? ground : newPos;
        BlockPos blockPos = surface = dragon.f_19853_.m_6425_(newPos.m_6625_(2)).m_205070_(FluidTags.f_13131_) ? newPos.m_6625_(dragon.m_21187_().nextInt(10) + 1) : newPos;
        if (dragon.getDistanceSquared(Vec3.m_82512_((Vec3i)surface)) > 6.0f && dragon.f_19853_.m_6425_(surface).m_205070_(FluidTags.f_13131_)) {
            return surface;
        }
        return null;
    }

    public static LivingEntity riderLookingAtEntity(final LivingEntity dragon, LivingEntity rider, double dist) {
        Vec3 Vector3d = rider.m_20299_(1.0f);
        Vec3 Vector3d1 = rider.m_20252_(1.0f);
        Vec3 Vector3d2 = Vector3d.m_82520_(Vector3d1.f_82479_ * dist, Vector3d1.f_82480_ * dist, Vector3d1.f_82481_ * dist);
        double d1 = dist;
        Entity pointedEntity = null;
        List list = rider.f_19853_.m_6249_((Entity)rider, rider.m_142469_().m_82363_(Vector3d1.f_82479_ * dist, Vector3d1.f_82480_ * dist, Vector3d1.f_82481_ * dist).m_82377_(1.0, 1.0, 1.0), (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (DragonUtils.onSameTeam((Entity)dragon, entity)) {
                    return false;
                }
                return entity != null && entity.m_6087_() && entity instanceof LivingEntity && !entity.m_7306_((Entity)dragon) && !entity.m_7307_((Entity)dragon) && (!(entity instanceof IDeadMob) || !((IDeadMob)entity).isMobDead());
            }
        });
        double d2 = d1;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AABB axisalignedbb = entity1.m_142469_().m_82400_((double)entity1.m_6143_() + 2.0);
            Vec3 raytraceresult = axisalignedbb.m_82371_(Vector3d, Vector3d2).orElse(Vec3.f_82478_);
            if (axisalignedbb.m_82390_(Vector3d)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = Vector3d.m_82554_(raytraceresult)) < d2) && d2 != 0.0) continue;
            if (entity1.m_20201_() == rider.m_20201_() && !rider.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                continue;
            }
            pointedEntity = entity1;
            d2 = d3;
        }
        return (LivingEntity)pointedEntity;
    }

    public static BlockPos getBlockInViewHippogryph(EntityHippogryph hippo, float yawAddition) {
        BlockPos pos;
        int distFromGround;
        BlockPos ground;
        float radius = -12.599999f - (float)hippo.m_21187_().nextInt(48);
        float neg = hippo.m_21187_().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * (hippo.f_20883_ + yawAddition) + 3.15f + hippo.m_21187_().nextFloat() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        if (hippo.hasHomePosition && hippo.homePos != null) {
            BlockPos dragonPos = hippo.m_142538_();
            ground = hippo.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dragonPos);
            distFromGround = (int)hippo.m_20186_() - ground.m_123342_();
            for (int i = 0; i < 10; ++i) {
                pos = new BlockPos(hippo.homePos.m_123341_() + hippo.m_21187_().nextInt(IafConfig.dragonWanderFromHomeDistance) - IafConfig.dragonWanderFromHomeDistance, distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, hippo.m_20186_() + (double)hippo.m_21187_().nextInt(16) - 8.0) : (int)hippo.m_20186_() + hippo.m_21187_().nextInt(16) + 1, hippo.homePos.m_123343_() + hippo.m_21187_().nextInt(IafConfig.dragonWanderFromHomeDistance * 2) - IafConfig.dragonWanderFromHomeDistance);
                if (!(hippo.getDistanceSquared(Vec3.m_82512_((Vec3i)pos)) > 6.0f) || hippo.isTargetBlocked(Vec3.m_82512_((Vec3i)pos))) continue;
                return pos;
            }
        }
        BlockPos radialPos = new BlockPos(hippo.m_20185_() + extraX, 0.0, hippo.m_20189_() + extraZ);
        ground = hippo.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        distFromGround = (int)hippo.m_20186_() - ground.m_123342_();
        BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, hippo.m_20186_() + (double)hippo.m_21187_().nextInt(16) - 8.0) : (int)hippo.m_20186_() + hippo.m_21187_().nextInt(16) + 1);
        BlockPos blockPos = pos = hippo.doesWantToLand() ? ground : newPos;
        if (!hippo.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos)) && hippo.getDistanceSquared(Vec3.m_82512_((Vec3i)newPos)) > 6.0f) {
            return newPos;
        }
        return null;
    }

    public static BlockPos getBlockInViewStymphalian(EntityStymphalianBird bird) {
        BlockPos pos;
        float radius = -9.45f - (float)bird.m_21187_().nextInt(24);
        float neg = bird.m_21187_().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = bird.flock != null && !bird.flock.isLeader(bird) ? DragonUtils.getStymphalianFlockDirection(bird) : bird.f_20883_;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + bird.m_21187_().nextFloat() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = DragonUtils.getStymphalianFearPos(bird, new BlockPos(bird.m_20185_() + extraX, 0.0, bird.m_20189_() + extraZ));
        BlockPos ground = bird.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)bird.m_20186_() - ground.m_123342_();
        int flightHeight = Math.min(IafConfig.stymphalianBirdFlightHeight, ground.m_123342_() + bird.m_21187_().nextInt(16));
        BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? flightHeight : (int)bird.m_20186_() + bird.m_21187_().nextInt(16) + 1);
        BlockPos blockPos = pos = bird.doesWantToLand() ? ground : newPos;
        if (bird.getDistanceSquared(Vec3.m_82512_((Vec3i)newPos)) > 6.0f && !bird.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos))) {
            return newPos;
        }
        return null;
    }

    private static BlockPos getStymphalianFearPos(EntityStymphalianBird bird, BlockPos fallback) {
        Vec3 Vector3d;
        if (bird.getVictor() != null && bird.getVictor() instanceof PathfinderMob && (Vector3d = DefaultRandomPos.m_148407_((PathfinderMob)((PathfinderMob)bird.getVictor()), (int)16, (int)IafConfig.stymphalianBirdFlightHeight, (Vec3)new Vec3(bird.getVictor().m_20185_(), bird.getVictor().m_20186_(), bird.getVictor().m_20189_()))) != null) {
            BlockPos pos = new BlockPos(Vector3d);
            return new BlockPos(pos.m_123341_(), 0, pos.m_123343_());
        }
        return fallback;
    }

    private static float getStymphalianFlockDirection(EntityStymphalianBird bird) {
        EntityStymphalianBird leader = bird.flock.getLeader();
        if (bird.m_20280_((Entity)leader) > 2.0) {
            double d0 = leader.m_20185_() - bird.m_20185_();
            double d2 = leader.m_20189_() - bird.m_20189_();
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float degrees = Mth.m_14177_((float)(f - bird.m_146908_()));
            return bird.m_146908_() + degrees;
        }
        return leader.f_20883_;
    }

    public static BlockPos getBlockInTargetsViewCockatrice(EntityCockatrice cockatrice, LivingEntity target) {
        float radius = 10 + cockatrice.m_21187_().nextInt(10);
        float angle = (float)Math.PI / 180 * target.f_20885_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos(target.m_20185_() + extraX, 0.0, target.m_20189_() + extraZ);
        BlockPos ground = target.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (cockatrice.m_20238_(Vec3.m_82512_((Vec3i)ground)) > 30.0 && !cockatrice.isTargetBlocked(Vec3.m_82512_((Vec3i)ground))) {
            return ground;
        }
        return target.m_142538_();
    }

    public static BlockPos getBlockInTargetsViewGhost(EntityGhost ghost, LivingEntity target) {
        float radius = 4 + ghost.m_21187_().nextInt(5);
        float angle = (float)Math.PI / 180 * (target.f_20885_ + 90.0f + (float)ghost.m_21187_().nextInt(180));
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos(target.m_20185_() + extraX, target.m_20186_(), target.m_20189_() + extraZ);
        BlockPos ground = radialPos;
        if (ghost.m_20238_(Vec3.m_82512_((Vec3i)ground)) > 30.0) {
            return ground;
        }
        return ghost.m_142538_();
    }

    public static BlockPos getBlockInTargetsViewGorgon(EntityGorgon cockatrice, LivingEntity target) {
        float radius = 6.0f;
        float angle = (float)Math.PI / 180 * target.f_20885_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos(target.m_20185_() + extraX, target.m_20186_(), target.m_20189_() + extraZ);
        if (cockatrice.m_20238_(Vec3.m_82512_((Vec3i)radialPos)) < 300.0 && !cockatrice.isTargetBlocked(Vec3.m_82512_((Vec3i)radialPos).m_82520_(0.0, 0.75, 0.0))) {
            return radialPos;
        }
        return target.m_142538_();
    }

    public static BlockPos getBlockInTargetsViewSeaSerpent(EntitySeaSerpent serpent, LivingEntity target) {
        float radius = 10.0f * serpent.getSeaSerpentScale() + (float)serpent.m_21187_().nextInt(10);
        float angle = (float)Math.PI / 180 * target.f_20885_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos(target.m_20185_() + extraX, 0.0, target.m_20189_() + extraZ);
        BlockPos ground = target.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (serpent.m_20238_(Vec3.m_82512_((Vec3i)ground)) > 30.0) {
            return ground;
        }
        return target.m_142538_();
    }

    public static boolean canTameDragonAttack(TamableAnimal dragon, Entity entity) {
        if (entity.m_6095_().m_204039_(Objects.requireNonNull(ForgeRegistries.ENTITIES.tags()).createTagKey(IafTagRegistry.VILLAGERS))) {
            return false;
        }
        if (entity instanceof AbstractVillager || entity instanceof AbstractGolem || entity instanceof Player) {
            return false;
        }
        if (entity instanceof TamableAnimal) {
            return !((TamableAnimal)entity).m_21824_();
        }
        return true;
    }

    public static boolean isVillager(Entity entity) {
        return entity.m_6095_().m_204039_(ForgeRegistries.ENTITIES.tags().createTagKey(IafTagRegistry.VILLAGERS));
    }

    public static boolean isAnimaniaMob(Entity entity) {
        return false;
    }

    public static boolean isDragonTargetable(Entity entity, ResourceLocation tag) {
        return entity.m_6095_().m_204039_(ForgeRegistries.ENTITIES.tags().createTagKey(tag));
    }

    public static String getDimensionName(Level world) {
        return world.m_46472_().m_135782_().toString();
    }

    public static boolean isInHomeDimension(EntityDragonBase dragonBase) {
        return dragonBase.getHomeDimensionName() == null || DragonUtils.getDimensionName(dragonBase.f_19853_).equals(dragonBase.getHomeDimensionName());
    }

    public static boolean canDragonBreak(Block block) {
        if (BLOCK_CACHE.containsKey(block)) {
            return BLOCK_CACHE.get(block);
        }
        boolean value = block != Blocks.f_50375_ && block != Blocks.f_50080_ && block != Blocks.f_50723_ && block != Blocks.f_50259_ && block != Blocks.f_50752_ && block != Blocks.f_50257_ && block != Blocks.f_50258_ && block != Blocks.f_50272_ && block != Blocks.f_50447_ && block != Blocks.f_50448_ && block != Blocks.f_50183_ && block != Blocks.f_50446_ && !DragonUtils.isBlacklistedBlock(block);
        BLOCK_CACHE.put(block, value);
        return value;
    }

    public static boolean hasSameOwner(TamableAnimal cockatrice, Entity entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)entity;
            return tameable.m_142504_() != null && cockatrice.m_142504_() != null && tameable.m_142504_().equals(cockatrice.m_142504_());
        }
        return false;
    }

    public static boolean isAlive(LivingEntity entity) {
        if (entity instanceof EntityDragonBase && ((EntityDragonBase)entity).isMobDead()) {
            return false;
        }
        return (!(entity instanceof IDeadMob) || !((IDeadMob)entity).isMobDead()) && !EntityGorgon.isStoneMob(entity);
    }

    public static boolean canGrief(boolean weak) {
        if (weak) {
            return IafConfig.dragonGriefing == 0;
        }
        return IafConfig.dragonGriefing < 2;
    }

    public static boolean isBlacklistedBlock(Block block) {
        if (IafConfig.blacklistBreakBlocksIsWhiteList) {
            for (String string : IafConfig.blacklistedBreakBlocks) {
                if (!string.equalsIgnoreCase(block.getRegistryName().toString())) continue;
                return false;
            }
            return true;
        }
        for (String string : IafConfig.blacklistedBreakBlocks) {
            if (!string.equalsIgnoreCase(block.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean canHostilesTarget(Entity entity) {
        if (entity instanceof Player && (entity.f_19853_.m_46791_() == Difficulty.PEACEFUL || ((Player)entity).m_7500_())) {
            return false;
        }
        if (entity instanceof EntityDragonBase && ((EntityDragonBase)entity).isMobDead()) {
            return false;
        }
        return entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity);
    }

    public static boolean onSameTeam(Entity entity1, Entity entity2) {
        Entity multipart;
        LivingEntity owner1 = null;
        LivingEntity owner2 = null;
        boolean def = entity1.m_7307_(entity2);
        if (entity1 instanceof TamableAnimal) {
            owner1 = ((TamableAnimal)entity1).m_142480_();
        }
        if (entity2 instanceof TamableAnimal) {
            owner2 = ((TamableAnimal)entity2).m_142480_();
        }
        if (entity1 instanceof EntityMutlipartPart && (multipart = ((EntityMutlipartPart)entity1).getParent()) != null && multipart instanceof TamableAnimal) {
            owner1 = ((TamableAnimal)multipart).m_142480_();
        }
        if (entity2 instanceof EntityMutlipartPart && (multipart = ((EntityMutlipartPart)entity2).getParent()) != null && multipart instanceof TamableAnimal) {
            owner2 = ((TamableAnimal)multipart).m_142480_();
        }
        if (owner1 != null && owner2 != null) {
            return owner1.m_7306_((Entity)owner2);
        }
        return def;
    }

    public static boolean canDropFromDragonBlockBreak(BlockState state) {
        for (String string : IafConfig.noDropBreakBlocks) {
            if (!string.equalsIgnoreCase(state.m_60734_().getRegistryName().toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean isDreadBlock(BlockState state) {
        Block block = state.m_60734_();
        return block == IafBlockRegistry.DREAD_STONE.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_CHISELED.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_CRACKED.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_MOSSY.get() || block == IafBlockRegistry.DREAD_STONE_TILE.get() || block == IafBlockRegistry.DREAD_STONE_FACE.get() || block == IafBlockRegistry.DREAD_TORCH.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_STAIRS.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_SLAB.get() || block == IafBlockRegistry.DREADWOOD_LOG.get() || block == IafBlockRegistry.DREADWOOD_PLANKS.get() || block == IafBlockRegistry.DREADWOOD_PLANKS_LOCK.get() || block == IafBlockRegistry.DREAD_PORTAL.get() || block == IafBlockRegistry.DREAD_SPAWNER.get();
    }
}

