/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class MyrmexTrades {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> DESERT_WORKER = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new DesertResinForItemsTrade((ItemLike)Items.f_42329_, 64, 1, 5), new DesertResinForItemsTrade((ItemLike)Items.f_41830_, 64, 1, 5), new ItemsForDesertResinTrade(Items.f_41866_, 2, 8, 5, 2), new DesertResinForItemsTrade((ItemLike)Items.f_42500_, 10, 1, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForDesertResinTrade(Items.f_41834_, 1, 6, 3, 2), new DesertResinForItemsTrade((ItemLike)Items.f_42501_, 15, 2, 1), new ItemsForDesertResinTrade(Items.f_42398_, 1, 64, 5, 2), new ItemsForDesertResinTrade((Item)IafItemRegistry.COPPER_NUGGET.get(), 1, 4, 10)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> JUNGLE_WORKER = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new JungleResinForItemsTrade((ItemLike)Items.f_42329_, 64, 1, 5), new ItemsForJungleResinTrade(Items.f_42575_, 1, 20, 3, 1), new ItemsForJungleResinTrade(Items.f_41899_, 1, 64, 5, 1), new JungleResinForItemsTrade((ItemLike)Items.f_42500_, 10, 1, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForJungleResinTrade(Items.f_41833_, 2, 15, 3, 2), new JungleResinForItemsTrade((ItemLike)Items.f_42501_, 15, 2, 3), new ItemsForJungleResinTrade(Items.f_42398_, 1, 64, 5, 2), new ItemsForJungleResinTrade((Item)IafItemRegistry.COPPER_NUGGET.get(), 1, 4, 10)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> DESERT_SOLDIER = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new DesertResinForItemsTrade((ItemLike)Items.f_42500_, 7, 1, 3), new DesertResinForItemsTrade((ItemLike)Items.f_42402_, 16, 3, 3), new DesertResinForItemsTrade((ItemLike)Items.f_42403_, 5, 1, 4), new ItemsForDesertResinTrade(Items.f_42697_, 1, 3, 6, 2), new DesertResinForItemsTrade((ItemLike)Items.f_42749_, 4, 1, 4), new ItemsForDesertResinTrade(Items.f_42581_, 2, 2, 7), new ItemsForDesertResinTrade((Item)IafItemRegistry.SILVER_NUGGET.get(), 4, 1, 15)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForDesertResinTrade(Items.f_41982_, 1, 15, 6, 2), new ItemsForDesertResinTrade(Items.f_42587_, 1, 4, 6, 2), new ItemsForDesertResinTrade((Item)IafItemRegistry.TROLL_TUSK.get(), 6, 1, 4, 2), new DesertResinForItemsTrade((ItemLike)IafItemRegistry.DRAGON_BONE.get(), 6, 2, 3)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> JUNGLE_SOLDIER = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new JungleResinForItemsTrade((ItemLike)Items.f_42500_, 7, 1, 3), new JungleResinForItemsTrade((ItemLike)Items.f_42402_, 16, 3, 3), new JungleResinForItemsTrade((ItemLike)Items.f_42403_, 5, 1, 4), new ItemsForJungleResinTrade(Items.f_42521_, 1, 4, 6, 2), new JungleResinForItemsTrade((ItemLike)Items.f_42749_, 4, 1, 4), new ItemsForJungleResinTrade(Items.f_42581_, 2, 2, 7), new ItemsForJungleResinTrade((Item)IafItemRegistry.SILVER_NUGGET.get(), 1, 4, 15)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForJungleResinTrade(Items.f_42583_, 1, 15, 6, 2), new ItemsForJungleResinTrade(Items.f_42587_, 1, 4, 6, 2), new ItemsForJungleResinTrade((Item)IafItemRegistry.TROLL_TUSK.get(), 6, 1, 4, 2), new JungleResinForItemsTrade((ItemLike)IafItemRegistry.DRAGON_BONE.get(), 6, 2, 3)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> DESERT_SENTINEL = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new DesertResinForItemsTrade((ItemLike)Items.f_42591_, 10, 2, 3), new DesertResinForItemsTrade((ItemLike)Items.f_42675_, 2, 1, 2), new DesertResinForItemsTrade((ItemLike)Items.f_42529_, 4, 2, 4)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForDesertResinTrade(Items.f_42451_, 2, 5, 5, 1), new ItemsForDesertResinTrade(Items.f_42485_, 2, 3, 4), new ItemsForDesertResinTrade(Items.f_42579_, 2, 3, 4), new ItemsForDesertResinTrade(Items.f_42658_, 2, 3, 4), new ItemsForDesertResinTrade(Items.f_42678_, 15, 1, 2, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> JUNGLE_SENTINEL = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new JungleResinForItemsTrade((ItemLike)Items.f_42591_, 10, 2, 3), new JungleResinForItemsTrade((ItemLike)Items.f_42675_, 2, 1, 2), new JungleResinForItemsTrade((ItemLike)Items.f_42529_, 4, 2, 4)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForJungleResinTrade(Items.f_42451_, 2, 5, 5, 1), new ItemsForJungleResinTrade(Items.f_42485_, 2, 3, 4), new ItemsForJungleResinTrade(Items.f_42579_, 2, 3, 4), new ItemsForJungleResinTrade(Items.f_42658_, 2, 3, 4), new ItemsForJungleResinTrade(Items.f_42678_, 15, 1, 2, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> DESERT_ROYAL = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsForDesertResinTrade((Item)IafItemRegistry.MANUSCRIPT.get(), 1, 3, 5, 1), new ItemsForDesertResinTrade((Item)IafItemRegistry.WITHER_SHARD.get(), 3, 1, 3, 1), new ItemsForDesertResinTrade(Items.f_42616_, 10, 1, 3, 1), new ItemsForDesertResinTrade(Items.f_42692_, 2, 4, 3, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForDesertResinTrade(Items.f_42677_, 3, 1, 2, 1), new ItemsForDesertResinTrade(Items.f_42542_, 5, 1, 3, 1), new ItemsForDesertResinTrade(Items.f_42417_, 3, 1, 5, 1), new ItemsForDesertResinTrade((Item)IafItemRegistry.SILVER_INGOT.get(), 3, 1, 5, 1), new ItemsForDesertResinTrade((Item)IafItemRegistry.COPPER_INGOT.get(), 2, 2, 3, 1), new ItemsForDesertResinTrade(Items.f_42584_, 8, 1, 5, 1), new ItemsForDesertResinTrade(Items.f_42648_, 3, 1, 5, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> JUNGLE_ROYAL = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsForJungleResinTrade((Item)IafItemRegistry.MANUSCRIPT.get(), 1, 3, 5, 1), new ItemsForJungleResinTrade((Item)IafItemRegistry.WITHER_SHARD.get(), 3, 1, 3, 1), new ItemsForJungleResinTrade(Items.f_42616_, 10, 1, 3, 1), new ItemsForJungleResinTrade(Items.f_42692_, 2, 4, 3, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForJungleResinTrade(Items.f_42677_, 3, 1, 2, 1), new ItemsForJungleResinTrade(Items.f_42542_, 5, 1, 3, 1), new ItemsForJungleResinTrade(Items.f_42417_, 3, 1, 5, 1), new ItemsForJungleResinTrade((Item)IafItemRegistry.SILVER_INGOT.get(), 3, 1, 5, 1), new ItemsForJungleResinTrade((Item)IafItemRegistry.COPPER_INGOT.get(), 2, 2, 3, 1), new ItemsForJungleResinTrade(Items.f_42584_, 8, 1, 5, 1), new ItemsForJungleResinTrade(Items.f_42648_, 3, 1, 5, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> DESERT_QUEEN = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 0), 10, 1, 10, 1), new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 1), 20, 1, 8, 1), new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 2), 30, 1, 5, 1), new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 3), 40, 1, 3, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 4), 60, 1, 2, 1), new ItemsForDesertResinTrade(Items.f_42616_, 15, 1, 9, 1), new ItemsForDesertResinTrade(Items.f_42415_, 25, 1, 9, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> JUNGLE_QUEEN = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 0), 10, 1, 10, 1), new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 1), 20, 1, 8, 1), new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 2), 30, 1, 5, 1), new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 3), 40, 1, 3, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 4), 60, 1, 2, 1), new ItemsForDesertResinTrade(Items.f_42616_, 15, 1, 9, 1), new ItemsForDesertResinTrade(Items.f_42415_, 25, 1, 9, 1)}));

    private static ItemStack createEgg(boolean jungle, int caste) {
        ItemStack egg = new ItemStack(jungle ? (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_EGG.get() : (ItemLike)IafItemRegistry.MYRMEX_DESERT_EGG.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("EggOrdinal", caste);
        egg.m_41751_(tag);
        return egg;
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> createTrades(ImmutableMap<Integer, VillagerTrades.ItemListing[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    static class DesertResinForItemsTrade
    implements VillagerTrades.ItemListing {
        private final Item tradeItem;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public DesertResinForItemsTrade(ItemLike tradeItemIn, int countIn, int maxUsesIn, int xpValueIn) {
            this.tradeItem = tradeItemIn.m_5456_();
            this.count = countIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_5670_(@NotNull Entity trader, @NotNull Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((ItemLike)this.tradeItem, this.count);
            return new MerchantOffer(lvt_3_1_, new ItemStack((ItemLike)IafItemRegistry.MYRMEX_DESERT_RESIN.get()), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForDesertResinTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack stack;
        private final int emeraldCount;
        private final int itemCount;
        private final int maxUses;
        private final int exp;
        private final float multiplier;

        public ItemsForDesertResinTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForDesertResinTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public ItemsForDesertResinTrade(Item item, int DesertResin, int items, int maxUses, int exp) {
            this(new ItemStack((ItemLike)item), DesertResin, items, maxUses, exp);
        }

        public ItemsForDesertResinTrade(ItemStack stack, int DesertResin, int items, int maxUses, int exp) {
            this(stack, DesertResin, items, maxUses, exp, 0.05f);
        }

        public ItemsForDesertResinTrade(ItemStack stack, int DesertResin, int items, int maxUses, int exp, float multi) {
            this.stack = stack;
            this.emeraldCount = DesertResin;
            this.itemCount = items;
            this.maxUses = maxUses;
            this.exp = exp;
            this.multiplier = multi;
        }

        public MerchantOffer m_5670_(@NotNull Entity trader, @NotNull Random rand) {
            ItemStack cloneStack = new ItemStack((ItemLike)this.stack.m_41720_(), this.itemCount);
            cloneStack.m_41751_(this.stack.m_41783_());
            return new MerchantOffer(new ItemStack((ItemLike)IafItemRegistry.MYRMEX_DESERT_RESIN.get(), this.emeraldCount), cloneStack, this.maxUses, this.exp, this.multiplier);
        }
    }

    static class JungleResinForItemsTrade
    implements VillagerTrades.ItemListing {
        private final Item tradeItem;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public JungleResinForItemsTrade(ItemLike tradeItemIn, int countIn, int maxUsesIn, int xpValueIn) {
            this.tradeItem = tradeItemIn.m_5456_();
            this.count = countIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_5670_(@NotNull Entity trader, @NotNull Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((ItemLike)this.tradeItem, this.count);
            return new MerchantOffer(lvt_3_1_, new ItemStack((ItemLike)IafItemRegistry.MYRMEX_JUNGLE_RESIN.get()), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForJungleResinTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack stack;
        private final int emeraldCount;
        private final int itemCount;
        private final int maxUses;
        private final int exp;
        private final float multiplier;

        public ItemsForJungleResinTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForJungleResinTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public ItemsForJungleResinTrade(Item item, int JungleResin, int items, int maxUses, int exp) {
            this(new ItemStack((ItemLike)item), JungleResin, items, maxUses, exp);
        }

        public ItemsForJungleResinTrade(ItemStack stack, int JungleResin, int items, int maxUses, int exp) {
            this(stack, JungleResin, items, maxUses, exp, 0.05f);
        }

        public ItemsForJungleResinTrade(ItemStack stack, int JungleResin, int items, int maxUses, int exp, float multi) {
            this.stack = stack;
            this.emeraldCount = JungleResin;
            this.itemCount = items;
            this.maxUses = maxUses;
            this.exp = exp;
            this.multiplier = multi;
        }

        public MerchantOffer m_5670_(@NotNull Entity trader, @NotNull Random rand) {
            ItemStack cloneStack = new ItemStack((ItemLike)this.stack.m_41720_(), this.itemCount);
            cloneStack.m_41751_(this.stack.m_41783_());
            return new MerchantOffer(new ItemStack((ItemLike)IafItemRegistry.MYRMEX_JUNGLE_RESIN.get(), this.emeraldCount), cloneStack, this.maxUses, this.exp, this.multiplier);
        }
    }

    static class EnchantedItemForJungleResinTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack sellingStack;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public EnchantedItemForJungleResinTrade(Item p_i50535_1_, int emeraldCount, int maxUses, int xpValue) {
            this(p_i50535_1_, emeraldCount, maxUses, xpValue, 0.05f);
        }

        public EnchantedItemForJungleResinTrade(Item sellItem, int emeraldCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingStack = new ItemStack((ItemLike)sellItem);
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_5670_(@NotNull Entity trader, Random rand) {
            int lvt_3_1_ = 5 + rand.nextInt(15);
            ItemStack lvt_4_1_ = EnchantmentHelper.m_44877_((Random)rand, (ItemStack)new ItemStack((ItemLike)this.sellingStack.m_41720_()), (int)lvt_3_1_, (boolean)false);
            int lvt_5_1_ = Math.min(this.emeraldCount + lvt_3_1_, 64);
            ItemStack lvt_6_1_ = new ItemStack((ItemLike)IafItemRegistry.MYRMEX_JUNGLE_RESIN.get(), lvt_5_1_);
            return new MerchantOffer(lvt_6_1_, lvt_4_1_, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemWithPotionForJungleResinAndItemsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack potionStack;
        private final int potionCount;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final Item buyingItem;
        private final int buyingItemCount;
        private final float priceMultiplier;

        public ItemWithPotionForJungleResinAndItemsTrade(Item buyingItem, int buyingItemCount, Item p_i50526_3_, int p_i50526_4_, int emeralds, int maxUses, int xpValue) {
            this.potionStack = new ItemStack((ItemLike)p_i50526_3_);
            this.emeraldCount = emeralds;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.buyingItem = buyingItem;
            this.buyingItemCount = buyingItemCount;
            this.potionCount = p_i50526_4_;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_5670_(@NotNull Entity trader, Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((ItemLike)IafItemRegistry.MYRMEX_JUNGLE_RESIN.get(), this.emeraldCount);
            List lvt_4_1_ = Registry.f_122828_.m_123024_().filter(potion -> !potion.m_43488_().isEmpty() && PotionBrewing.m_43511_((Potion)potion)).collect(Collectors.toList());
            Potion lvt_5_1_ = (Potion)lvt_4_1_.get(rand.nextInt(lvt_4_1_.size()));
            ItemStack lvt_6_1_ = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.potionStack.m_41720_(), this.potionCount), (Potion)lvt_5_1_);
            return new MerchantOffer(lvt_3_1_, new ItemStack((ItemLike)this.buyingItem, this.buyingItemCount), lvt_6_1_, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForJungleResinAndItemsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack buyingItem;
        private final int buyingItemCount;
        private final int emeraldCount;
        private final ItemStack sellingItem;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForJungleResinAndItemsTrade(ItemLike buyingItem, int buyingItemCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this(buyingItem, buyingItemCount, 1, sellingItem, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForJungleResinAndItemsTrade(ItemLike buyingItem, int buyingItemCount, int emeraldCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this.buyingItem = new ItemStack(buyingItem);
            this.buyingItemCount = buyingItemCount;
            this.emeraldCount = emeraldCount;
            this.sellingItem = new ItemStack((ItemLike)sellingItem);
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_5670_(@NotNull Entity trader, @NotNull Random rand) {
            return new MerchantOffer(new ItemStack((ItemLike)IafItemRegistry.MYRMEX_JUNGLE_RESIN.get(), this.emeraldCount), new ItemStack((ItemLike)this.buyingItem.m_41720_(), this.buyingItemCount), new ItemStack((ItemLike)this.sellingItem.m_41720_(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class SuspiciousStewForEmeraldTrade
    implements VillagerTrades.ItemListing {
        final MobEffect effect;
        final int duration;
        final int xpValue;
        private final float priceMultiplier;

        public SuspiciousStewForEmeraldTrade(MobEffect effectIn, int durationIn, int xpValue) {
            this.effect = effectIn;
            this.duration = durationIn;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_5670_(@NotNull Entity trader, @NotNull Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((ItemLike)Items.f_42718_, 1);
            SuspiciousStewItem.m_43258_((ItemStack)lvt_3_1_, (MobEffect)this.effect, (int)this.duration);
            return new MerchantOffer(new ItemStack((ItemLike)IafItemRegistry.MYRMEX_DESERT_RESIN.get(), 1), lvt_3_1_, 12, this.xpValue, this.priceMultiplier);
        }
    }

    static class EnchantedItemForDesertResinTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack sellingStack;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public EnchantedItemForDesertResinTrade(Item p_i50535_1_, int emeraldCount, int maxUses, int xpValue) {
            this(p_i50535_1_, emeraldCount, maxUses, xpValue, 0.05f);
        }

        public EnchantedItemForDesertResinTrade(Item sellItem, int emeraldCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingStack = new ItemStack((ItemLike)sellItem);
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_5670_(@NotNull Entity trader, Random rand) {
            int lvt_3_1_ = 5 + rand.nextInt(15);
            ItemStack lvt_4_1_ = EnchantmentHelper.m_44877_((Random)rand, (ItemStack)new ItemStack((ItemLike)this.sellingStack.m_41720_()), (int)lvt_3_1_, (boolean)false);
            int lvt_5_1_ = Math.min(this.emeraldCount + lvt_3_1_, 64);
            ItemStack lvt_6_1_ = new ItemStack((ItemLike)IafItemRegistry.MYRMEX_DESERT_RESIN.get(), lvt_5_1_);
            return new MerchantOffer(lvt_6_1_, lvt_4_1_, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemWithPotionForDesertResinAndItemsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack potionStack;
        private final int potionCount;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final Item buyingItem;
        private final int buyingItemCount;
        private final float priceMultiplier;

        public ItemWithPotionForDesertResinAndItemsTrade(Item buyingItem, int buyingItemCount, Item p_i50526_3_, int p_i50526_4_, int emeralds, int maxUses, int xpValue) {
            this.potionStack = new ItemStack((ItemLike)p_i50526_3_);
            this.emeraldCount = emeralds;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.buyingItem = buyingItem;
            this.buyingItemCount = buyingItemCount;
            this.potionCount = p_i50526_4_;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_5670_(@NotNull Entity trader, Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((ItemLike)IafItemRegistry.MYRMEX_DESERT_RESIN.get(), this.emeraldCount);
            List lvt_4_1_ = Registry.f_122828_.m_123024_().filter(potion -> !potion.m_43488_().isEmpty() && PotionBrewing.m_43511_((Potion)potion)).collect(Collectors.toList());
            Potion lvt_5_1_ = (Potion)lvt_4_1_.get(rand.nextInt(lvt_4_1_.size()));
            ItemStack lvt_6_1_ = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.potionStack.m_41720_(), this.potionCount), (Potion)lvt_5_1_);
            return new MerchantOffer(lvt_3_1_, new ItemStack((ItemLike)this.buyingItem, this.buyingItemCount), lvt_6_1_, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForDesertResinAndItemsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack buyingItem;
        private final int buyingItemCount;
        private final int emeraldCount;
        private final ItemStack sellingItem;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForDesertResinAndItemsTrade(ItemLike buyingItem, int buyingItemCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this(buyingItem, buyingItemCount, 1, sellingItem, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForDesertResinAndItemsTrade(ItemLike buyingItem, int buyingItemCount, int emeraldCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this.buyingItem = new ItemStack(buyingItem);
            this.buyingItemCount = buyingItemCount;
            this.emeraldCount = emeraldCount;
            this.sellingItem = new ItemStack((ItemLike)sellingItem);
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_5670_(@NotNull Entity trader, @NotNull Random rand) {
            return new MerchantOffer(new ItemStack((ItemLike)IafItemRegistry.MYRMEX_DESERT_RESIN.get(), this.emeraldCount), new ItemStack((ItemLike)this.buyingItem.m_41720_(), this.buyingItemCount), new ItemStack((ItemLike)this.sellingItem.m_41720_(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }
}

