/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.render.tile.RenderGorgonHead;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.misc.IafDamageRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.util.NonNullLazy;
import org.jetbrains.annotations.NotNull;

public class ItemGorgonHead
extends Item {
    public ItemGorgonHead() {
        super(new Item.Properties().m_41491_(IceAndFire.TAB_ITEMS).m_41503_(1));
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            static final NonNullLazy<BlockEntityWithoutLevelRenderer> renderer = NonNullLazy.of(() -> new RenderGorgonHead(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)renderer.get();
            }
        });
    }

    public void m_7836_(ItemStack itemStack, @NotNull Level world, @NotNull Player player) {
        itemStack.m_41751_(new CompoundTag());
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public void m_5551_(@NotNull ItemStack stack, Level worldIn, LivingEntity entity, int timeLeft) {
        double dist = 32.0;
        Vec3 Vector3d = entity.m_20299_(1.0f);
        Vec3 Vector3d1 = entity.m_20252_(1.0f);
        Vec3 Vector3d2 = Vector3d.m_82520_(Vector3d1.f_82479_ * dist, Vector3d1.f_82480_ * dist, Vector3d1.f_82481_ * dist);
        double d1 = dist;
        Entity pointedEntity = null;
        List list = worldIn.m_6249_((Entity)entity, entity.m_142469_().m_82363_(Vector3d1.f_82479_ * dist, Vector3d1.f_82480_ * dist, Vector3d1.f_82481_ * dist).m_82377_(1.0, 1.0, 1.0), (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                boolean blindness = entity instanceof LivingEntity && ((LivingEntity)entity).m_21023_(MobEffects.f_19610_) || entity instanceof IBlacklistedFromStatues && !((IBlacklistedFromStatues)entity).canBeTurnedToStone();
                return entity != null && entity.m_6087_() && !blindness && (entity instanceof Player || entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity));
            }
        });
        double d2 = d1;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AABB axisalignedbb = entity1.m_142469_().m_82400_((double)entity1.m_6143_());
            Optional optional = axisalignedbb.m_82371_(Vector3d, Vector3d2);
            if (axisalignedbb.m_82390_(Vector3d)) {
                if (!(d2 >= 0.0)) continue;
                d2 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d3 = Vector3d.m_82554_((Vec3)optional.get())) < d2) && d2 != 0.0) continue;
            if (entity1.m_20201_() == entity.m_20201_() && !entity.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                continue;
            }
            pointedEntity = entity1;
            d2 = d3;
        }
        if (pointedEntity != null && pointedEntity instanceof LivingEntity) {
            pointedEntity.m_5496_(IafSoundRegistry.TURN_STONE, 1.0f, 1.0f);
            EntityStoneStatue statue = EntityStoneStatue.buildStatueEntity((LivingEntity)pointedEntity);
            if (pointedEntity instanceof Player) {
                pointedEntity.m_6469_((DamageSource)IafDamageRegistry.causeGorgonDamage(pointedEntity), 2.1474836E9f);
            } else if (!worldIn.f_46443_) {
                pointedEntity.m_142687_(Entity.RemovalReason.KILLED);
            }
            statue.m_19890_(pointedEntity.m_20185_(), pointedEntity.m_20186_(), pointedEntity.m_20189_(), pointedEntity.m_146908_(), pointedEntity.m_146909_());
            statue.f_20883_ = pointedEntity.m_146908_();
            if (!worldIn.f_46443_) {
                worldIn.m_7967_((Entity)statue);
            }
            if (entity instanceof Player && !((Player)entity).m_7500_()) {
                stack.m_41774_(1);
            }
        }
        stack.m_41783_().m_128379_("Active", false);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand hand) {
        ItemStack itemStackIn = playerIn.m_21120_(hand);
        playerIn.m_6672_(hand);
        itemStackIn.m_41783_().m_128379_("Active", true);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.iceandfire.legendary_weapon.desc").m_130940_(ChatFormatting.GRAY));
    }
}

