/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Target;
import org.jetbrains.annotations.NotNull;

public class NodeProcessorDeathWorm
extends NodeEvaluator {
    @NotNull
    public Node m_7171_() {
        return this.m_5676_(Mth.m_14107_((double)this.f_77313_.m_142469_().f_82288_), Mth.m_14107_((double)(this.f_77313_.m_142469_().f_82289_ + 0.5)), Mth.m_14107_((double)this.f_77313_.m_142469_().f_82290_));
    }

    @NotNull
    public Target m_7568_(double x, double y, double z) {
        return new Target(this.m_5676_(Mth.m_14107_((double)(x - 0.4)), Mth.m_14107_((double)(y + 0.5)), Mth.m_14107_((double)(z - 0.4))));
    }

    @NotNull
    public BlockPathTypes m_7209_(@NotNull BlockGetter blockaccessIn, int x, int y, int z, @NotNull Mob entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        return this.m_8086_(blockaccessIn, x, y, z);
    }

    @NotNull
    public BlockPathTypes m_8086_(BlockGetter worldIn, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (!this.isPassable(worldIn, blockpos.m_7495_()) && (blockstate.m_60795_() || this.isPassable(worldIn, blockpos))) {
            return BlockPathTypes.BREACH;
        }
        return this.isPassable(worldIn, blockpos) ? BlockPathTypes.WATER : BlockPathTypes.BLOCKED;
    }

    public int m_6065_(Node @NotNull [] p_222859_1_, @NotNull Node p_222859_2_) {
        int i = 0;
        for (Direction direction : Direction.values()) {
            Node pathpoint = this.getSandNode(p_222859_2_.f_77271_ + direction.m_122429_(), p_222859_2_.f_77272_ + direction.m_122430_(), p_222859_2_.f_77273_ + direction.m_122431_());
            if (pathpoint == null || pathpoint.f_77279_) continue;
            p_222859_1_[i++] = pathpoint;
        }
        return i;
    }

    @Nullable
    private Node getSandNode(int p_186328_1_, int p_186328_2_, int p_186328_3_) {
        BlockPathTypes pathnodetype = this.isFree(p_186328_1_, p_186328_2_, p_186328_3_);
        return pathnodetype != BlockPathTypes.BREACH && pathnodetype != BlockPathTypes.WATER ? null : this.m_5676_(p_186328_1_, p_186328_2_, p_186328_3_);
    }

    private BlockPathTypes isFree(int p_186327_1_, int p_186327_2_, int p_186327_3_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = p_186327_1_; i < p_186327_1_ + this.f_77315_; ++i) {
            for (int j = p_186327_2_; j < p_186327_2_ + this.f_77316_; ++j) {
                for (int k = p_186327_3_; k < p_186327_3_ + this.f_77317_; ++k) {
                    BlockState blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutable.m_122178_(i, j, k));
                    if (this.isPassable((BlockGetter)this.f_77312_, blockpos$mutable.m_7495_()) || !blockstate.m_60795_() && !this.isPassable((BlockGetter)this.f_77312_, (BlockPos)blockpos$mutable)) continue;
                    return BlockPathTypes.BREACH;
                }
            }
        }
        BlockState blockstate1 = this.f_77312_.m_8055_((BlockPos)blockpos$mutable);
        return this.isPassable(blockstate1) ? BlockPathTypes.WATER : BlockPathTypes.BLOCKED;
    }

    private boolean isPassable(BlockGetter world, BlockPos pos) {
        return world.m_8055_(pos).m_60767_() == Material.f_76317_ || world.m_8055_(pos).m_60767_() == Material.f_76296_;
    }

    private boolean isPassable(BlockState state) {
        return state.m_60767_() == Material.f_76317_ || state.m_60767_() == Material.f_76296_;
    }
}

