/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.util;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;

public class WorldUtil {
    public static boolean isBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isChunkLoaded(LevelAccessor world, int x, int z) {
        if (world.m_7726_() instanceof ServerChunkCache) {
            CompletableFuture future = ((ServerChunkCache)world.m_7726_()).m_8431_(x, z, ChunkStatus.f_62326_, false);
            return future.isDone() && future.getNow(ChunkHolder.f_139995_).left().isPresent();
        }
        return world.m_6522_(x, z, ChunkStatus.f_62326_, false) != null;
    }

    public static void markChunkDirty(Level world, BlockPos pos) {
        if (WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) {
            world.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4).m_8092_(true);
            BlockState state = world.m_8055_(pos);
            world.m_7260_(pos, state, state, 3);
        }
    }

    public static boolean isChunkLoaded(LevelAccessor world, ChunkPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.f_45578_, pos.f_45579_);
    }

    public static boolean isEntityBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldUtil.isEntityChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, int x, int z) {
        return WorldUtil.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, ChunkPos pos) {
        if (world instanceof ServerLevel) {
            return ((ServerLevel)world).m_143340_(pos.m_45615_());
        }
        return WorldUtil.isChunkLoaded(world, pos);
    }

    public static boolean isAABBLoaded(Level world, AABB box) {
        return WorldUtil.isChunkLoaded((LevelAccessor)world, (int)box.f_82288_ >> 4, (int)box.f_82290_ >> 4) && WorldUtil.isChunkLoaded((LevelAccessor)world, (int)box.f_82291_ >> 4, (int)box.f_82293_ >> 4);
    }

    public static boolean isPastTime(Level world, int pastTime) {
        return world.m_46468_() % 24000L <= (long)pastTime;
    }

    public static boolean isOverworldType(Level world) {
        return WorldUtil.isOfWorldType(world, (ResourceKey<DimensionType>)DimensionType.f_63845_);
    }

    public static boolean isNetherType(Level world) {
        return WorldUtil.isOfWorldType(world, (ResourceKey<DimensionType>)DimensionType.f_63846_);
    }

    public static boolean isOfWorldType(Level world, ResourceKey<DimensionType> type) {
        RegistryAccess dynRegistries = world.m_5962_();
        ResourceLocation loc = ((Registry)dynRegistries.m_6632_(Registry.f_122818_).get()).m_7981_((Object)world.m_6042_());
        if (loc == null) {
            if (world.f_46443_) {
                return world.m_6042_().m_63969_().equals((Object)type.m_135782_());
            }
            return false;
        }
        ResourceKey regKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)loc);
        return regKey == type;
    }

    public static boolean isPeaceful(Level world) {
        return !world.m_6106_().m_5470_().m_46207_(GameRules.f_46134_) || world.m_46791_().equals((Object)Difficulty.PEACEFUL);
    }

    public static int getDimensionMaxHeight(DimensionType dimensionType) {
        return dimensionType.m_63964_() + dimensionType.m_156732_();
    }

    public static int getDimensionMinHeight(DimensionType dimensionType) {
        return dimensionType.m_156732_();
    }

    public static boolean isInWorldHeight(int yBlock, Level world) {
        DimensionType dimensionType = world.m_6042_();
        return yBlock > WorldUtil.getDimensionMinHeight(dimensionType) && yBlock < WorldUtil.getDimensionMaxHeight(dimensionType);
    }
}

