/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WorldGenCyclopsCave
extends Feature<NoneFeatureConfiguration> {
    public static final ResourceLocation CYCLOPS_CHEST = new ResourceLocation("iceandfire", "chest/cyclops_cave");
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public WorldGenCyclopsCave(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    private void genSheepPen(ServerLevelAccessor worldIn, BlockPos blockpos, Random rand, BlockPos origin, float radius) {
        int side;
        int sideCount;
        int width = 5 + rand.nextInt(3);
        int sheeps = 2 + rand.nextInt(3);
        int sheepsSpawned = 0;
        Direction direction = Direction.NORTH;
        BlockPos end = blockpos;
        for (sideCount = 0; sideCount < 4; ++sideCount) {
            for (side = 0; side < width; ++side) {
                if (!(origin.m_123331_((Vec3i)end.m_5484_(direction, side)) <= (double)(radius * radius))) continue;
                worldIn.m_7731_(end.m_5484_(direction, side), this.getFenceState((LevelAccessor)worldIn, end.m_5484_(direction, side)), 3);
                if (!worldIn.m_46859_(end.m_5484_(direction, side).m_142300_(direction.m_122427_())) || sheepsSpawned >= sheeps) continue;
                BlockPos sheepPos = end.m_5484_(direction, side).m_142300_(direction.m_122427_());
                Sheep entitySheep = new Sheep(EntityType.f_20520_, (Level)worldIn.m_6018_());
                entitySheep.m_6034_((double)((float)sheepPos.m_123341_() + 0.5f), (double)((float)sheepPos.m_123342_() + 0.5f), (double)((float)sheepPos.m_123343_() + 0.5f));
                entitySheep.m_29855_(rand.nextInt(4) == 0 ? DyeColor.YELLOW : DyeColor.WHITE);
                worldIn.m_7967_((Entity)entitySheep);
                ++sheepsSpawned;
            }
            end = end.m_5484_(direction, width);
            direction = direction.m_122427_();
        }
        for (sideCount = 0; sideCount < 4; ++sideCount) {
            for (side = 0; side < width; ++side) {
                if (!(origin.m_123331_((Vec3i)end.m_5484_(direction, side)) <= (double)(radius * radius))) continue;
                worldIn.m_7731_(end.m_5484_(direction, side), this.getFenceState((LevelAccessor)worldIn, end.m_5484_(direction, side)), 3);
            }
            end = end.m_5484_(direction, width);
            direction = direction.m_122427_();
        }
        for (int x = 1; x < width - 1; ++x) {
            for (int z = 1; z < width - 1; ++z) {
                if (!(origin.m_123331_((Vec3i)end.m_142082_(x, 0, z)) <= (double)(radius * radius))) continue;
                worldIn.m_7731_(end.m_142082_(x, 0, z), Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }

    private boolean isTouchingAir(LevelAccessor worldIn, BlockPos pos) {
        boolean isTouchingAir = true;
        for (Direction direction : HORIZONTALS) {
            if (worldIn.m_46859_(pos.m_142300_(direction))) continue;
            isTouchingAir = false;
        }
        return isTouchingAir;
    }

    private void genSkeleton(LevelAccessor worldIn, BlockPos blockpos, Random rand, BlockPos origin, float radius) {
        Direction direction = HORIZONTALS[new Random().nextInt(3)];
        Direction.Axis oppositeAxis = direction.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        int maxRibHeight = rand.nextInt(2);
        for (int spine = 0; spine < 5 + rand.nextInt(2) * 2; ++spine) {
            BlockPos segment = blockpos.m_5484_(direction, spine);
            if (origin.m_123331_((Vec3i)segment) <= (double)(radius * radius)) {
                worldIn.m_7731_(segment, (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 2);
            }
            if (spine % 2 == 0) continue;
            BlockPos rightRib = segment.m_142300_(direction.m_122428_());
            BlockPos leftRib = segment.m_142300_(direction.m_122427_());
            if (origin.m_123331_((Vec3i)rightRib) <= (double)(radius * radius)) {
                worldIn.m_7731_(rightRib, (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
            }
            if (origin.m_123331_((Vec3i)leftRib) <= (double)(radius * radius)) {
                worldIn.m_7731_(leftRib, (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
            }
            for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                if (origin.m_123331_((Vec3i)rightRib.m_6630_(ribHeight).m_142300_(direction.m_122428_())) <= (double)(radius * radius)) {
                    worldIn.m_7731_(rightRib.m_6630_(ribHeight).m_142300_(direction.m_122428_()), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y), 2);
                }
                if (!(origin.m_123331_((Vec3i)leftRib.m_6630_(ribHeight).m_142300_(direction.m_122427_())) <= (double)(radius * radius))) continue;
                worldIn.m_7731_(leftRib.m_6630_(ribHeight).m_142300_(direction.m_122427_()), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y), 2);
            }
            if (origin.m_123331_((Vec3i)rightRib.m_6630_(maxRibHeight + 2)) <= (double)(radius * radius)) {
                worldIn.m_7731_(rightRib.m_6630_(maxRibHeight + 2), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
            }
            if (!(origin.m_123331_((Vec3i)leftRib.m_6630_(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
            worldIn.m_7731_(leftRib.m_6630_(maxRibHeight + 2), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
        }
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos position = context.m_159777_();
        if (!(IafConfig.generateCyclopsCaves && rand.nextInt(IafConfig.spawnCyclopsCaveChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((LevelAccessor)worldIn, position) && IafWorldRegistry.isFarEnoughFromDangerousGen((ServerLevelAccessor)worldIn, position))) {
            return false;
        }
        if (!worldIn.m_6425_((position = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, position)).m_7495_()).m_76178_()) {
            return false;
        }
        int i1 = 16;
        int i2 = i1 - 2;
        int sheepPenCount = 0;
        int dist = 6;
        if (worldIn.m_46859_(position.m_142082_(i1 - dist, -3, -i1 + dist)) || worldIn.m_46859_(position.m_142082_(i1 - dist, -3, i1 - dist)) || worldIn.m_46859_(position.m_142082_(-i1 + dist, -3, -i1 + dist)) || worldIn.m_46859_(position.m_142082_(-i1 + dist, -3, i1 - dist))) {
            return false;
        }
        int ySize = rand.nextInt(2);
        int j = i1 + rand.nextInt(2);
        int k = 12 + ySize;
        int l = i1 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            boolean isNotInDoorway;
            boolean doorwayX = blockpos.m_123341_() >= position.m_123341_() - 2 + rand.nextInt(2) && blockpos.m_123341_() <= position.m_123341_() + 2 + rand.nextInt(2);
            boolean doorwayZ = blockpos.m_123343_() >= position.m_123343_() - 2 + rand.nextInt(2) && blockpos.m_123343_() <= position.m_123343_() + 2 + rand.nextInt(2);
            boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && blockpos.m_123342_() > position.m_123342_() || blockpos.m_123342_() > position.m_123342_() + k - (3 + rand.nextInt(2));
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f))) continue;
            if (!(worldIn.m_8055_(position).m_60734_() instanceof AbstractChestBlock) && worldIn.m_8055_(position).m_60800_((BlockGetter)worldIn, position) >= 0.0f && isNotInDoorway) {
                worldIn.m_7731_(blockpos, Blocks.f_50069_.m_49966_(), 3);
            }
            if (blockpos.m_123342_() == position.m_123342_()) {
                worldIn.m_7731_(blockpos, Blocks.f_50079_.m_49966_(), 3);
            }
            if (blockpos.m_123342_() > position.m_123342_() - 1 || worldIn.m_8055_(blockpos).m_60815_()) continue;
            worldIn.m_7731_(blockpos, Blocks.f_50652_.m_49966_(), 3);
        }
        ySize = rand.nextInt(2);
        j = i2 + rand.nextInt(2);
        k = 10 + ySize;
        l = i2 + rand.nextInt(2);
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f)) || blockpos.m_123342_() <= position.m_123342_() || worldIn.m_8055_(position).m_60734_() instanceof AbstractChestBlock) continue;
            worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
        }
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f)) || blockpos.m_123342_() != position.m_123342_()) continue;
            if (rand.nextInt(130) == 0 && this.isTouchingAir((LevelAccessor)worldIn, blockpos.m_7494_())) {
                this.genSkeleton((LevelAccessor)worldIn, blockpos.m_7494_(), rand, position, f);
            }
            if (rand.nextInt(130) == 0 && blockpos.m_123331_((Vec3i)position) <= (double)(f * f) * (double)0.8f && sheepPenCount < 2) {
                this.genSheepPen((ServerLevelAccessor)worldIn, blockpos.m_7494_(), rand, position, f);
                ++sheepPenCount;
            }
            if (rand.nextInt(80) == 0 && this.isTouchingAir((LevelAccessor)worldIn, blockpos.m_7494_())) {
                BlockEntity tileentity1;
                worldIn.m_7731_(blockpos.m_7494_(), (BlockState)((Block)IafBlockRegistry.GOLD_PILE.get()).m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
                worldIn.m_7731_(blockpos.m_7494_().m_142127_(), (BlockState)((Block)IafBlockRegistry.GOLD_PILE.get()).m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.m_7731_(blockpos.m_7494_().m_142128_(), (BlockState)((Block)IafBlockRegistry.GOLD_PILE.get()).m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.m_7731_(blockpos.m_7494_().m_142125_(), (BlockState)((Block)IafBlockRegistry.GOLD_PILE.get()).m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.m_7731_(blockpos.m_7494_().m_142126_(), (BlockState)((Block)IafBlockRegistry.GOLD_PILE.get()).m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.m_7731_(blockpos.m_6630_(2), (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                if (worldIn.m_8055_(blockpos.m_6630_(2)).m_60734_() instanceof AbstractChestBlock && (tileentity1 = worldIn.m_7702_(blockpos.m_6630_(2))) instanceof ChestBlockEntity) {
                    ((ChestBlockEntity)tileentity1).m_59626_(CYCLOPS_CHEST, rand.nextLong());
                }
            }
            if (rand.nextInt(50) != 0 || !this.isTouchingAir((LevelAccessor)worldIn, blockpos.m_7494_())) continue;
            int torchHeight = rand.nextInt(2) + 1;
            for (int fence = 0; fence < torchHeight; ++fence) {
                worldIn.m_7731_(blockpos.m_6630_(1 + fence), this.getFenceState((LevelAccessor)worldIn, blockpos.m_6630_(1 + fence)), 3);
            }
            worldIn.m_7731_(blockpos.m_6630_(1 + torchHeight), Blocks.f_50081_.m_49966_(), 2);
        }
        EntityCyclops cyclops = (EntityCyclops)((EntityType)IafEntityRegistry.CYCLOPS.get()).m_20615_((Level)worldIn.m_6018_());
        cyclops.m_19890_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 1.5, (double)position.m_123343_() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        worldIn.m_7967_((Entity)cyclops);
        return true;
    }

    public BlockState getFenceState(LevelAccessor world, BlockPos pos) {
        boolean east = world.m_8055_(pos.m_142126_()).m_60734_() == Blocks.f_50132_;
        boolean west = world.m_8055_(pos.m_142125_()).m_60734_() == Blocks.f_50132_;
        boolean north = world.m_8055_(pos.m_142127_()).m_60734_() == Blocks.f_50132_;
        boolean south = world.m_8055_(pos.m_142128_()).m_60734_() == Blocks.f_50132_;
        return (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50132_.m_49966_().m_61124_((Property)FenceBlock.f_52310_, (Comparable)Boolean.valueOf(east))).m_61124_((Property)FenceBlock.f_52312_, (Comparable)Boolean.valueOf(west))).m_61124_((Property)FenceBlock.f_52309_, (Comparable)Boolean.valueOf(north))).m_61124_((Property)FenceBlock.f_52311_, (Comparable)Boolean.valueOf(south));
    }
}

