/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.util.ShapeBuilder;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCaveStalactites;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;

public abstract class WorldGenDragonCave
extends Feature<NoneFeatureConfiguration> {
    public ResourceLocation DRAGON_CHEST;
    public ResourceLocation DRAGON_MALE_CHEST;
    public WorldGenCaveStalactites CEILING_DECO;
    public BlockState PALETTE_BLOCK1;
    public BlockState PALETTE_BLOCK2;
    public BlockState PALETTE_ORE1;
    public BlockState PALETTE_ORE2;
    public BlockState TREASURE_PILE;
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public boolean isMale;
    public boolean generateGemOre = false;

    protected WorldGenDragonCave(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos position = context.m_159777_();
        if (!(IafConfig.generateDragonDens && rand.nextInt(IafConfig.generateDragonDenChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((LevelAccessor)worldIn, position) && IafWorldRegistry.isFarEnoughFromDangerousGen((ServerLevelAccessor)worldIn, position))) {
            return false;
        }
        this.isMale = rand.nextBoolean();
        ChunkPos chunkPos = worldIn.m_46865_(position).m_7697_();
        int j = 40;
        for (int k = 0; k < 20; ++k) {
            for (int l = 0; l < 20; ++l) {
                j = Math.min(j, worldIn.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, position.m_123341_() + k, position.m_123343_() + l));
            }
        }
        j -= 20;
        if ((j -= rand.nextInt(30)) < worldIn.m_141937_() + 20) {
            return false;
        }
        position = new BlockPos((chunkPos.f_45578_ << 4) + 8, j, (chunkPos.f_45579_ << 4) + 8);
        int dragonAge = 75 + rand.nextInt(50);
        int radius = (int)((float)dragonAge * 0.2f) + rand.nextInt(4);
        this.generateCave((LevelAccessor)worldIn, radius, 3, position, rand);
        EntityDragonBase dragon = this.createDragon(worldIn, rand, position, dragonAge);
        worldIn.m_7967_((Entity)dragon);
        return true;
    }

    public void generateCave(LevelAccessor worldIn, int radius, int amount, BlockPos center, Random rand) {
        ArrayList<SphereInfo> sphereList = new ArrayList<SphereInfo>();
        sphereList.add(new SphereInfo(radius, center.m_7949_()));
        Stream<BlockPos> sphereBlocks = ShapeBuilder.start().getAllInCutOffSphereMutable(radius, radius / 2, center).toStream(false);
        Stream<BlockPos> hollowBlocks = ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(radius - 2, (int)((double)(radius - 2) * 0.75), (radius - 2) / 2, rand, center).toStream(false);
        for (int i = 0; i < amount + rand.nextInt(2); ++i) {
            Direction direction = HORIZONTALS[rand.nextInt(HORIZONTALS.length - 1)];
            int r = 2 * (int)((float)radius / 3.0f) + rand.nextInt(8);
            BlockPos centerOffset = center.m_5484_(direction, radius - 2);
            sphereBlocks = Stream.concat(sphereBlocks, ShapeBuilder.start().getAllInCutOffSphereMutable(r, r, centerOffset).toStream(false));
            hollowBlocks = Stream.concat(hollowBlocks, ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(r - 2, (int)((double)(r - 2) * 0.75), (r - 2) / 2, rand, centerOffset).toStream(false));
            sphereList.add(new SphereInfo(r, centerOffset));
        }
        Set<BlockPos> shellBlocksSet = sphereBlocks.map(BlockPos::m_7949_).collect(Collectors.toSet());
        Set<BlockPos> hollowBlocksSet = hollowBlocks.map(BlockPos::m_7949_).collect(Collectors.toSet());
        shellBlocksSet.removeAll(hollowBlocksSet);
        this.createShell(worldIn, rand, shellBlocksSet);
        this.hollowOut(worldIn, hollowBlocksSet);
        this.decorateCave(worldIn, rand, hollowBlocksSet, sphereList, center);
        sphereList.clear();
    }

    public void createShell(LevelAccessor worldIn, Random rand, Set<BlockPos> positions) {
        positions.forEach(blockPos -> {
            if (!(worldIn.m_8055_(blockPos).m_60734_() instanceof BaseEntityBlock) && worldIn.m_8055_(blockPos).m_60800_((BlockGetter)worldIn, blockPos) >= 0.0f) {
                boolean doOres;
                boolean bl = doOres = rand.nextInt(IafConfig.oreToStoneRatioForDragonCaves + 1) == 0;
                if (doOres) {
                    int chance = rand.nextInt(199) + 1;
                    if (chance < 30) {
                        worldIn.m_7731_(blockPos, Blocks.f_49996_.m_49966_(), 2);
                    } else if (chance > 30 && chance < 40) {
                        worldIn.m_7731_(blockPos, Blocks.f_49995_.m_49966_(), 2);
                    } else if (chance > 40 && chance < 45) {
                        worldIn.m_7731_(blockPos, IafConfig.generateCopperOre ? ((Block)IafBlockRegistry.COPPER_ORE.get()).m_49966_() : this.PALETTE_BLOCK1, 2);
                    } else if (chance > 45 && chance < 50) {
                        worldIn.m_7731_(blockPos, IafConfig.generateSilverOre ? ((Block)IafBlockRegistry.SILVER_ORE.get()).m_49966_() : this.PALETTE_BLOCK1, 2);
                    } else if (chance > 50 && chance < 60) {
                        worldIn.m_7731_(blockPos, Blocks.f_49997_.m_49966_(), 2);
                    } else if (chance > 60 && chance < 70) {
                        worldIn.m_7731_(blockPos, Blocks.f_50173_.m_49966_(), 2);
                    } else if (chance > 70 && chance < 80) {
                        worldIn.m_7731_(blockPos, Blocks.f_50059_.m_49966_(), 2);
                    } else if (chance > 80 && chance < 90) {
                        worldIn.m_7731_(blockPos, Blocks.f_50089_.m_49966_(), 2);
                    } else if (chance > 90) {
                        worldIn.m_7731_(blockPos, this.generateGemOre ? this.PALETTE_ORE1 : this.PALETTE_ORE2, 2);
                    }
                } else {
                    worldIn.m_7731_(blockPos, rand.nextBoolean() ? this.PALETTE_BLOCK1 : this.PALETTE_BLOCK2, 2);
                }
            }
        });
    }

    public void hollowOut(LevelAccessor worldIn, Set<BlockPos> positions) {
        positions.forEach(blockPos -> {
            if (!(worldIn.m_8055_(blockPos).m_60734_() instanceof BaseEntityBlock)) {
                worldIn.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            }
        });
    }

    public void decorateCave(LevelAccessor worldIn, Random rand, Set<BlockPos> positions, List<SphereInfo> spheres, BlockPos center) {
        for (SphereInfo sphere : spheres) {
            BlockPos pos = sphere.pos;
            int radius = sphere.radius;
            for (int i = 0; i < 15 + rand.nextInt(10); ++i) {
                this.CEILING_DECO.generate(worldIn, rand, pos.m_6630_(radius / 2 - 1).m_142082_(rand.nextInt(radius) - radius / 2, 0, rand.nextInt(radius) - radius / 2));
            }
        }
        int y = center.m_123342_();
        positions.forEach(blockPos -> {
            if (blockPos.m_123342_() < y && worldIn.m_8055_(blockPos.m_7495_()).m_60767_() == Material.f_76278_ && worldIn.m_8055_(blockPos).m_60767_() == Material.f_76296_) {
                this.setGoldPile(worldIn, (BlockPos)blockPos, rand);
            }
        });
    }

    public void setGoldPile(LevelAccessor world, BlockPos pos, Random rand) {
        if (!(world.m_8055_(pos).m_60734_() instanceof BaseEntityBlock)) {
            int chance = rand.nextInt(99) + 1;
            if (chance < 60) {
                int goldRand = Math.max(1, IafConfig.dragonDenGoldAmount) * (this.isMale ? 1 : 2);
                boolean generateGold = rand.nextInt(goldRand) == 0;
                world.m_7731_(pos, generateGold ? (BlockState)this.TREASURE_PILE.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + rand.nextInt(7))) : Blocks.f_50016_.m_49966_(), 3);
            } else if (chance == 61) {
                BlockEntity tileentity1;
                world.m_7731_(pos, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)HORIZONTALS[rand.nextInt(3)]), 2);
                if (world.m_8055_(pos).m_60734_() instanceof ChestBlock && (tileentity1 = world.m_7702_(pos)) instanceof ChestBlockEntity) {
                    ((ChestBlockEntity)tileentity1).m_59626_(this.isMale ? this.DRAGON_MALE_CHEST : this.DRAGON_CHEST, rand.nextLong());
                }
            }
        }
    }

    abstract EntityDragonBase createDragon(WorldGenLevel var1, Random var2, BlockPos var3, int var4);

    private static class SphereInfo {
        int radius;
        BlockPos pos;

        private SphereInfo(int radius, BlockPos pos) {
            this.radius = radius;
            this.pos = pos;
        }
    }
}

