/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.HomePosition;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCaveStalactites;
import com.github.alexthe666.iceandfire.world.gen.WorldGenDragonCave;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WorldGenLightningDragonCave
extends WorldGenDragonCave {
    public static ResourceLocation LIGHTNING_DRAGON_CHEST = new ResourceLocation("iceandfire", "chest/lightning_dragon_female_cave");
    public static ResourceLocation LIGHTNING_DRAGON_CHEST_MALE = new ResourceLocation("iceandfire", "chest/lightning_dragon_male_cave");

    public WorldGenLightningDragonCave(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
        this.DRAGON_CHEST = LIGHTNING_DRAGON_CHEST;
        this.DRAGON_MALE_CHEST = LIGHTNING_DRAGON_CHEST_MALE;
        this.CEILING_DECO = new WorldGenCaveStalactites((Block)IafBlockRegistry.CRACKLED_STONE.get(), 9);
        this.PALETTE_BLOCK1 = ((Block)IafBlockRegistry.CRACKLED_STONE.get()).m_49966_();
        this.PALETTE_BLOCK2 = ((Block)IafBlockRegistry.CRACKLED_COBBLESTONE.get()).m_49966_();
        this.TREASURE_PILE = ((Block)IafBlockRegistry.COPPER_PILE.get()).m_49966_();
        this.PALETTE_ORE1 = ((Block)IafBlockRegistry.AMYTHEST_ORE.get()).m_49966_();
        this.PALETTE_ORE2 = Blocks.f_50264_.m_49966_();
        this.generateGemOre = IafConfig.generateAmythestOre;
    }

    @Override
    EntityDragonBase createDragon(WorldGenLevel worldIn, Random rand, BlockPos position, int dragonAge) {
        EntityLightningDragon dragon = new EntityLightningDragon((EntityType)IafEntityRegistry.LIGHTNING_DRAGON.get(), (Level)worldIn.m_6018_());
        dragon.setGender(this.isMale);
        dragon.growDragon(dragonAge);
        dragon.setAgingDisabled(true);
        dragon.m_21153_(dragon.m_21233_());
        dragon.setVariant(rand.nextInt(4));
        dragon.m_19890_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.m_21837_(true);
        dragon.homePos = new HomePosition(position, (Level)worldIn.m_6018_());
        dragon.setHunger(50);
        return dragon;
    }
}

