/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockMyrmexBiolight;
import com.github.alexthe666.iceandfire.block.BlockMyrmexConnectedResin;
import com.github.alexthe666.iceandfire.block.BlockMyrmexResin;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSentinel;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSoldier;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexDecoration;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WorldGenMyrmexHive
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState DESERT_RESIN = ((Block)IafBlockRegistry.MYRMEX_DESERT_RESIN.get()).m_49966_();
    private static final BlockState STICKY_DESERT_RESIN = ((Block)IafBlockRegistry.MYRMEX_DESERT_RESIN_STICKY.get()).m_49966_();
    private static final BlockState JUNGLE_RESIN = ((Block)IafBlockRegistry.MYRMEX_JUNGLE_RESIN.get()).m_49966_();
    private static final BlockState STICKY_JUNGLE_RESIN = ((Block)IafBlockRegistry.MYRMEX_JUNGLE_RESIN_STICKY.get()).m_49966_();
    public MyrmexHive hive;
    private int entrances = 0;
    private int totalRooms;
    private boolean hasFoodRoom;
    private boolean hasNursery;
    private boolean small;
    private final boolean jungle;
    private BlockPos centerOfHive;

    public WorldGenMyrmexHive(boolean small, boolean jungle, Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
        this.small = small;
        this.jungle = jungle;
    }

    public boolean placeSmallGen(WorldGenLevel worldIn, Random rand, BlockPos pos) {
        this.hasFoodRoom = false;
        this.hasNursery = false;
        this.totalRooms = 0;
        this.entrances = 0;
        this.centerOfHive = pos;
        this.generateMainRoom((ServerLevelAccessor)worldIn, rand, pos);
        this.small = false;
        return false;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos pos = context.m_159777_();
        if (!this.small) {
            if (!(IafConfig.generateMyrmexColonies && rand.nextInt(IafConfig.myrmexColonyGenChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((LevelAccessor)worldIn, pos) && IafWorldRegistry.isFarEnoughFromDangerousGen((ServerLevelAccessor)worldIn, pos))) {
                return false;
            }
            if (MyrmexWorldData.get((Level)worldIn.m_6018_()) != null && MyrmexWorldData.get((Level)worldIn.m_6018_()).getNearestHive(pos, 200) != null) {
                return false;
            }
        }
        pos = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos);
        if (!this.small && !worldIn.m_6425_(pos.m_7495_()).m_76178_()) {
            return false;
        }
        this.hasFoodRoom = false;
        this.hasNursery = false;
        this.totalRooms = 0;
        int down = Math.max(15, pos.m_123342_() - 20 + rand.nextInt(10));
        BlockPos undergroundPos = new BlockPos(pos.m_123341_(), down, pos.m_123343_());
        this.entrances = 0;
        this.centerOfHive = undergroundPos;
        this.generateMainRoom((ServerLevelAccessor)worldIn, rand, undergroundPos);
        this.small = false;
        return true;
    }

    private void generateMainRoom(ServerLevelAccessor world, Random rand, BlockPos position) {
        this.hive = new MyrmexHive((Level)world.m_6018_(), position, 100);
        MyrmexWorldData.addHive((Level)world.m_6018_(), this.hive);
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        this.generateSphere((LevelAccessor)world, rand, position, 14, 7, resin, sticky_resin);
        this.generateSphere((LevelAccessor)world, rand, position, 12, 5, Blocks.f_50016_.m_49966_());
        this.decorateSphere((LevelAccessor)world, rand, position, 12, 5, RoomType.QUEEN);
        this.generatePath((LevelAccessor)world, rand, position.m_5484_(Direction.NORTH, 9).m_7495_(), 15 + rand.nextInt(10), Direction.NORTH, 100);
        this.generatePath((LevelAccessor)world, rand, position.m_5484_(Direction.SOUTH, 9).m_7495_(), 15 + rand.nextInt(10), Direction.SOUTH, 100);
        this.generatePath((LevelAccessor)world, rand, position.m_5484_(Direction.WEST, 9).m_7495_(), 15 + rand.nextInt(10), Direction.WEST, 100);
        this.generatePath((LevelAccessor)world, rand, position.m_5484_(Direction.EAST, 9).m_7495_(), 15 + rand.nextInt(10), Direction.EAST, 100);
        if (!this.small) {
            EntityMyrmexBase myrmex;
            int i;
            EntityMyrmexQueen queen = new EntityMyrmexQueen((EntityType<EntityMyrmexQueen>)((EntityType)IafEntityRegistry.MYRMEX_QUEEN.get()), (Level)world.m_6018_());
            BlockPos ground = MyrmexHive.getGroundedPos((LevelAccessor)world, position);
            queen.m_6518_(world, world.m_6436_(ground), MobSpawnType.CHUNK_GENERATION, null, null);
            queen.setHive(this.hive);
            queen.setJungleVariant(this.jungle);
            queen.m_19890_((double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 1.0, (double)ground.m_123343_() + 0.5, 0.0f, 0.0f);
            world.m_7967_((Entity)queen);
            for (i = 0; i < 4 + rand.nextInt(3); ++i) {
                myrmex = new EntityMyrmexWorker((EntityType<EntityMyrmexWorker>)((EntityType)IafEntityRegistry.MYRMEX_WORKER.get()), (Level)world.m_6018_());
                myrmex.m_6518_(world, world.m_6436_(ground), MobSpawnType.CHUNK_GENERATION, null, null);
                myrmex.setHive(this.hive);
                myrmex.m_19890_((double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 1.0, (double)ground.m_123343_() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                world.m_7967_((Entity)myrmex);
            }
            for (i = 0; i < 2 + rand.nextInt(2); ++i) {
                myrmex = new EntityMyrmexSoldier((EntityType<EntityMyrmexSoldier>)((EntityType)IafEntityRegistry.MYRMEX_SOLDIER.get()), (Level)world.m_6018_());
                myrmex.m_6518_(world, world.m_6436_(ground), MobSpawnType.CHUNK_GENERATION, null, null);
                myrmex.setHive(this.hive);
                myrmex.m_19890_((double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 1.0, (double)ground.m_123343_() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                world.m_7967_((Entity)myrmex);
            }
            for (i = 0; i < rand.nextInt(2); ++i) {
                myrmex = new EntityMyrmexSentinel((EntityType)IafEntityRegistry.MYRMEX_SENTINEL.get(), (Level)world.m_6018_());
                myrmex.m_6518_(world, world.m_6436_(ground), MobSpawnType.CHUNK_GENERATION, null, null);
                myrmex.setHive(this.hive);
                myrmex.m_19890_((double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 1.0, (double)ground.m_123343_() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                world.m_7967_((Entity)myrmex);
            }
        }
    }

    private void generatePath(LevelAccessor world, Random rand, BlockPos offset, int length, Direction direction, int roomChance) {
        if (roomChance == 0) {
            return;
        }
        if (this.small) {
            length /= 2;
            if (this.entrances < 1) {
                for (int i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, offset.m_5484_(direction, i), 3, 5, direction);
                }
                this.generateEntrance(world, rand, offset.m_5484_(direction, length), 4, 4, direction);
            } else if (this.totalRooms < 2) {
                int i;
                for (i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, offset.m_5484_(direction, i), 3, 5, direction);
                }
                this.generateRoom(world, rand, offset.m_5484_(direction, length), 6, 4, roomChance / 2, direction);
                for (i = -3; i < 3; ++i) {
                    this.generateCircleAir(world, rand, offset.m_5484_(direction, i), 3, 5, direction);
                    this.generateCircleAir(world, rand, offset.m_5484_(direction, length + i), 3, 5, direction);
                }
                ++this.totalRooms;
            }
        } else if (rand.nextInt(100) < roomChance) {
            if (this.entrances < 3 && rand.nextInt(1 + this.entrances * 2) == 0 && this.hasFoodRoom && this.hasNursery && this.totalRooms > 3 || this.entrances == 0) {
                this.generateEntrance(world, rand, offset.m_5484_(direction, 1), 4, 4, direction);
            } else {
                int i;
                for (i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, offset.m_5484_(direction, i), 3, 5, direction);
                }
                for (i = -3; i < 3; ++i) {
                    this.generateCircleAir(world, rand, offset.m_5484_(direction, length + i), 3, 5, direction);
                }
                ++this.totalRooms;
                this.generateRoom(world, rand, offset.m_5484_(direction, length), 7, 4, roomChance / 2, direction);
            }
        }
    }

    private void generateRoom(LevelAccessor world, Random rand, BlockPos position, int size, int height, int roomChance, Direction direction) {
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        RoomType type = RoomType.random(rand);
        if (!this.hasFoodRoom) {
            type = RoomType.FOOD;
            this.hasFoodRoom = true;
        } else if (!this.hasNursery) {
            type = RoomType.NURSERY;
            this.hasNursery = true;
        }
        this.generateSphereRespectResin(world, rand, position, size + 2, height + 2, resin, sticky_resin);
        this.generateSphere(world, rand, position, size, height - 1, Blocks.f_50016_.m_49966_());
        this.decorateSphere(world, rand, position, size, height - 1, type);
        this.hive.addRoom(position, type);
        if (!this.small) {
            if (rand.nextInt(3) == 0 && direction.m_122424_() != Direction.NORTH) {
                this.generatePath(world, rand, position.m_5484_(Direction.NORTH, size - 2), 5 + rand.nextInt(20), Direction.NORTH, roomChance);
            }
            if (rand.nextInt(3) == 0 && direction.m_122424_() != Direction.SOUTH) {
                this.generatePath(world, rand, position.m_5484_(Direction.SOUTH, size - 2), 5 + rand.nextInt(20), Direction.SOUTH, roomChance);
            }
            if (rand.nextInt(3) == 0 && direction.m_122424_() != Direction.WEST) {
                this.generatePath(world, rand, position.m_5484_(Direction.WEST, size - 2), 5 + rand.nextInt(20), Direction.WEST, roomChance);
            }
            if (rand.nextInt(3) == 0 && direction.m_122424_() != Direction.EAST) {
                this.generatePath(world, rand, position.m_5484_(Direction.EAST, size - 2), 5 + rand.nextInt(20), Direction.EAST, roomChance);
            }
        }
    }

    private void generateEntrance(LevelAccessor world, Random rand, BlockPos position, int size, int height, Direction direction) {
        BlockPos up = position.m_7494_();
        this.hive.getEntranceBottoms().put(up, direction);
        while (up.m_123342_() < world.m_5452_(this.small ? Heightmap.Types.MOTION_BLOCKING_NO_LEAVES : Heightmap.Types.WORLD_SURFACE_WG, up).m_123342_() && !world.m_8055_(up).m_204336_(BlockTags.f_13106_)) {
            this.generateCircleRespectSky(world, rand, up, size, height, direction);
            up = up.m_7494_().m_142300_(direction);
        }
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        this.generateSphereRespectAir(world, rand, up, size + 4, height + 2, resin, sticky_resin);
        this.generateSphere(world, rand, up.m_7494_(), size, height, Blocks.f_50016_.m_49966_());
        this.decorateSphere(world, rand, up.m_7494_(), size, height - 1, RoomType.ENTERANCE);
        this.hive.getEntrances().put(up, direction);
        ++this.entrances;
    }

    private void generateCircle(LevelAccessor world, Random rand, BlockPos position, int size, int height, Direction direction) {
        int z;
        int x;
        float j;
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        int radius = size + 2;
        float i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(Mth.m_14031_((float)j) * i);
                z = (int)Math.floor(Mth.m_14089_((float)j) * i);
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    world.m_7731_(position.m_142082_(0, x, z), rand.nextInt(3) == 0 ? sticky_resin : resin, 2);
                } else {
                    world.m_7731_(position.m_142082_(x, z, 0), rand.nextInt(3) == 0 ? sticky_resin : resin, 2);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        radius -= 2;
        i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(Mth.m_14031_((float)j) * i * Mth.m_14036_((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                z = (int)Math.floor(Mth.m_14089_((float)j) * i * Mth.m_14036_((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    world.m_7731_(position.m_142082_(0, x, z), Blocks.f_50016_.m_49966_(), 2);
                } else {
                    world.m_7731_(position.m_142082_(x, z, 0), Blocks.f_50016_.m_49966_(), 2);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        this.decorateCircle(world, rand, position, size, height, direction);
    }

    private void generateCircleRespectSky(LevelAccessor world, Random rand, BlockPos position, int size, int height, Direction direction) {
        int z;
        int x;
        float j;
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        int radius = size + 2;
        float i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(Mth.m_14031_((float)j) * i);
                z = (int)Math.floor(Mth.m_14089_((float)j) * i);
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    if (!world.m_46861_(position.m_142082_(0, x, z))) {
                        world.m_7731_(position.m_142082_(0, x, z), rand.nextInt(3) == 0 ? sticky_resin : resin, 3);
                    }
                } else if (!world.m_46861_(position.m_142082_(x, z, 0))) {
                    world.m_7731_(position.m_142082_(x, z, 0), rand.nextInt(3) == 0 ? sticky_resin : resin, 3);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        radius -= 2;
        i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(Mth.m_14031_((float)j) * i * Mth.m_14036_((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                z = (int)Math.floor(Mth.m_14089_((float)j) * i * Mth.m_14036_((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    world.m_7731_(position.m_142082_(0, x, z), Blocks.f_50016_.m_49966_(), 3);
                } else {
                    world.m_7731_(position.m_142082_(x, z, 0), Blocks.f_50016_.m_49966_(), 3);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        this.decorateCircle(world, rand, position, size, height, direction);
    }

    private void generateCircleAir(LevelAccessor world, Random rand, BlockPos position, int size, int height, Direction direction) {
        int radius = size;
        float i = 0.0f;
        while (i < (float)radius) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                int x = (int)Math.floor(Mth.m_14031_((float)j) * i * Mth.m_14036_((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                int z = (int)Math.floor(Mth.m_14089_((float)j) * i * Mth.m_14036_((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    world.m_7731_(position.m_142082_(0, x, z), Blocks.f_50016_.m_49966_(), 2);
                } else {
                    world.m_7731_(position.m_142082_(x, z, 0), Blocks.f_50016_.m_49966_(), 2);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        this.decorateCircle(world, rand, position, size, height, direction);
    }

    public void generateSphere(LevelAccessor world, Random rand, BlockPos position, int size, int height, BlockState fill) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f * Mth.m_14036_((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || world.m_46859_(blockpos)) continue;
            world.m_7731_(blockpos, fill, 3);
        }
    }

    public void generateSphere(LevelAccessor world, Random rand, BlockPos position, int size, int height, BlockState fill, BlockState fill2) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f * Mth.m_14036_((float)rand.nextFloat(), (float)0.75f, (float)1.0f)))) continue;
            world.m_7731_(blockpos, rand.nextInt(3) == 0 ? fill2 : fill, 2);
        }
    }

    public void generateSphereRespectResin(LevelAccessor world, Random rand, BlockPos position, int size, int height, BlockState fill, BlockState fill2) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f * Mth.m_14036_((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || world.m_46859_(blockpos) && (!world.m_46859_(blockpos) || this.hasResinUnder(blockpos, world))) continue;
            world.m_7731_(blockpos, rand.nextInt(3) == 0 ? fill2 : fill, 2);
        }
    }

    public void generateSphereRespectAir(LevelAccessor world, Random rand, BlockPos position, int size, int height, BlockState fill, BlockState fill2) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f * Mth.m_14036_((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || world.m_46859_(blockpos)) continue;
            world.m_7731_(blockpos, rand.nextInt(3) == 0 ? fill2 : fill, 2);
        }
    }

    private boolean hasResinUnder(BlockPos pos, LevelAccessor world) {
        BlockPos copy = pos.m_7495_();
        while (world.m_46859_(copy) && copy.m_123342_() > 1) {
            copy = copy.m_7495_();
        }
        return world.m_8055_(copy).m_60734_() instanceof BlockMyrmexResin || world.m_8055_(copy).m_60734_() instanceof BlockMyrmexConnectedResin;
    }

    private void decorateCircle(LevelAccessor world, Random rand, BlockPos position, int size, int height, Direction direction) {
        int radius = size + 2;
        float i = 0.0f;
        while (i < (float)radius) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                int x = (int)Math.floor(Mth.m_14031_((float)j) * i);
                int z = (int)Math.floor(Mth.m_14089_((float)j) * i);
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    if (world.m_46859_(position.m_142082_(0, x, z))) {
                        this.decorate(world, position.m_142082_(0, x, z), position, size, rand, RoomType.TUNNEL);
                    }
                    if (world.m_46859_(position.m_142082_(0, x, z))) {
                        this.decorateTubers(world, position.m_142082_(0, x, z), rand, RoomType.TUNNEL);
                    }
                } else {
                    if (world.m_46859_(position.m_142082_(x, z, 0))) {
                        this.decorate(world, position.m_142082_(x, z, 0), position, size, rand, RoomType.TUNNEL);
                    }
                    if (world.m_46859_(position.m_142082_(0, x, z))) {
                        this.decorateTubers(world, position.m_142082_(0, x, z), rand, RoomType.TUNNEL);
                    }
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
    }

    private void decorateSphere(LevelAccessor world, Random rand, BlockPos position, int size, int height, RoomType roomType) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k + 1, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f))) continue;
            if (world.m_8055_(blockpos.m_7495_()).m_60815_() && world.m_46859_(blockpos)) {
                this.decorate(world, blockpos, position, size, rand, roomType);
            }
            if (!world.m_46859_(blockpos)) continue;
            this.decorateTubers(world, blockpos, rand, roomType);
        }
    }

    private void decorate(LevelAccessor world, BlockPos blockpos, BlockPos center, int size, Random random, RoomType roomType) {
        switch (roomType) {
            case FOOD: {
                if (random.nextInt(45) == 0 && world.m_8055_(blockpos.m_7495_()).m_60734_() instanceof BlockMyrmexResin) {
                    WorldGenMyrmexDecoration.generateSkeleton(world, blockpos, center, size, random);
                }
                if (random.nextInt(13) == 0) {
                    WorldGenMyrmexDecoration.generateLeaves(world, blockpos, center, size, random, this.jungle);
                }
                if (random.nextInt(12) == 0) {
                    WorldGenMyrmexDecoration.generatePumpkins(world, blockpos, center, size, random, this.jungle);
                }
                if (random.nextInt(6) == 0) {
                    WorldGenMyrmexDecoration.generateMushrooms(world, blockpos, center, size, random);
                }
                if (random.nextInt(12) != 0) break;
                WorldGenMyrmexDecoration.generateCocoon(world, blockpos, random, this.jungle, this.jungle ? WorldGenMyrmexDecoration.JUNGLE_MYRMEX_FOOD_CHEST : WorldGenMyrmexDecoration.DESERT_MYRMEX_FOOD_CHEST);
                break;
            }
            case NURSERY: {
                break;
            }
            case SHINY: {
                if (random.nextInt(12) != 0) break;
                WorldGenMyrmexDecoration.generateGold(world, blockpos, center, size, random);
                break;
            }
            case TRASH: {
                if (random.nextInt(24) == 0) {
                    WorldGenMyrmexDecoration.generateTrashHeap(world, blockpos, center, size, random);
                }
                if (random.nextBoolean()) {
                    WorldGenMyrmexDecoration.generateTrashOre(world, blockpos, center, size, random);
                }
                if (random.nextInt(12) != 0) break;
                WorldGenMyrmexDecoration.generateCocoon(world, blockpos, random, this.jungle, WorldGenMyrmexDecoration.MYRMEX_TRASH_CHEST);
                break;
            }
        }
    }

    private void decorateTubers(LevelAccessor world, BlockPos blockpos, Random random, RoomType roomType) {
        if (world.m_8055_(blockpos.m_7494_()).m_60815_() && random.nextInt(roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 20 : 6) == 0) {
            int tuberLength = roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 1 : (roomType == RoomType.QUEEN ? 1 + random.nextInt(5) : 1 + random.nextInt(3));
            for (int i = 0; i < tuberLength; ++i) {
                if (!world.m_46859_(blockpos.m_6625_(i))) continue;
                boolean connected = i != tuberLength - 1;
                world.m_7731_(blockpos.m_6625_(i), this.jungle ? (BlockState)((Block)IafBlockRegistry.MYRMEX_JUNGLE_BIOLIGHT.get()).m_49966_().m_61124_((Property)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)) : (BlockState)((Block)IafBlockRegistry.MYRMEX_DESERT_BIOLIGHT.get()).m_49966_().m_61124_((Property)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)), 2);
            }
        }
    }

    public static enum RoomType {
        DEFAULT(false),
        TUNNEL(false),
        ENTERANCE(false),
        QUEEN(false),
        FOOD(true),
        EMPTY(true),
        NURSERY(true),
        SHINY(true),
        TRASH(true);

        boolean random;

        private RoomType(boolean random) {
            this.random = random;
        }

        public static RoomType random(Random rand) {
            ArrayList<RoomType> list = new ArrayList<RoomType>();
            for (RoomType type : RoomType.values()) {
                if (!type.random) continue;
                list.add(type);
            }
            return (RoomType)((Object)list.get(rand.nextInt(list.size())));
        }
    }
}

