/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockPixieHouse;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WorldGenPixieVillage
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public WorldGenPixieVillage(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos position = context.m_159777_();
        if (!IafConfig.spawnPixies || rand.nextInt(IafConfig.spawnPixiesChance) != 0 || !IafWorldRegistry.isFarEnoughFromSpawn((LevelAccessor)worldIn, position)) {
            return false;
        }
        position = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, position);
        int maxRoads = IafConfig.pixieVillageSize + rand.nextInt(5);
        BlockPos buildPosition = position;
        for (int placedRoads = 0; placedRoads < maxRoads; ++placedRoads) {
            int roadLength = 10 + rand.nextInt(15);
            Direction buildingDirection = Direction.m_122407_((int)rand.nextInt(3));
            for (int i = 0; i < roadLength; ++i) {
                BlockPos buildPosition2 = buildPosition.m_5484_(buildingDirection, i);
                if (worldIn.m_8055_(buildPosition2 = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, buildPosition2).m_7495_()).m_60819_().m_76178_()) {
                    worldIn.m_7731_(buildPosition2, Blocks.f_152481_.m_49966_(), 2);
                } else {
                    worldIn.m_7731_(buildPosition2, Blocks.f_50741_.m_49966_(), 2);
                }
                if (rand.nextInt(8) != 0) continue;
                Direction houseDir = rand.nextBoolean() ? buildingDirection.m_122427_() : buildingDirection.m_122428_();
                BlockState houseState = ((Block)IafBlockRegistry.PIXIE_HOUSE_OAK.get()).m_49966_();
                int houseColor = rand.nextInt(5);
                switch (houseColor) {
                    case 0: {
                        houseState = (BlockState)((Block)IafBlockRegistry.PIXIE_HOUSE_MUSHROOM_RED.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        break;
                    }
                    case 1: {
                        houseState = (BlockState)((Block)IafBlockRegistry.PIXIE_HOUSE_MUSHROOM_BROWN.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        break;
                    }
                    case 2: {
                        houseState = (BlockState)((Block)IafBlockRegistry.PIXIE_HOUSE_OAK.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        break;
                    }
                    case 3: {
                        houseState = (BlockState)((Block)IafBlockRegistry.PIXIE_HOUSE_BIRCH.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        break;
                    }
                    case 4: {
                        houseState = (BlockState)((Block)IafBlockRegistry.PIXIE_HOUSE_SPRUCE.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        break;
                    }
                    case 5: {
                        houseState = (BlockState)((Block)IafBlockRegistry.PIXIE_HOUSE_DARK_OAK.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                    }
                }
                EntityPixie pixie = (EntityPixie)((EntityType)IafEntityRegistry.PIXIE.get()).m_20615_((Level)worldIn.m_6018_());
                pixie.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(buildPosition2.m_7494_()), MobSpawnType.SPAWNER, null, null);
                pixie.m_6034_(buildPosition2.m_123341_(), buildPosition2.m_123342_() + 2, buildPosition2.m_123343_());
                pixie.m_21530_();
                worldIn.m_7967_((Entity)pixie);
                worldIn.m_7731_(buildPosition2.m_142300_(houseDir).m_7494_(), houseState, 2);
                if (worldIn.m_8055_(buildPosition2.m_142300_(houseDir)).m_60815_()) continue;
                worldIn.m_7731_(buildPosition2.m_142300_(houseDir), Blocks.f_50546_.m_49966_(), 2);
                worldIn.m_7731_(buildPosition2.m_142300_(houseDir).m_7495_(), Blocks.f_50546_.m_49966_(), 2);
            }
            buildPosition = buildPosition.m_5484_(buildingDirection, rand.nextInt(roadLength));
        }
        return true;
    }
}

