/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WorldGenSirenIsland
extends Feature<NoneFeatureConfiguration> {
    public WorldGenSirenIsland(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos stonePos;
        float j;
        float i;
        WorldGenLevel worldIn = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos position = context.m_159777_();
        if (!(IafConfig.generateSirenIslands && rand.nextInt(IafConfig.generateSirenChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((LevelAccessor)worldIn, position) && IafWorldRegistry.isFarEnoughFromDangerousGen((ServerLevelAccessor)worldIn, position))) {
            return false;
        }
        position = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, position);
        int up = rand.nextInt(4) + 1;
        BlockPos center = position.m_6630_(up);
        int layer = 0;
        int sirens = 0;
        int sirensMax = 1 + rand.nextInt(3);
        while (!worldIn.m_8055_(center).m_60815_() && center.m_123342_() >= 0) {
            ++layer;
            i = 0.0f;
            while (i < (float)this.getRadius(layer, up)) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i + (double)rand.nextInt(2)) {
                    stonePos = new BlockPos(Math.floor((float)center.m_123341_() + Mth.m_14031_((float)j) * i + (float)rand.nextInt(2)), (double)center.m_123342_(), Math.floor((float)center.m_123343_() + Mth.m_14089_((float)j) * i + (float)rand.nextInt(2)));
                    worldIn.m_7731_(stonePos, this.getStone(rand), 3);
                    BlockPos upPos = stonePos.m_7494_();
                    if (worldIn.m_46859_(upPos) && worldIn.m_46859_(upPos.m_142126_()) && worldIn.m_46859_(upPos.m_142127_()) && worldIn.m_46859_(upPos.m_142127_().m_142126_()) && rand.nextInt(3) == 0 && sirens < sirensMax) {
                        ++sirens;
                        this.spawnSiren((ServerLevelAccessor)worldIn, rand, upPos.m_142127_().m_142126_());
                    }
                    j = (float)((double)j + 0.5);
                }
                i = (float)((double)i + 0.5);
            }
            center = center.m_7495_();
        }
        ++layer;
        i = 0.0f;
        while (i < (float)this.getRadius(layer, up)) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i + (double)rand.nextInt(2)) {
                stonePos = new BlockPos(Math.floor((float)center.m_123341_() + Mth.m_14031_((float)j) * i + (float)rand.nextInt(2)), (double)center.m_123342_(), Math.floor((float)center.m_123343_() + Mth.m_14089_((float)j) * i + (float)rand.nextInt(2)));
                while (!worldIn.m_8055_(stonePos).m_60815_() && stonePos.m_123342_() >= 0) {
                    worldIn.m_7731_(stonePos, this.getStone(rand), 3);
                    stonePos = stonePos.m_7495_();
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        return true;
    }

    private int getRadius(int layer, int up) {
        return layer > up ? (int)((double)layer * 0.25) + up : layer;
    }

    private BlockState getStone(Random random) {
        int chance = random.nextInt(100);
        if (chance > 90) {
            return Blocks.f_50079_.m_49966_();
        }
        if (chance > 70) {
            return Blocks.f_49994_.m_49966_();
        }
        if (chance > 45) {
            return Blocks.f_50652_.m_49966_();
        }
        return Blocks.f_50069_.m_49966_();
    }

    private void spawnSiren(ServerLevelAccessor worldIn, Random rand, BlockPos position) {
        EntitySiren siren = new EntitySiren((EntityType<EntitySiren>)((EntityType)IafEntityRegistry.SIREN.get()), (Level)worldIn.m_6018_());
        siren.setSinging(true);
        siren.setHairColor(rand.nextInt(2));
        siren.setSingingPose(rand.nextInt(2));
        siren.m_19890_((double)position.m_123341_() + 0.5, position.m_123342_() + 1, (double)position.m_123343_() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        worldIn.m_7967_((Entity)siren);
    }
}

