/*
 * Decompiled with CFR 0.152.
 */
package net.tct.matmos.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.tct.matmos.MatmosTctMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MatmosTctModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MatmosTctMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.DesertMusic = message.data.DesertMusic;
                    variables.JungleMusic = message.data.JungleMusic;
                    variables.DesertVillageMusic = message.data.DesertVillageMusic;
                    variables.NetherMusic = message.data.NetherMusic;
                    variables.EndMusic = message.data.EndMusic;
                    variables.BadlandsMusic = message.data.BadlandsMusic;
                    variables.MusicSettings = message.data.MusicSettings;
                    variables.WindSettings = message.data.WindSettings;
                    variables.InventorySettings = message.data.InventorySettings;
                    variables.CaveSettings = message.data.CaveSettings;
                    variables.NetherSettings = message.data.NetherSettings;
                    variables.WaterSettings = message.data.WaterSettings;
                    variables.AmbiantVolume = message.data.AmbiantVolume;
                    variables.PlayerVolume = message.data.PlayerVolume;
                    variables.PlayerTimer = message.data.PlayerTimer;
                    variables.SetConfigFiles = message.data.SetConfigFiles;
                    variables.MainItem = message.data.MainItem;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean DesertMusic = false;
        public boolean JungleMusic = false;
        public boolean DesertVillageMusic = false;
        public boolean NetherMusic = false;
        public boolean EndMusic = false;
        public boolean BadlandsMusic = false;
        public boolean MusicSettings = true;
        public boolean WindSettings = true;
        public boolean InventorySettings = true;
        public boolean CaveSettings = true;
        public boolean NetherSettings = true;
        public boolean WaterSettings = true;
        public double AmbiantVolume = 1.0;
        public double PlayerVolume = 1.0;
        public double PlayerTimer = 0.0;
        public boolean SetConfigFiles = false;
        public ItemStack MainItem = ItemStack.f_41583_;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MatmosTctMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("DesertMusic", this.DesertMusic);
            nbt.m_128379_("JungleMusic", this.JungleMusic);
            nbt.m_128379_("DesertVillageMusic", this.DesertVillageMusic);
            nbt.m_128379_("NetherMusic", this.NetherMusic);
            nbt.m_128379_("EndMusic", this.EndMusic);
            nbt.m_128379_("BadlandsMusic", this.BadlandsMusic);
            nbt.m_128379_("MusicSettings", this.MusicSettings);
            nbt.m_128379_("WindSettings", this.WindSettings);
            nbt.m_128379_("InventorySettings", this.InventorySettings);
            nbt.m_128379_("CaveSettings", this.CaveSettings);
            nbt.m_128379_("NetherSettings", this.NetherSettings);
            nbt.m_128379_("WaterSettings", this.WaterSettings);
            nbt.m_128347_("AmbiantVolume", this.AmbiantVolume);
            nbt.m_128347_("PlayerVolume", this.PlayerVolume);
            nbt.m_128347_("PlayerTimer", this.PlayerTimer);
            nbt.m_128379_("SetConfigFiles", this.SetConfigFiles);
            nbt.m_128365_("MainItem", (Tag)this.MainItem.m_41739_(new CompoundTag()));
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.DesertMusic = nbt.m_128471_("DesertMusic");
            this.JungleMusic = nbt.m_128471_("JungleMusic");
            this.DesertVillageMusic = nbt.m_128471_("DesertVillageMusic");
            this.NetherMusic = nbt.m_128471_("NetherMusic");
            this.EndMusic = nbt.m_128471_("EndMusic");
            this.BadlandsMusic = nbt.m_128471_("BadlandsMusic");
            this.MusicSettings = nbt.m_128471_("MusicSettings");
            this.WindSettings = nbt.m_128471_("WindSettings");
            this.InventorySettings = nbt.m_128471_("InventorySettings");
            this.CaveSettings = nbt.m_128471_("CaveSettings");
            this.NetherSettings = nbt.m_128471_("NetherSettings");
            this.WaterSettings = nbt.m_128471_("WaterSettings");
            this.AmbiantVolume = nbt.m_128459_("AmbiantVolume");
            this.PlayerVolume = nbt.m_128459_("PlayerVolume");
            this.PlayerTimer = nbt.m_128459_("PlayerTimer");
            this.SetConfigFiles = nbt.m_128471_("SetConfigFiles");
            this.MainItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("MainItem"));
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("matmos_tct", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.DesertMusic = original.DesertMusic;
            clone.JungleMusic = original.JungleMusic;
            clone.DesertVillageMusic = original.DesertVillageMusic;
            clone.NetherMusic = original.NetherMusic;
            clone.EndMusic = original.EndMusic;
            clone.BadlandsMusic = original.BadlandsMusic;
            clone.MusicSettings = original.MusicSettings;
            clone.WindSettings = original.WindSettings;
            clone.InventorySettings = original.InventorySettings;
            clone.CaveSettings = original.CaveSettings;
            clone.NetherSettings = original.NetherSettings;
            clone.WaterSettings = original.WaterSettings;
            clone.AmbiantVolume = original.AmbiantVolume;
            clone.PlayerVolume = original.PlayerVolume;
            clone.SetConfigFiles = original.SetConfigFiles;
            if (!event.isWasDeath()) {
                clone.PlayerTimer = original.PlayerTimer;
                clone.MainItem = original.MainItem;
            }
        }
    }
}

