/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.worldgen.structures;

import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function7;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public abstract class AwesomePlacementRndSpread
implements StructurePlacement {
    protected final int spacing;
    protected final int separation;
    protected final int salt;
    protected final RandomSpreadType spreadType;
    protected final Vec3i locateOffset;
    protected final String uniqueIdentifier;
    protected final boolean useValueFromConfiguration;

    public static <T extends AwesomePlacementRndSpread> Codec<T> createCodec(Function7<Integer, Integer, RandomSpreadType, Integer, Vec3i, String, Boolean, T> awsRandomSpread) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(AwesomePlacementRndSpread::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(AwesomePlacementRndSpread::separation), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(AwesomePlacementRndSpread::spreadType), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(AwesomePlacementRndSpread::salt), (App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(AwesomePlacementRndSpread::locateOffset), (App)Codec.STRING.optionalFieldOf("unique_identifier", (Object)"").forGetter(AwesomePlacementRndSpread::uniqueIdentifier), (App)Codec.BOOL.optionalFieldOf("use_value_from_config_file", (Object)false).forGetter(AwesomePlacementRndSpread::useValueFromConfiguration)).apply((Applicative)i, i.stable((Object)awsRandomSpread))).flatXmap(r -> r.spacing <= r.separation ? DataResult.error((String)"Spacing has to be larger than separation") : (r.useValueFromConfiguration && r.uniqueIdentifier.length() <= 1 ? DataResult.error((String)"Require String field `unique_identifier` if use value from configuration") : DataResult.success((Object)r)), DataResult::success).codec();
    }

    public AwesomePlacementRndSpread(int spacing, int separation, RandomSpreadType spreadType, int salt, Vec3i locateOffset, String uniqueIdentifier, boolean useValueFromConfiguration) {
        this.useValueFromConfiguration = useValueFromConfiguration;
        this.uniqueIdentifier = uniqueIdentifier;
        this.spacing = this.useValueFromConfiguration ? this.bindSpacingFromConfiguration() : spacing;
        this.separation = this.useValueFromConfiguration ? this.bindSeparationFromConfiguration() : separation;
        this.salt = this.useValueFromConfiguration ? this.bindSaltFromConfiguration() : salt;
        this.spreadType = spreadType;
        this.locateOffset = locateOffset;
        LibraryFerret.LOGGER.info(this.toString());
    }

    public ChunkPos getPotentialFeatureChunk(long seed, int x, int y) {
        int i = this.spacing();
        int j = this.separation();
        int k = Math.floorDiv(x, i);
        int l = Math.floorDiv(y, i);
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190058_(seed, k, l, this.salt());
        int i1 = i - j;
        int j1 = this.spreadType().m_205024_((RandomSource)worldgenrandom, i1);
        int k1 = this.spreadType().m_205024_((RandomSource)worldgenrandom, i1);
        return new ChunkPos(k * i + j1, l * i + k1);
    }

    public boolean m_212129_(ChunkGenerator chunkGenerator, long seed, int x, int y) {
        ChunkPos chunkpos = this.getPotentialFeatureChunk(seed, x, y);
        return chunkpos.f_45578_ == x && chunkpos.f_45579_ == y;
    }

    public int spacing() {
        return this.spacing;
    }

    public int separation() {
        return this.separation;
    }

    public int salt() {
        return this.salt;
    }

    public RandomSpreadType spreadType() {
        return this.spreadType;
    }

    public Vec3i locateOffset() {
        return this.locateOffset;
    }

    private String uniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public boolean useValueFromConfiguration() {
        return this.useValueFromConfiguration;
    }

    public String toString() {
        return "Structure placement for `" + this.uniqueIdentifier + "`: { spacing: " + this.spacing + ", separation: " + this.separation + ", salt: " + this.salt + ", useValueFromConfiguration: " + this.useValueFromConfiguration + "}";
    }

    public RandomSpreadStructurePlacement toRandomSpreadPlacement() {
        return new RandomSpreadStructurePlacement(this.spacing, this.separation, this.spreadType, this.salt, this.locateOffset);
    }

    public abstract int bindSpacingFromConfiguration();

    public abstract int bindSeparationFromConfiguration();

    public abstract int bindSaltFromConfiguration();
}

