/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.worldgen.structures;

import com.google.common.collect.Lists;
import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public abstract class AwesomeStructure
extends StructureFeature<JigsawConfiguration> {
    public AwesomeStructure(int size, int distanceMaxFromCenter, BiFunction<PieceGeneratorSupplier.Context<JigsawConfiguration>, Heightmap.Types, Boolean> canGenerate) {
        this((PieceGeneratorSupplier.Context<JigsawConfiguration> ctx, Heightmap.Types height) -> ctx.f_197355_().m_151394_(0), Heightmap.Types.WORLD_SURFACE_WG, true, size, distanceMaxFromCenter, canGenerate);
    }

    public AwesomeStructure(BiFunction<PieceGeneratorSupplier.Context<JigsawConfiguration>, Heightmap.Types, BlockPos> initialPosition, Heightmap.Types heightmapType, boolean useHeightMapDuringPlacement, int size, int distanceMaxFromCenter, BiFunction<PieceGeneratorSupplier.Context<JigsawConfiguration>, Heightmap.Types, Boolean> canGenerate) {
        this(initialPosition, heightmapType, useHeightMapDuringPlacement, distanceMaxFromCenter, AwesomeStructure.getDefaultConfigurationCodec(size), canGenerate);
    }

    private AwesomeStructure(BiFunction<PieceGeneratorSupplier.Context<JigsawConfiguration>, Heightmap.Types, BlockPos> initialPosition, Heightmap.Types heightmapType, boolean useHeightMapDuringPlacement, int distanceMaxFromCenter, Codec<JigsawConfiguration> configCodec, BiFunction<PieceGeneratorSupplier.Context<JigsawConfiguration>, Heightmap.Types, Boolean> canGenerate) {
        super(configCodec, ctx -> (Boolean)canGenerate.apply(ctx, heightmapType) != false ? AwesomeStructure.createPiecesGenerator((PieceGeneratorSupplier.Context<JigsawConfiguration>)ctx, (BlockPos)initialPosition.apply(ctx, heightmapType), heightmapType, useHeightMapDuringPlacement, distanceMaxFromCenter) : Optional.empty(), PostPlacementProcessor.f_192427_);
        this.f_67036_ = AwesomeStructure.getDefaultStructureCodec(this, configCodec);
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context, BlockPos initialPosition, Heightmap.Types heightmapType, boolean useHeightMapDuringPlacement, int distanceMax) {
        return AwesomeStructure.addPieces(context, PoolElementStructurePiece::new, initialPosition, false, heightmapType, useHeightMapDuringPlacement, distanceMax);
    }

    private static Codec<JigsawConfiguration> getDefaultConfigurationCodec(int size) {
        return RecordCodecBuilder.create(instance -> instance.group((App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(JigsawConfiguration::m_204802_), (App)Codec.intRange((int)0, (int)(size + 1)).fieldOf("size").forGetter(JigsawConfiguration::m_67765_)).apply((Applicative)instance, JigsawConfiguration::new));
    }

    public static Codec<ConfiguredStructureFeature<JigsawConfiguration, StructureFeature<JigsawConfiguration>>> getDefaultStructureCodec(AwesomeStructure feature, Codec<JigsawConfiguration> configCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)configCodec.fieldOf("config").forGetter(configuredStructureFeature -> (JigsawConfiguration)configuredStructureFeature.f_65404_), (App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122885_).fieldOf("biomes").forGetter(ConfiguredStructureFeature::m_209752_), (App)Codec.BOOL.optionalFieldOf("adapt_noise", (Object)false).forGetter(configuredStructureFeature -> configuredStructureFeature.f_209745_), (App)Codec.simpleMap((Codec)MobCategory.f_21584_, (Codec)StructureSpawnOverride.f_210042_, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])MobCategory.values())).fieldOf("spawn_overrides").forGetter(configuredStructureFeature -> configuredStructureFeature.f_209744_)).apply((Applicative)instance, (featureConfig, biomeRegistryEntryList, useNoise, spawnsMap) -> {
            boolean isEnabledInConfiguration = feature.bindEnabledFromConfiguration(((StructureTemplatePool)featureConfig.m_204802_().m_203334_()).m_210587_().toString());
            if (!isEnabledInConfiguration) {
                LibraryFerret.LOGGER.info("structure disabled: " + ((StructureTemplatePool)featureConfig.m_204802_().m_203334_()).m_210587_());
            }
            return new ConfiguredStructureFeature((StructureFeature)feature, (FeatureConfiguration)featureConfig, (HolderSet)(isEnabledInConfiguration ? biomeRegistryEntryList : HolderSet.m_205809_((Holder[])new Holder[0])), useNoise.booleanValue(), spawnsMap);
        }));
    }

    public static boolean isValidStructureBiome(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PieceGeneratorSupplier.Context<JigsawConfiguration> ctx, int biomeRange) {
        if (!(ctx.f_197353_() instanceof CheckerboardColumnBiomeSource)) {
            ChunkPos chunkPos = ctx.f_197355_();
            for (int curChunkX = chunkPos.f_45578_ - biomeRange; curChunkX <= chunkPos.f_45578_ + biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - biomeRange; curChunkZ <= chunkPos.f_45579_ + biomeRange; ++curChunkZ) {
                    if (ctx.f_197358_().test(ctx.f_197352_().m_203495_(curChunkX << 2, 16, curChunkZ << 2))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEmptyFluidState(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PieceGeneratorSupplier.Context<JigsawConfiguration> ctx, @NotNull BlockPos position, LevelHeightAccessor heightLimitView, Heightmap.Types heightmapType) {
        return ctx.f_197352_().m_141914_(position.m_123341_(), position.m_123343_(), heightLimitView).m_183556_(ctx.f_197352_().m_156179_(position.m_123341_(), position.m_123343_(), heightmapType, heightLimitView)).m_60819_().m_76178_();
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> addPieces(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PieceGeneratorSupplier.Context<JigsawConfiguration> context, JigsawPlacement.PieceFactory pieceFactory, BlockPos pos, boolean modifyBoundingBox, Heightmap.Types heightmapType, boolean useHeightMapDuringPlacement, int distanceMax) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        RegistryAccess registryaccess = context.f_197360_();
        JigsawConfiguration jigsawconfiguration = (JigsawConfiguration)context.f_197356_();
        ChunkGenerator chunkgenerator = context.f_197352_();
        StructureManager structuremanager = context.f_197359_();
        LevelHeightAccessor levelheightaccessor = context.f_197357_();
        Predicate predicate = context.f_197358_();
        StructureFeature.m_67096_();
        Registry registry = registryaccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.m_55956_((Random)worldgenrandom);
        StructurePoolElement structurepoolelement = ((StructureTemplatePool)jigsawconfiguration.m_204802_().m_203334_()).m_210585_((Random)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece poolelementstructurepiece = pieceFactory.m_210300_(structuremanager, structurepoolelement, pos, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_207470_(structuremanager, pos, rotation));
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = useHeightMapDuringPlacement ? pos.m_123342_() + chunkgenerator.m_156174_(i, j, heightmapType, levelheightaccessor) : pos.m_123342_();
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        if (!predicate.test(chunkgenerator.m_203495_(QuartPos.m_175400_((int)i), QuartPos.m_175400_((int)k), QuartPos.m_175400_((int)j)))) {
            return Optional.empty();
        }
        poolelementstructurepiece.m_6324_(0, k - l, 0);
        return Optional.of((structurePiecesCollector, context1) -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (jigsawconfiguration.m_67765_() > 0) {
                JigsawPlacement.Placer jigsawplacement$placer = new JigsawPlacement.Placer(registry, jigsawconfiguration.m_67765_(), pieceFactory, chunkgenerator, structuremanager, (List)list, (Random)worldgenrandom);
                jigsawplacement$placer.f_210321_.addLast(new JigsawPlacement.PieceState(poolelementstructurepiece, new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)new AABB((double)(i - distanceMax), (double)(k - distanceMax), (double)(j - distanceMax), (double)(i + distanceMax + 1), (double)(k + distanceMax + 1), (double)(j + distanceMax + 1))), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_)), 0));
                while (!jigsawplacement$placer.f_210321_.isEmpty()) {
                    JigsawPlacement.PieceState jigsawplacement$piecestate = (JigsawPlacement.PieceState)jigsawplacement$placer.f_210321_.removeFirst();
                    jigsawplacement$placer.m_210333_(jigsawplacement$piecestate.f_210307_, jigsawplacement$piecestate.f_210308_, jigsawplacement$piecestate.f_210309_, modifyBoundingBox, levelheightaccessor);
                }
                list.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesCollector).m_142679_(arg_0));
            }
        });
    }

    public abstract boolean bindEnabledFromConfiguration(String var1);
}

