/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client.gui.features;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import worldcontrolteam.worldcontrol.network.ChannelHandler;
import worldcontrolteam.worldcontrol.network.messages.PacketUpdateHowlerAlarm;
import worldcontrolteam.worldcontrol.tileentity.TileEntityHowlerAlarm;

public class HowlerAlarmListBox
extends GuiButton {
    private static final String TEXTURE_FILE = "worldcontrol:textures/gui/GUIHowlerAlarm.png";
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("worldcontrol:textures/gui/GUIHowlerAlarm.png");
    private static final int BASIC_X_OFFSET = 2;
    private static final int BASIC_Y_OFFSET = 2;
    private static final int SCROLL_WIDTH = 10;
    private static final int SCROLL_BUTTON_HEIGHT = 8;
    public int fontColor;
    public int selectedColor;
    public int selectedFontColor;
    private int scrollTop;
    private List<String> items;
    private TileEntityHowlerAlarm alarm;
    public int lineHeight;
    private int sliderHeight;
    public boolean dragging;
    private int sliderY;
    private int dragDelta;

    public HowlerAlarmListBox(int id, int left, int top, int width, int height, List<String> items, TileEntityHowlerAlarm alarm) {
        super(id, left, top, width, height, "");
        this.items = items;
        this.alarm = alarm;
        this.fontColor = 0x404040;
        this.selectedColor = -12566464;
        this.selectedFontColor = 0xA0A0A0;
        this.scrollTop = 0;
        this.lineHeight = 0;
        this.sliderHeight = 0;
        this.dragging = false;
        this.dragDelta = 0;
    }

    private void scrollTo(int pos) {
        int max;
        this.scrollTop = pos;
        if (this.scrollTop < 0) {
            this.scrollTop = 0;
        }
        if ((max = this.lineHeight * this.items.size() + 2 - this.field_146121_g) < 0) {
            max = 0;
        }
        if (this.scrollTop > max) {
            this.scrollTop = max;
        }
    }

    public void scrollUp() {
        this.scrollTop -= 8;
        if (this.scrollTop < 0) {
            this.scrollTop = 0;
        }
    }

    public void scrollDown() {
        this.scrollTop += 8;
        int max = this.lineHeight * this.items.size() + 2 - this.field_146121_g;
        if (max < 0) {
            max = 0;
        }
        if (this.scrollTop > max) {
            this.scrollTop = max;
        }
    }

    public void func_146112_a(Minecraft minecraft, int cursorX, int cursorY) {
        if (this.dragging) {
            int pos = (cursorY - this.field_146129_i - 8 - this.dragDelta) * (this.lineHeight * this.items.size() + 2 - this.field_146121_g) / Math.max(this.field_146121_g - 16 - this.sliderHeight, 1);
            this.scrollTo(pos);
        }
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String currentItem = this.alarm.getSound();
        if (this.lineHeight == 0) {
            float scale;
            this.lineHeight = fontRenderer.field_78288_b + 2;
            if (this.scrollTop == 0) {
                int rowsPerHeight = this.field_146121_g / this.lineHeight;
                int currentIndex = this.items.indexOf(currentItem);
                if (currentIndex >= rowsPerHeight) {
                    this.scrollTop = (currentIndex + 1) * this.lineHeight + 2 - this.field_146121_g;
                }
            }
            if ((scale = (float)this.field_146121_g / ((float)this.lineHeight * (float)this.items.size() + 2.0f)) > 1.0f) {
                scale = 1.0f;
            }
            this.sliderHeight = Math.round(scale * (float)(this.field_146121_g - 16));
            if (this.sliderHeight < 4) {
                this.sliderHeight = 4;
            }
        }
        int rowTop = 2;
        GL11.glPushMatrix();
        GL11.glEnable((int)3089);
        Minecraft mc = FMLClientHandler.instance().getClient();
        ScaledResolution scaler = new ScaledResolution(mc);
        GL11.glScissor((int)(this.field_146128_h * scaler.func_78325_e()), (int)(mc.field_71440_d - (this.field_146129_i + this.field_146121_g) * scaler.func_78325_e()), (int)((this.field_146120_f - 10) * scaler.func_78325_e()), (int)(this.field_146121_g * scaler.func_78325_e()));
        for (String row : this.items) {
            if (row.equals(currentItem)) {
                HowlerAlarmListBox.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + rowTop - this.scrollTop - 1), (int)(this.field_146128_h + this.field_146120_f - 10), (int)(this.field_146129_i + rowTop - this.scrollTop + this.lineHeight - 1), (int)this.selectedColor);
                fontRenderer.func_78276_b(row, this.field_146128_h + 2, this.field_146129_i + rowTop - this.scrollTop, this.selectedFontColor);
            } else {
                fontRenderer.func_78276_b(row, this.field_146128_h + 2, this.field_146129_i + rowTop - this.scrollTop, this.fontColor);
            }
            rowTop += this.lineHeight;
        }
        GL11.glDisable((int)3089);
        int sliderX = this.field_146128_h + this.field_146120_f - 10 + 1;
        this.sliderY = this.field_146129_i + 8 + (this.field_146121_g - 16 - this.sliderHeight) * this.scrollTop / (this.lineHeight * this.items.size() + 2 - this.field_146121_g);
        minecraft.field_71446_o.func_110577_a(TEXTURE_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(sliderX, this.sliderY, 131, 16, 9, 1);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        HowlerAlarmListBox.draw(tessellator, sliderX, this.sliderY + this.sliderHeight - 1, this.field_73735_i, 0.51171875f, 0.0703125f);
        HowlerAlarmListBox.draw(tessellator, sliderX + 10 - 1, this.sliderY + this.sliderHeight - 1, this.field_73735_i, 0.546875f, 0.0703125f);
        HowlerAlarmListBox.draw(tessellator, sliderX + 10 - 1, this.sliderY + 1, this.field_73735_i, 0.546875f, 0.06640625f);
        HowlerAlarmListBox.draw(tessellator, sliderX, this.sliderY + 1, this.field_73735_i, 0.51171875f, 0.06640625f);
        tessellator.func_78381_a();
        this.func_73729_b(sliderX, this.sliderY + this.sliderHeight - 1, 131, 19, 9, 1);
        GL11.glPopMatrix();
    }

    private static void draw(Tessellator tess, double x, double y, double z, float U, float V) {
        tess.func_178180_c().func_181662_b(x, y, z);
        tess.func_178180_c().func_187315_a((double)U, (double)V);
        tess.func_178180_c().func_181666_a(1.0f, 1.0f, 1.0f, 1.0f);
        tess.func_178180_c().func_181675_d();
    }

    private void setCurrent(int targetY) {
        String newSound;
        if (this.lineHeight == 0) {
            return;
        }
        int itemIndex = (targetY - 2 - this.field_146129_i + this.scrollTop) / this.lineHeight;
        if (itemIndex >= this.items.size()) {
            itemIndex = this.items.size() - 1;
        }
        if (!(newSound = this.items.get(itemIndex)).equals(this.alarm.getSound())) {
            if (this.alarm.func_145831_w().field_72995_K) {
                ChannelHandler.network.sendToServer((IMessage)new PacketUpdateHowlerAlarm(this.alarm.getRange(), newSound, this.alarm.func_174877_v()));
            }
            this.alarm.setSound(newSound);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_146116_c(Minecraft minecraft, int targetX, int targetY) {
        if (!super.func_146116_c(minecraft, targetX, targetY)) return false;
        if (targetX > this.field_146128_h + this.field_146120_f - 10) {
            if (targetY - this.field_146129_i < 8) {
                this.scrollUp();
                return false;
            } else if (this.field_146121_g + this.field_146129_i - targetY < 8) {
                this.scrollDown();
                return false;
            } else {
                if (targetY < this.sliderY || targetY > this.sliderY + this.sliderHeight) return false;
                this.dragging = true;
                this.dragDelta = targetY - this.sliderY;
            }
            return false;
        } else {
            this.setCurrent(targetY);
            return true;
        }
    }

    public void func_146118_a(int i, int j) {
        super.func_146118_a(i, j);
        this.dragging = false;
    }
}

