/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.items;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import worldcontrolteam.worldcontrol.api.card.CardState;
import worldcontrolteam.worldcontrol.api.card.IProviderCard;
import worldcontrolteam.worldcontrol.api.card.StringWrapper;
import worldcontrolteam.worldcontrol.items.WCBaseItem;
import worldcontrolteam.worldcontrol.utils.NBTUtils;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public abstract class ItemBaseCard
extends WCBaseItem
implements IProviderCard {
    public ItemBaseCard(String name) {
        super(name);
    }

    @Override
    public abstract CardState update(World var1, ItemStack var2);

    @Override
    public abstract List<StringWrapper> getStringData(List<StringWrapper> var1, int var2, ItemStack var3, boolean var4);

    @Override
    public abstract List<String> getGuiData();

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract int getCardColor();

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        try {
            NBTTagCompound nbt = stack.func_77978_p();
            BlockPos pos = NBTUtils.getBlockPos(nbt);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            tooltip.add(WCUtility.translateFormatted("card.cords", x, y, z));
        }
        catch (NullPointerException e) {
            tooltip.add(WCUtility.translate("card.no_cords"));
        }
    }
}

