/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.common.inventory.ContainerChiselHitech;

public class PacketChiselButton
implements IMessage {
    private int[] slotIds;

    public PacketChiselButton(int ... slots) {
        this.slotIds = slots;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.slotIds.length);
        for (int i : this.slotIds) {
            buf.writeByte(i);
        }
    }

    public void fromBytes(ByteBuf buf) {
        byte len = buf.readByte();
        this.slotIds = new int[len];
        for (int i = 0; i < this.slotIds.length; ++i) {
            this.slotIds[i] = buf.readByte();
        }
    }

    public static void chiselAll(EntityPlayer player, int[] slots) {
        if (player.field_71070_bA instanceof ContainerChiselHitech) {
            ContainerChiselHitech container = (ContainerChiselHitech)player.field_71070_bA;
            ItemStack chisel = container.getChisel();
            ItemStack target = container.getTargetStack();
            ICarvingRegistry carving = CarvingUtils.getChiselRegistry();
            if (chisel == null || target == null) {
                return;
            }
            for (int i : slots) {
                Optional.ofNullable(player.field_71071_by.func_70301_a(i)).ifPresent(s -> {
                    if (carving.getGroup(target) != carving.getGroup((ItemStack)s)) {
                        return;
                    }
                    ItemStack stack = target.func_77946_l();
                    int toCraft = s.field_77994_a;
                    if (chisel.func_77984_f()) {
                        int damageLeft = chisel.func_77958_k() - chisel.func_77952_i() + 1;
                        stack.field_77994_a = toCraft = Math.min(toCraft, damageLeft);
                        chisel.func_77972_a(toCraft, (EntityLivingBase)player);
                    }
                    player.field_71071_by.func_70299_a(i, stack);
                    if (chisel.field_77994_a <= 0) {
                        container.getInventoryChisel().getStackInSpecialSlot().field_77994_a = s.field_77994_a - toCraft;
                        player.field_71071_by.func_70299_a(container.getChiselSlot(), null);
                        if (s.field_77994_a > toCraft) {
                            ItemStack remainder = s.func_77946_l();
                            remainder.field_77994_a = s.field_77994_a - toCraft;
                            if (!player.field_71071_by.func_70441_a(remainder)) {
                                player.func_71019_a(remainder, false);
                            }
                        }
                    }
                });
                if (chisel.field_77994_a >= 1) continue;
                return;
            }
        }
    }

    public PacketChiselButton() {
    }

    public static class Handler
    implements IMessageHandler<PacketChiselButton, IMessage> {
        public IMessage onMessage(PacketChiselButton message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> PacketChiselButton.chiselAll((EntityPlayer)player, message.slotIds));
            return null;
        }
    }
}

