/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.chisel.common.util.NBTUtil;

public class PacketHitechSettings
implements IMessage {
    private byte type;
    private int selection;
    private int target;
    private boolean rotate;
    private int chiselSlot;

    public PacketHitechSettings(@Nonnull ItemStack stack, int chiselSlot) {
        this.type = (byte)NBTUtil.getHitechType(stack).ordinal();
        this.selection = NBTUtil.getHitechSelection(stack);
        this.target = NBTUtil.getHitechTarget(stack);
        this.rotate = NBTUtil.getHitechRotate(stack);
        this.chiselSlot = chiselSlot;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.type);
        buf.writeInt(this.selection);
        buf.writeInt(this.target);
        buf.writeBoolean(this.rotate);
        buf.writeByte(this.chiselSlot);
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readByte();
        this.selection = buf.readInt();
        this.target = buf.readInt();
        this.rotate = buf.readBoolean();
        this.chiselSlot = buf.readByte();
    }

    public PacketHitechSettings() {
    }

    public static class Handler
    implements IMessageHandler<PacketHitechSettings, IMessage> {
        public IMessage onMessage(PacketHitechSettings message, MessageContext ctx) {
            ItemStack stack = ctx.getServerHandler().field_147369_b.field_71071_by.func_70301_a(message.chiselSlot);
            if (stack != null) {
                NBTUtil.setHitechType(stack, message.type);
                NBTUtil.setHitechSelection(stack, message.selection);
                NBTUtil.setHitechTarget(stack, message.target);
                NBTUtil.setHitechRotate(stack, message.rotate);
            }
            return null;
        }
    }
}

