/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.infinitefluids;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="infinitefluids", version="1.1.0", dependencies="required-after:Forge@[12.18.1.2023,)", guiFactory="josephcsible.infinitefluids.InfiniteFluidsGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class InfiniteFluids {
    public static final String MODID = "infinitefluids";
    public static final String VERSION = "1.1.0";
    public static Configuration config;
    protected static boolean invertInsideNether;
    protected static boolean invertOutsideNether;
    protected static Set<String> fluidsInsideNether;
    protected static Set<String> fluidsOutsideNether;
    protected static final String[] INSIDE_NETHER_DEFAULT;
    protected static final String[] OUTSIDE_NETHER_DEFAULT;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        InfiniteFluids.syncConfig();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register(InfiniteFluids.class);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(MODID)) {
            InfiniteFluids.syncConfig();
        }
    }

    protected static void fixVanillaFlowing(Set<String> s) {
        if (s.contains("minecraft:water")) {
            s.remove("minecraft:water");
            s.add("minecraft:flowing_water");
        }
        if (s.contains("minecraft:lava")) {
            s.remove("minecraft:lava");
            s.add("minecraft:flowing_lava");
        }
    }

    protected static void syncConfig() {
        config.setCategoryComment("general", "Use block names (like with /setblock) here, such as minecraft:lava or tconstruct:blueslime.");
        fluidsOutsideNether = new HashSet<String>(Arrays.asList(config.getStringList("fluidsOutsideNether", "general", OUTSIDE_NETHER_DEFAULT, "A list of fluids that will be infinite outside of the Nether (or any mod-added dimensions where water can't be placed)")));
        InfiniteFluids.fixVanillaFlowing(fluidsOutsideNether);
        invertOutsideNether = config.getBoolean("invertOutsideNether", "general", false, "Whether to invert the function of fluidsOutsideNether (i.e., make all fluids infinite except those listed)");
        fluidsInsideNether = new HashSet<String>(Arrays.asList(config.getStringList("fluidsInsideNether", "general", INSIDE_NETHER_DEFAULT, "A list of fluids that will be infinite inside of the Nether (and any mod-added dimensions where water can't be placed)")));
        InfiniteFluids.fixVanillaFlowing(fluidsInsideNether);
        invertInsideNether = config.getBoolean("invertInsideNether", "general", false, "Whether to invert the function of fluidsInsideNether (i.e., make all fluids infinite except those listed)");
        if (config.hasChanged()) {
            config.save();
        }
    }

    protected static boolean fluidIsInfinite(Block block, World world) {
        if (world.field_73011_w.func_177500_n()) {
            return fluidsInsideNether.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString()) ^ invertInsideNether;
        }
        return fluidsOutsideNether.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString()) ^ invertOutsideNether;
    }

    @SubscribeEvent
    public static void onCreateFluidSource(BlockEvent.CreateFluidSourceEvent event) {
        Block block = event.getState().func_177230_c();
        if (InfiniteFluids.fluidIsInfinite(block, event.getWorld())) {
            if (block != Blocks.field_150358_i) {
                event.setResult(Event.Result.ALLOW);
            }
        } else if (block == Blocks.field_150358_i) {
            event.setResult(Event.Result.DENY);
        }
    }

    static {
        INSIDE_NETHER_DEFAULT = new String[0];
        OUTSIDE_NETHER_DEFAULT = new String[]{"minecraft:water"};
    }
}

