/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitComponent;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduit.liquid.AdvancedLiquidConduitNetwork;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.conduit.liquid.LiquidOutput;
import crazypants.enderio.conduit.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.render.IBlockStateWrapper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancedLiquidConduit
extends AbstractTankConduit
implements IConduitComponent {
    public static final int CONDUIT_VOLUME = 1000;
    public static final String ICON_KEY = "enderio:blocks/liquidConduitAdvanced";
    public static final String ICON_KEY_LOCKED = "enderio:blocks/liquidConduitAdvancedLocked";
    public static final String ICON_CORE_KEY = "enderio:blocks/liquidConduitCoreAdvanced";
    public static final String ICON_EXTRACT_KEY = "enderio:blocks/liquidConduitAdvancedInput";
    public static final String ICON_INSERT_KEY = "enderio:blocks/liquidConduitAdvancedOutput";
    public static final String ICON_EMPTY_EDGE = "enderio:blocks/liquidConduitAdvancedEdge";
    static final Map<String, TextureAtlasSprite> ICONS = new HashMap<String, TextureAtlasSprite>();
    private AdvancedLiquidConduitNetwork network;
    private long ticksSinceFailedExtract = 0L;
    public static final int MAX_EXTRACT_PER_TICK = Config.advancedFluidConduitExtractRate;
    public static final int MAX_IO_PER_TICK = Config.advancedFluidConduitMaxIoRate;

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(TextureMap register) {
                ICONS.put(AdvancedLiquidConduit.ICON_KEY, register.func_174942_a(new ResourceLocation(AdvancedLiquidConduit.ICON_KEY)));
                ICONS.put(AdvancedLiquidConduit.ICON_CORE_KEY, register.func_174942_a(new ResourceLocation(AdvancedLiquidConduit.ICON_CORE_KEY)));
                ICONS.put(AdvancedLiquidConduit.ICON_EMPTY_EDGE, register.func_174942_a(new ResourceLocation(AdvancedLiquidConduit.ICON_EMPTY_EDGE)));
                ICONS.put(AdvancedLiquidConduit.ICON_KEY_LOCKED, register.func_174942_a(new ResourceLocation(AdvancedLiquidConduit.ICON_KEY_LOCKED)));
                ICONS.put(AdvancedLiquidConduit.ICON_INSERT_KEY, register.func_174942_a(new ResourceLocation(AdvancedLiquidConduit.ICON_INSERT_KEY)));
                ICONS.put(AdvancedLiquidConduit.ICON_EXTRACT_KEY, register.func_174942_a(new ResourceLocation(AdvancedLiquidConduit.ICON_EXTRACT_KEY)));
            }
        });
    }

    public AdvancedLiquidConduit() {
        this.updateTank();
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (world.field_72995_K) {
            return;
        }
        this.doExtract();
        if (this.stateDirty) {
            this.getBundle().dirty();
            this.stateDirty = false;
        }
    }

    private void doExtract() {
        if (!this.hasExtractableMode()) {
            return;
        }
        if (this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25L && this.ticksSinceFailedExtract % 10L != 0L) {
            return;
        }
        for (EnumFacing dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir, MAX_EXTRACT_PER_TICK)) continue;
            this.ticksSinceFailedExtract = 0L;
        }
    }

    @Override
    protected void updateTank() {
        this.tank.setCapacity(1000);
        if (this.network != null) {
            this.network.updateConduitVolumes();
        }
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack(ModObject.itemLiquidConduit.getItem(), 1, 1);
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            this.network = null;
            return true;
        }
        if (!(network instanceof AdvancedLiquidConduitNetwork)) {
            return false;
        }
        AdvancedLiquidConduitNetwork n = (AdvancedLiquidConduitNetwork)network;
        if (this.tank.getFluid() == null) {
            this.tank.setLiquid(n.getFluidType() == null ? null : n.getFluidType().copy());
        } else if (n.getFluidType() == null) {
            n.setFluidType(this.tank.getFluid());
        } else if (!this.tank.getFluid().isFluidEqual(n.getFluidType())) {
            return false;
        }
        this.network = n;
        return true;
    }

    @Override
    public boolean canConnectToConduit(EnumFacing direction, IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        if (!(con instanceof AdvancedLiquidConduit)) {
            return false;
        }
        if (this.getFluidType() != null && ((AdvancedLiquidConduit)con).getFluidType() == null) {
            return false;
        }
        return LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), ((AdvancedLiquidConduit)con).getFluidType());
    }

    @Override
    public void setConnectionMode(EnumFacing dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshInputs(dir);
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, EnumFacing dir) {
        super.setExtractionRedstoneMode(mode, dir);
        this.refreshInputs(dir);
    }

    private void refreshInputs(EnumFacing dir) {
        if (this.network == null) {
            return;
        }
        LiquidOutput lo = new LiquidOutput(this.getLocation().getLocation(dir), dir.func_176734_d());
        this.network.removeInput(lo);
        if (this.canInputToDir(dir) && this.containsExternalConnection(dir)) {
            this.network.addInput(lo);
        }
    }

    @Override
    public void externalConnectionAdded(EnumFacing fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshInputs(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(EnumFacing fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshInputs(fromDirection);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForState(CollidableComponent component) {
        if (component.dir == null) {
            return ICONS.get(ICON_CORE_KEY);
        }
        return this.fluidTypeLocked ? ICONS.get(ICON_KEY_LOCKED) : ICONS.get(ICON_KEY);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInputMode() {
        return ICONS.get(ICON_EXTRACT_KEY);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForOutputMode() {
        return ICONS.get(ICON_INSERT_KEY);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getNotSetEdgeTexture() {
        return ICONS.get(ICON_EMPTY_EDGE);
    }

    @Override
    public TextureAtlasSprite getTransmitionTextureForState(CollidableComponent component) {
        if (this.isActive() && this.tank.containsValidLiquid()) {
            return RenderUtil.getStillTexture((FluidStack)this.tank.getFluid());
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(CollidableComponent component) {
        if (this.isActive() && this.tank.containsValidLiquid()) {
            int color = this.tank.getFluid().getFluid().getColor(this.tank.getFluid());
            return new Vector4f((double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color & 0xFF) / 255.0, 1.0);
        }
        return null;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.network == null || !this.getConnectionMode(from).acceptsInput()) {
            return 0;
        }
        return this.network.fill(from, resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (this.network == null || !this.getConnectionMode(from).acceptsOutput()) {
            return null;
        }
        return this.network.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.network == null || !this.getConnectionMode(from).acceptsOutput()) {
            return null;
        }
        return this.network.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.network == null) {
            return false;
        }
        return this.canExtractFromDir(from) && LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), new FluidStack(fluid, 0));
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (this.network == null) {
            return false;
        }
        return this.canInputToDir(from) && LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), new FluidStack(fluid, 0));
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.network == null) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    @Override
    protected boolean canJoinNeighbour(ILiquidConduit n) {
        return n instanceof AdvancedLiquidConduit;
    }

    @Override
    public AbstractTankConduitNetwork<? extends AbstractTankConduit> getTankNetwork() {
        return this.network;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(IBlockStateWrapper wrapper, BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(wrapper, hashCodes);
        FluidStack fluidType = this.getFluidType();
        if (fluidType != null && fluidType.getFluid() != null) {
            hashCodes.add(fluidType.getFluid());
        }
    }

    public AdvancedLiquidConduitNetwork createNetworkForType() {
        return new AdvancedLiquidConduitNetwork();
    }
}

