/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.ExistingItemFilter;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketExistingItemFilterSnapshot
extends AbstractConduitPacket<IItemConduit>
implements IMessageHandler<PacketExistingItemFilterSnapshot, IMessage> {
    private EnumFacing dir;
    private Opcode opcode;
    private boolean isInput;

    public PacketExistingItemFilterSnapshot() {
    }

    public PacketExistingItemFilterSnapshot(IItemConduit con, EnumFacing dir, boolean isInput, Opcode opcode) {
        super(con.getBundle().getEntity(), con);
        this.dir = dir;
        this.isInput = isInput;
        this.opcode = opcode;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = EnumFacing.values()[buf.readShort()];
        this.isInput = buf.readBoolean();
        this.opcode = Opcode.values()[buf.readByte() & 0xFF];
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
        buf.writeBoolean(this.isInput);
        buf.writeByte(this.opcode.ordinal());
    }

    public PacketExistingItemFilterSnapshot onMessage(PacketExistingItemFilterSnapshot message, MessageContext ctx) {
        IItemConduit conduit = (IItemConduit)message.getTileCasted(ctx);
        if (conduit == null) {
            return null;
        }
        ExistingItemFilter filter = message.isInput ? (ExistingItemFilter)conduit.getInputFilter(message.dir) : (ExistingItemFilter)conduit.getOutputFilter(message.dir);
        switch (message.opcode) {
            case CLEAR: {
                filter.setSnapshot((List<ItemStack>)null);
                break;
            }
            case SET: {
                ItemConduitNetwork icn = (ItemConduitNetwork)conduit.getNetwork();
                NetworkedInventory inv = icn.getInventory(conduit, message.dir);
                filter.setSnapshot(inv);
                break;
            }
            case MERGE: {
                ItemConduitNetwork icn = (ItemConduitNetwork)conduit.getNetwork();
                NetworkedInventory inv = icn.getInventory(conduit, message.dir);
                filter.mergeSnapshot(inv);
                break;
            }
            case SET_BLACK: {
                filter.setBlacklist(true);
                break;
            }
            case UNSET_BLACK: {
                filter.setBlacklist(false);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (message.isInput) {
            conduit.setInputFilter(message.dir, filter);
        } else {
            conduit.setOutputFilter(message.dir, filter);
        }
        return null;
    }

    public static enum Opcode {
        CLEAR,
        SET,
        MERGE,
        SET_BLACK,
        UNSET_BLACK;

    }
}

